/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.ContentCounts;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.sparkproject.guava.base.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ContentSummaryComputationContext {
    private FSDirectory dir = null;
    private FSNamesystem fsn = null;
    private BlockStoragePolicySuite bsps = null;
    private ContentCounts counts = null;
    private long nextCountLimit = 0L;
    private long limitPerRun = 0L;
    private long yieldCount = 0L;
    private long sleepMilliSec = 0L;
    private int sleepNanoSec = 0;

    public ContentSummaryComputationContext(FSDirectory dir, FSNamesystem fsn, long limitPerRun, long sleepMicroSec) {
        this.dir = dir;
        this.fsn = fsn;
        this.limitPerRun = limitPerRun;
        this.nextCountLimit = limitPerRun;
        this.counts = new ContentCounts.Builder().build();
        this.sleepMilliSec = sleepMicroSec / 1000L;
        this.sleepNanoSec = (int)(sleepMicroSec % 1000L * 1000L);
    }

    public ContentSummaryComputationContext(BlockStoragePolicySuite bsps) {
        this(null, null, 0L, 1000L);
        this.bsps = bsps;
    }

    public long getYieldCount() {
        return this.yieldCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean yield() {
        if (this.limitPerRun <= 0L || this.dir == null || this.fsn == null) {
            return false;
        }
        long currentCount = this.counts.getFileCount() + this.counts.getSymlinkCount() + this.counts.getDirectoryCount() + this.counts.getSnapshotableDirectoryCount();
        if (currentCount <= this.nextCountLimit) {
            return false;
        }
        this.nextCountLimit = currentCount + this.limitPerRun;
        try {
            Thread.sleep(this.sleepMilliSec, this.sleepNanoSec);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        ++this.yieldCount;
        return true;
    }

    public ContentCounts getCounts() {
        return this.counts;
    }

    public BlockStoragePolicySuite getBlockStoragePolicySuite() {
        Preconditions.checkState((this.bsps != null || this.fsn != null ? 1 : 0) != 0, (Object)"BlockStoragePolicySuite must be either initialized or available via FSNameSystem");
        return this.bsps != null ? this.bsps : this.fsn.getBlockManager().getStoragePolicySuite();
    }
}

