/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.SaveNamespaceCancelledException;
import org.apache.hadoop.hdfs.util.Canceler;
import org.sparkproject.guava.base.Preconditions;

class SaveNamespaceContext {
    private final FSNamesystem sourceNamesystem;
    private final long txid;
    private final List<Storage.StorageDirectory> errorSDs = Collections.synchronizedList(new ArrayList());
    private final Canceler canceller;
    private CountDownLatch completionLatch = new CountDownLatch(1);

    SaveNamespaceContext(FSNamesystem sourceNamesystem, long txid, Canceler canceller) {
        this.sourceNamesystem = sourceNamesystem;
        this.txid = txid;
        this.canceller = canceller;
    }

    FSNamesystem getSourceNamesystem() {
        return this.sourceNamesystem;
    }

    long getTxId() {
        return this.txid;
    }

    void reportErrorOnStorageDirectory(Storage.StorageDirectory sd) {
        this.errorSDs.add(sd);
    }

    List<Storage.StorageDirectory> getErrorSDs() {
        return this.errorSDs;
    }

    void markComplete() {
        Preconditions.checkState((this.completionLatch.getCount() == 1L ? 1 : 0) != 0, (Object)"Context already completed!");
        this.completionLatch.countDown();
    }

    void checkCancelled() throws SaveNamespaceCancelledException {
        if (this.canceller.isCancelled()) {
            throw new SaveNamespaceCancelledException(this.canceller.getCancellationReason());
        }
    }
}

