/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.hdfs.entity.FileProvenanceEntry;
import io.hops.metadata.hdfs.entity.StoredXAttr;
import io.hops.metadata.hdfs.entity.XAttrMetadataLogEntry;
import io.hops.transaction.EntityManager;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.sparkproject.guava.collect.Lists;

@InterfaceAudience.Private
public class XAttrStorage {
    public static XAttr readINodeXAttr(INode inode, XAttr attr) throws TransactionContextException, StorageException {
        List<XAttr> attrs = XAttrStorage.readINodeXAttrs(inode, Lists.newArrayList((Object[])new XAttr[]{attr}));
        if (attrs == null || attrs.isEmpty()) {
            return null;
        }
        return attrs.get(0);
    }

    public static List<XAttr> readINodeXAttrs(INode inode, List<XAttr> attrs) throws TransactionContextException, StorageException {
        XAttrFeature f = XAttrStorage.getXAttrFeature(inode);
        if (attrs == null || attrs.isEmpty()) {
            return f.getXAttrs();
        }
        return f.getXAttr(attrs);
    }

    public static void updateINodeXAttr(INode inode, XAttr xAttr, boolean xAttrExists, long namenodeId) throws IOException {
        XAttrFeature f = XAttrStorage.getXAttrFeature(inode);
        if (!xAttrExists) {
            f.addXAttr(xAttr);
            XAttrStorage.logMetadataEvent(inode, xAttr, XAttrMetadataLogEntry.Operation.Add);
            inode.logProvenanceEvent(namenodeId, FileProvenanceEntry.Operation.XATTR_ADD, xAttr);
        } else {
            f.updateXAttr(xAttr);
            XAttrStorage.logMetadataEvent(inode, xAttr, XAttrMetadataLogEntry.Operation.Update);
            inode.logProvenanceEvent(namenodeId, FileProvenanceEntry.Operation.XATTR_UPDATE, xAttr);
        }
    }

    public static void removeINodeXAttr(INode inode, XAttr xAttr, long namenodeId) throws IOException {
        XAttrFeature f = XAttrStorage.getXAttrFeature(inode);
        f.removeXAttr(xAttr);
        XAttrStorage.logMetadataEvent(inode, xAttr, XAttrMetadataLogEntry.Operation.Delete);
        inode.logProvenanceEvent(namenodeId, FileProvenanceEntry.Operation.XATTR_DELETE, xAttr);
    }

    private static XAttrFeature getXAttrFeature(INode inode) {
        XAttrFeature f = inode.getXAttrFeature();
        if (f == null) {
            f = new XAttrFeature(inode.getId());
            inode.addXAttrFeature(f);
        }
        return f;
    }

    public static int getMaxNumberOfUserXAttrPerInode() {
        return 127;
    }

    public static int getMaxNumberOfSysXAttrPerInode() {
        return 127;
    }

    public static int getMaxXAttrSize() {
        return XAttrStorage.getMaxXAttrNameSize() + XAttrStorage.getMaxXAttrValueSize();
    }

    public static int getDefaultXAttrSize() {
        return XAttrStorage.getMaxXAttrNameSize() + XAttrStorage.getDefaultXAttrValueSize();
    }

    public static int getMaxXAttrNameSize() {
        return 255;
    }

    public static int getDefaultXAttrValueSize() {
        return 13500;
    }

    public static int getMaxXAttrValueSize() {
        return 3442500;
    }

    public static int getXAttrByteSize(String str) {
        return StoredXAttr.getXAttrBytes((String)str).length;
    }

    private static void logMetadataEvent(INode inode, XAttr attr, XAttrMetadataLogEntry.Operation operation) throws TransactionContextException, StorageException {
        if (inode.isPathMetaEnabled()) {
            long datasetId = inode.getMetaEnabledParent().getId();
            long inodeId = inode.getId();
            int logicaltime = inode.incrementLogicalTime();
            inode.save();
            XAttrMetadataLogEntry logEntry = new XAttrMetadataLogEntry(datasetId, inodeId, logicaltime, inode.getPartitionId().longValue(), inode.getParentId(), inode.getLocalName(), attr.getValue(), attr.getNameSpace().getId(), attr.getName(), operation);
            EntityManager.add((Object)logEntry);
        }
    }
}

