/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationTaskStatus;
import org.apache.hadoop.conf.ReconfigurationUtil;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.shell.Command;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.client.BlockReportOptions;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeLocalInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RefreshCallQueueProtocol;
import org.apache.hadoop.ipc.RefreshResponse;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.protocolPB.GenericRefreshProtocolClientSideTranslatorPB;
import org.apache.hadoop.ipc.protocolPB.GenericRefreshProtocolPB;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.RefreshUserMappingsProtocol;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.RefreshAuthorizationPolicyProtocol;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.sparkproject.guava.base.Joiner;
import org.sparkproject.guava.base.Preconditions;

@InterfaceAudience.Private
public class DFSAdmin
extends FsShell {
    private static final Log LOG;
    private static final String commonUsageSummary = "\t[-report [-live] [-dead] [-decommissioning]]\n\t[-safemode <enter | leave | get | wait>]\n\t[-saveNamespace]\n\t[-rollEdits]\n\t[-restoreFailedStorage true|false|check]\n\t[-refreshNodes]\n\t[-setQuota <quota> <dirname>...<dirname>]\n\t[-clrQuota <dirname>...<dirname>]\n\t[-setSpaceQuota <quota> [-storageType <storagetype>] <dirname>...<dirname>]\n\t[-clrSpaceQuota [-storageType <storagetype>] <dirname>...<dirname>]\n\t[-finalizeUpgrade]\n\t[-rollingUpgrade [<query|prepare|finalize>]]\n\t[-refreshServiceAcl]\n\t[-refreshUserToGroupsMappings]\n\t[-refreshSuperUserGroupsConfiguration]\n\t[-refreshCallQueue]\n\t[-refresh <host:ipc_port> <key> [arg1..argn]\n\t[-reconfig <datanode|...> <host:ipc_port> <start|status>]\n\t[-printTopology]\n\t[-refreshNamenodes datanode_host:ipc_port]\n\t[-deleteBlockPool datanode_host:ipc_port blockpoolId [force]]\n\t[-setBalancerBandwidth <bandwidth in bytes per second>]\n\t[-fetchImage <local directory>]\n\t[-allowSnapshot <snapshotDir>]\n\t[-disallowSnapshot <snapshotDir>]\n\t[-shutdownDatanode <datanode_host:ipc_port> [upgrade]]\n\t[-getDatanodeInfo <datanode_host:ipc_port>]\n\t[-metasave filename]\n\t[-triggerBlockReport [-incremental] <datanode_host:ipc_port>]\n\t[-help [cmd]]\n";

    public DFSAdmin() {
        this(new HdfsConfiguration());
    }

    public DFSAdmin(Configuration conf) {
        super(conf);
    }

    protected DistributedFileSystem getDFS() throws IOException {
        FileSystem fs = this.getFS();
        if (!(fs instanceof DistributedFileSystem)) {
            throw new IllegalArgumentException("FileSystem " + fs.getUri() + " is not an HDFS file system");
        }
        return (DistributedFileSystem)fs;
    }

    public void report(String[] argv, int i) throws IOException {
        boolean listAll;
        DistributedFileSystem dfs = this.getDFS();
        FsStatus ds = dfs.getStatus();
        long capacity = ds.getCapacity();
        long used = ds.getUsed();
        long remaining = ds.getRemaining();
        long presentCapacity = used + remaining;
        boolean mode = dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET);
        if (mode) {
            System.out.println("Safe mode is ON");
        }
        System.out.println("Configured Capacity: " + capacity + " (" + StringUtils.byteDesc((long)capacity) + ")");
        System.out.println("Present Capacity: " + presentCapacity + " (" + StringUtils.byteDesc((long)presentCapacity) + ")");
        System.out.println("DFS Remaining: " + remaining + " (" + StringUtils.byteDesc((long)remaining) + ")");
        System.out.println("DFS Used: " + used + " (" + StringUtils.byteDesc((long)used) + ")");
        System.out.println("DFS Used%: " + StringUtils.formatPercent((double)((double)used / (double)presentCapacity), (int)2));
        System.out.println("Under replicated blocks: " + dfs.getUnderReplicatedBlocksCount());
        System.out.println("Blocks with corrupt replicas: " + dfs.getCorruptBlocksCount());
        System.out.println("Missing blocks: " + dfs.getMissingBlocksCount());
        System.out.println("Missing blocks (with replication factor 1): " + dfs.getMissingReplOneBlocksCount());
        System.out.println();
        System.out.println("-------------------------------------------------");
        List<String> args = Arrays.asList(argv);
        args = new ArrayList<String>(args.subList(i, args.size()));
        boolean listLive = StringUtils.popOption((String)"-live", args);
        boolean listDead = StringUtils.popOption((String)"-dead", args);
        boolean listDecommissioning = StringUtils.popOption((String)"-decommissioning", args);
        boolean bl = listAll = !listLive && !listDead && !listDecommissioning;
        if (listAll || listLive) {
            DatanodeInfo[] live = dfs.getDataNodeStats(HdfsConstants.DatanodeReportType.LIVE);
            if (live.length > 0 || listLive) {
                System.out.println("Live datanodes (" + live.length + "):\n");
            }
            if (live.length > 0) {
                for (DatanodeInfo dn : live) {
                    System.out.println(dn.getDatanodeReport());
                    System.out.println();
                }
            }
        }
        if (listAll || listDead) {
            DatanodeInfo[] dead = dfs.getDataNodeStats(HdfsConstants.DatanodeReportType.DEAD);
            if (dead.length > 0 || listDead) {
                System.out.println("Dead datanodes (" + dead.length + "):\n");
            }
            if (dead.length > 0) {
                for (DatanodeInfo dn : dead) {
                    System.out.println(dn.getDatanodeReport());
                    System.out.println();
                }
            }
        }
        if (listAll || listDecommissioning) {
            DatanodeInfo[] decom = dfs.getDataNodeStats(HdfsConstants.DatanodeReportType.DECOMMISSIONING);
            if (decom.length > 0 || listDecommissioning) {
                System.out.println("Decommissioning datanodes (" + decom.length + "):\n");
            }
            if (decom.length > 0) {
                for (DatanodeInfo dn : decom) {
                    System.out.println(dn.getDatanodeReport());
                    System.out.println();
                }
            }
        }
    }

    public void setSafeMode(String[] argv, int idx) throws IOException {
        HdfsConstants.SafeModeAction action;
        if (idx != argv.length - 1) {
            DFSAdmin.printUsage("-safemode");
            return;
        }
        Boolean waitExitSafe = false;
        if ("leave".equalsIgnoreCase(argv[idx])) {
            action = HdfsConstants.SafeModeAction.SAFEMODE_LEAVE;
        } else if ("enter".equalsIgnoreCase(argv[idx])) {
            action = HdfsConstants.SafeModeAction.SAFEMODE_ENTER;
        } else if ("get".equalsIgnoreCase(argv[idx])) {
            action = HdfsConstants.SafeModeAction.SAFEMODE_GET;
        } else if ("wait".equalsIgnoreCase(argv[idx])) {
            action = HdfsConstants.SafeModeAction.SAFEMODE_GET;
            waitExitSafe = true;
        } else {
            DFSAdmin.printUsage("-safemode");
            return;
        }
        DistributedFileSystem dfs = this.getDFS();
        boolean inSafeMode = dfs.setSafeMode(action);
        if (waitExitSafe.booleanValue()) {
            while (inSafeMode) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    throw new IOException("Wait Interrupted");
                }
                inSafeMode = dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET);
            }
        }
        System.out.println("Safe mode is " + (inSafeMode ? "ON" : "OFF"));
    }

    public int refreshNodes() throws IOException {
        int exitCode = -1;
        DistributedFileSystem dfs = this.getDFS();
        dfs.refreshNodes();
        exitCode = 0;
        return exitCode;
    }

    public int setBalancerBandwidth(String[] argv, int idx) throws IOException {
        long bandwidth;
        int exitCode = -1;
        try {
            bandwidth = Long.parseLong(argv[idx]);
        }
        catch (NumberFormatException nfe) {
            System.err.println("NumberFormatException: " + nfe.getMessage());
            System.err.println("Usage: hdfs dfsadmin [-setBalancerBandwidth <bandwidth in bytes per second>]");
            return exitCode;
        }
        FileSystem fs = this.getFS();
        if (!(fs instanceof DistributedFileSystem)) {
            System.err.println("FileSystem is " + fs.getUri());
            return exitCode;
        }
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        dfs.setBalancerBandwidth(bandwidth);
        exitCode = 0;
        return exitCode;
    }

    public int triggerBlockReport(String[] argv) throws IOException {
        LinkedList<String> args = new LinkedList<String>();
        for (int j = 1; j < argv.length; ++j) {
            args.add(argv[j]);
        }
        boolean incremental = StringUtils.popOption((String)"-incremental", args);
        String hostPort = StringUtils.popFirstNonOption(args);
        if (hostPort == null) {
            System.err.println("You must specify a host:port pair.");
            return 1;
        }
        if (!args.isEmpty()) {
            System.err.print("Can't understand arguments: " + Joiner.on((String)" ").join(args) + "\n");
            return 1;
        }
        ClientDatanodeProtocol dnProxy = this.getDataNodeProxy(hostPort);
        try {
            dnProxy.triggerBlockReport(new BlockReportOptions.Factory().setIncremental(incremental).build());
        }
        catch (IOException e) {
            System.err.println("triggerBlockReport error: " + e);
            return 1;
        }
        System.out.println("Triggering " + (incremental ? "an incremental " : "a full ") + "block report on " + hostPort + ".");
        return 0;
    }

    private void printHelp(String cmd) {
        String summary = "hdfs dfsadmin performs DFS administrative commands.\nNote: Administrative commands can only be run with superuser permission.\nThe full syntax is: \n\nhdfs dfsadmin\n\t[-report [-live] [-dead] [-decommissioning]]\n\t[-safemode <enter | leave | get | wait>]\n\t[-saveNamespace]\n\t[-rollEdits]\n\t[-restoreFailedStorage true|false|check]\n\t[-refreshNodes]\n\t[-setQuota <quota> <dirname>...<dirname>]\n\t[-clrQuota <dirname>...<dirname>]\n\t[-setSpaceQuota <quota> [-storageType <storagetype>] <dirname>...<dirname>]\n\t[-clrSpaceQuota [-storageType <storagetype>] <dirname>...<dirname>]\n\t[-finalizeUpgrade]\n\t[-rollingUpgrade [<query|prepare|finalize>]]\n\t[-refreshServiceAcl]\n\t[-refreshUserToGroupsMappings]\n\t[-refreshSuperUserGroupsConfiguration]\n\t[-refreshCallQueue]\n\t[-refresh <host:ipc_port> <key> [arg1..argn]\n\t[-reconfig <datanode|...> <host:ipc_port> <start|status>]\n\t[-printTopology]\n\t[-refreshNamenodes datanode_host:ipc_port]\n\t[-deleteBlockPool datanode_host:ipc_port blockpoolId [force]]\n\t[-setBalancerBandwidth <bandwidth in bytes per second>]\n\t[-fetchImage <local directory>]\n\t[-allowSnapshot <snapshotDir>]\n\t[-disallowSnapshot <snapshotDir>]\n\t[-shutdownDatanode <datanode_host:ipc_port> [upgrade]]\n\t[-getDatanodeInfo <datanode_host:ipc_port>]\n\t[-metasave filename]\n\t[-triggerBlockReport [-incremental] <datanode_host:ipc_port>]\n\t[-help [cmd]]\n";
        String report = "-report [-live] [-dead] [-decommissioning]:\n\tReports basic filesystem information and statistics.\n\tOptional flags may be used to filter the list of displayed DNs.\n";
        String safemode = "-safemode <enter|leave|get|wait>:  Safe mode maintenance command.\n\t\tSafe mode is a Namenode state in which it\n\t\t\t1.  does not accept changes to the name space (read-only)\n\t\t\t2.  does not replicate or delete blocks.\n\t\tSafe mode is entered automatically at Namenode startup, and\n\t\tleaves safe mode automatically when the configured minimum\n\t\tpercentage of blocks satisfies the minimum replication\n\t\tcondition.  Safe mode can also be entered manually, but then\n\t\tit can only be turned off manually as well.\n";
        String refreshNodes = "-refreshNodes: \tUpdates the namenode with the set of datanodes allowed to connect to the namenode.\n\n\t\tNamenode re-reads datanode hostnames from the file defined by \n\t\tdfs.hosts, dfs.hosts.exclude configuration parameters.\n\t\tHosts defined in dfs.hosts are the datanodes that are part of \n\t\tthe cluster. If there are entries in dfs.hosts, only the hosts \n\t\tin it are allowed to register with the namenode.\n\n\t\tEntries in dfs.hosts.exclude are datanodes that need to be \n\t\tdecommissioned. Datanodes complete decommissioning when \n\t\tall the replicas from them are replicated to other datanodes.\n\t\tDecommissioned nodes are not automatically shutdown and \n\t\tare not chosen for writing new replicas.\n";
        String refreshServiceAcl = "-refreshServiceAcl: Reload the service-level authorization policy file\n\t\tNamenode will reload the authorization policy file.\n";
        String refreshUserToGroupsMappings = "-refreshUserToGroupsMappings: Refresh user-to-groups mappings\n";
        String refreshSuperUserGroupsConfiguration = "-refreshSuperUserGroupsConfiguration: Refresh superuser proxy groups mappings\n";
        String refreshCallQueue = "-refreshCallQueue: Reload the call queue from config\n";
        String reconfig = "-reconfig <datanode|...> <host:ipc_port> <start|status>:\n\tStarts reconfiguration or gets the status of an ongoing reconfiguration.\n\tThe second parameter specifies the node type.\n\tCurrently, only reloading DataNode's configuration is supported.\n";
        String genericRefresh = "-refresh: Arguments are <hostname:port> <resource_identifier> [arg1..argn]\n\tTriggers a runtime-refresh of the resource specified by <resource_identifier>\n\ton <hostname:port>. All other args after are sent to the host.";
        String printTopology = "-printTopology: Print a tree of the racks and their\n\t\tnodes as reported by the Namenode\n";
        String deleteBlockPool = "-deleteBlockPool: Arguments are datanodehost:port, blockpool id\n\t\t and an optional argument \"force\". If force is passed,\n\t\t block pool directory for the given blockpool id on the given\n\t\t datanode is deleted along with its contents, otherwise\n\t\t the directory is deleted only if it is empty. The command\n\t\t will fail if datanode is still serving the block pool.\n";
        String setBalancerBandwidth = "-setBalancerBandwidth <bandwidth>:\n\tChanges the network bandwidth used by each datanode during\n\tHDFS block balancing.\n\n\t\t<bandwidth> is the maximum number of bytes per second\n\t\tthat will be used by each datanode. This value overrides\n\t\tthe dfs.balance.bandwidthPerSec parameter.\n\n\t\t--- NOTE: The new value is not persistent on the DataNode.---\n";
        String triggerBlockReport = "-triggerBlockReport [-incremental] <datanode_host:ipc_port>\n\tTrigger a block report for the datanode.\n\tIf 'incremental' is specified, it will be an incremental\n\tblock report; otherwise, it will be a full block report.\n";
        String shutdownDatanode = "-shutdownDatanode <datanode_host:ipc_port> [upgrade]\n\tSubmit a shutdown request for the given datanode. If an optional\n\t\"upgrade\" argument is specified, clients accessing the datanode\n\twill be advised to wait for it to restart and the fast start-up\n\tmode will be enabled. When the restart does not happen in time,\n\tclients will timeout and ignore the datanode. In such case, the\n\tfast start-up mode will also be disabled.\n";
        String getDatanodeInfo = "-getDatanodeInfo <datanode_host:ipc_port>\n\tGet the information about the given datanode. This command can\n\tbe used for checking if a datanode is alive.\n";
        String help = "-help [cmd]: \tDisplays help for the given command or all commands if none\n\t\tis specified.\n";
        if ("report".equals(cmd)) {
            System.out.println(report);
        } else if ("safemode".equals(cmd)) {
            System.out.println(safemode);
        } else if ("refreshNodes".equals(cmd)) {
            System.out.println(refreshNodes);
        } else if (RollingUpgradeCommand.matches("-" + cmd)) {
            System.out.println("-rollingUpgrade [<query|prepare|finalize>]:\n     query: query the current rolling upgrade status.\n   prepare: prepare a new rolling upgrade.\n  finalize: finalize the current rolling upgrade.");
        } else if (SetQuotaCommand.matches("-" + cmd)) {
            System.out.println("-setQuota <quota> <dirname>...<dirname>: Set the quota <quota> for each directory <dirName>.\n\t\tThe directory quota is a long integer that puts a hard limit\n\t\ton the number of names in the directory tree\n\t\tFor each directory, attempt to set the quota. An error will be reported if\n\t\t1. N is not a positive integer, or\n\t\t2. User is not an administrator, or\n\t\t3. The directory does not exist or is a file.\n\t\tNote: A quota of 1 would force the directory to remain empty.\n");
        } else if (ClearQuotaCommand.matches("-" + cmd)) {
            System.out.println("-clrQuota <dirname>...<dirname>: Clear the quota for each directory <dirName>.\n\t\tFor each directory, attempt to clear the quota. An error will be reported if\n\t\t1. the directory does not exist or is a file, or\n\t\t2. user is not an administrator.\n\t\tIt does not fault if the directory has no quota.");
        } else if (SetSpaceQuotaCommand.matches("-" + cmd)) {
            System.out.println("-setSpaceQuota <quota> [-storageType <storagetype>] <dirname>...<dirname>: Set the space quota <quota> for each directory <dirName>.\n\t\tThe space quota is a long integer that puts a hard limit\n\t\ton the total size of all the files under the directory tree.\n\t\tThe extra space required for replication is also counted. E.g.\n\t\ta 1GB file with replication of 3 consumes 3GB of the quota.\n\n\t\tQuota can also be specified with a binary prefix for terabytes,\n\t\tpetabytes etc (e.g. 50t is 50TB, 5m is 5MB, 3p is 3PB).\n\t\tFor each directory, attempt to set the quota. An error will be reported if\n\t\t1. N is not a positive integer, or\n\t\t2. user is not an administrator, or\n\t\t3. the directory does not exist or is a file.\n\t\tThe storage type specific quota is set when -storageType option is specified.\n");
        } else if (ClearSpaceQuotaCommand.matches("-" + cmd)) {
            System.out.println("-clrSpaceQuota [-storageType <storagetype>] <dirname>...<dirname>: Clear the space quota for each directory <dirName>.\n\t\tFor each directory, attempt to clear the quota. An error will be reported if\n\t\t1. the directory does not exist or is a file, or\n\t\t2. user is not an administrator.\n\t\tIt does not fault if the directory has no quota.\n\t\tThe storage type specific quota is cleared when -storageType option is specified.");
        } else if ("refreshServiceAcl".equals(cmd)) {
            System.out.println(refreshServiceAcl);
        } else if ("refreshUserToGroupsMappings".equals(cmd)) {
            System.out.println(refreshUserToGroupsMappings);
        } else if ("refreshSuperUserGroupsConfiguration".equals(cmd)) {
            System.out.println(refreshSuperUserGroupsConfiguration);
        } else if ("refreshCallQueue".equals(cmd)) {
            System.out.println(refreshCallQueue);
        } else if ("refresh".equals(cmd)) {
            System.out.println(genericRefresh);
        } else if ("reconfig".equals(cmd)) {
            System.out.println(reconfig);
        } else if ("printTopology".equals(cmd)) {
            System.out.println(printTopology);
        } else if ("deleteBlockPool".equals(cmd)) {
            System.out.println(deleteBlockPool);
        } else if ("setBalancerBandwidth".equals(cmd)) {
            System.out.println(setBalancerBandwidth);
        } else if ("shutdownDatanode".equalsIgnoreCase(cmd)) {
            System.out.println(shutdownDatanode);
        } else if ("getDatanodeInfo".equalsIgnoreCase(cmd)) {
            System.out.println(getDatanodeInfo);
        } else if ("help".equals(cmd)) {
            System.out.println(help);
        } else {
            System.out.println(summary);
            System.out.println(report);
            System.out.println(safemode);
            System.out.println(refreshNodes);
            System.out.println("-rollingUpgrade [<query|prepare|finalize>]:\n     query: query the current rolling upgrade status.\n   prepare: prepare a new rolling upgrade.\n  finalize: finalize the current rolling upgrade.");
            System.out.println("-setQuota <quota> <dirname>...<dirname>: Set the quota <quota> for each directory <dirName>.\n\t\tThe directory quota is a long integer that puts a hard limit\n\t\ton the number of names in the directory tree\n\t\tFor each directory, attempt to set the quota. An error will be reported if\n\t\t1. N is not a positive integer, or\n\t\t2. User is not an administrator, or\n\t\t3. The directory does not exist or is a file.\n\t\tNote: A quota of 1 would force the directory to remain empty.\n");
            System.out.println("-clrQuota <dirname>...<dirname>: Clear the quota for each directory <dirName>.\n\t\tFor each directory, attempt to clear the quota. An error will be reported if\n\t\t1. the directory does not exist or is a file, or\n\t\t2. user is not an administrator.\n\t\tIt does not fault if the directory has no quota.");
            System.out.println("-setSpaceQuota <quota> [-storageType <storagetype>] <dirname>...<dirname>: Set the space quota <quota> for each directory <dirName>.\n\t\tThe space quota is a long integer that puts a hard limit\n\t\ton the total size of all the files under the directory tree.\n\t\tThe extra space required for replication is also counted. E.g.\n\t\ta 1GB file with replication of 3 consumes 3GB of the quota.\n\n\t\tQuota can also be specified with a binary prefix for terabytes,\n\t\tpetabytes etc (e.g. 50t is 50TB, 5m is 5MB, 3p is 3PB).\n\t\tFor each directory, attempt to set the quota. An error will be reported if\n\t\t1. N is not a positive integer, or\n\t\t2. user is not an administrator, or\n\t\t3. the directory does not exist or is a file.\n\t\tThe storage type specific quota is set when -storageType option is specified.\n");
            System.out.println("-clrSpaceQuota [-storageType <storagetype>] <dirname>...<dirname>: Clear the space quota for each directory <dirName>.\n\t\tFor each directory, attempt to clear the quota. An error will be reported if\n\t\t1. the directory does not exist or is a file, or\n\t\t2. user is not an administrator.\n\t\tIt does not fault if the directory has no quota.\n\t\tThe storage type specific quota is cleared when -storageType option is specified.");
            System.out.println(refreshServiceAcl);
            System.out.println(refreshUserToGroupsMappings);
            System.out.println(refreshSuperUserGroupsConfiguration);
            System.out.println(refreshCallQueue);
            System.out.println(genericRefresh);
            System.out.println(reconfig);
            System.out.println(printTopology);
            System.out.println(deleteBlockPool);
            System.out.println(setBalancerBandwidth);
            System.out.println(triggerBlockReport);
            System.out.println(shutdownDatanode);
            System.out.println(getDatanodeInfo);
            System.out.println(help);
            System.out.println();
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        }
    }

    public int printTopology() throws IOException {
        DistributedFileSystem dfs = this.getDFS();
        DatanodeInfo[] report = dfs.getDataNodeStats();
        HashMap tree = new HashMap();
        for (DatanodeInfo dni : report) {
            String location = dni.getNetworkLocation();
            String name = dni.getName();
            if (!tree.containsKey(location)) {
                tree.put(location, new TreeSet());
            }
            ((TreeSet)tree.get(location)).add(name);
        }
        ArrayList racks = new ArrayList(tree.keySet());
        Collections.sort(racks);
        for (String r : racks) {
            System.out.println("Rack: " + r);
            TreeSet nodes = (TreeSet)tree.get(r);
            for (String n : nodes) {
                System.out.print("   " + n);
                String hostname = NetUtils.getHostNameOfIP((String)n);
                if (hostname != null) {
                    System.out.print(" (" + hostname + ")");
                }
                System.out.println();
            }
            System.out.println();
        }
        return 0;
    }

    private static UserGroupInformation getUGI() throws IOException {
        return UserGroupInformation.getCurrentUser();
    }

    public int refreshServiceAcl() throws IOException {
        Configuration conf = this.getConf();
        conf.set("hadoop.security.service.user.name.key", conf.get("dfs.namenode.kerberos.principal", ""));
        RefreshAuthorizationPolicyProtocol refreshProtocol = NameNodeProxies.createProxy(conf, FileSystem.getDefaultUri((Configuration)conf), RefreshAuthorizationPolicyProtocol.class).getProxy();
        refreshProtocol.refreshServiceAcl();
        return 0;
    }

    public int refreshUserToGroupsMappings() throws IOException {
        Configuration conf = this.getConf();
        conf.set("hadoop.security.service.user.name.key", conf.get("dfs.namenode.kerberos.principal", ""));
        RefreshUserMappingsProtocol refreshProtocol = NameNodeProxies.createProxy(conf, FileSystem.getDefaultUri((Configuration)conf), RefreshUserMappingsProtocol.class).getProxy();
        refreshProtocol.refreshUserToGroupsMappings();
        return 0;
    }

    public int refreshSuperUserGroupsConfiguration() throws IOException {
        Configuration conf = this.getConf();
        conf.set("hadoop.security.service.user.name.key", conf.get("dfs.namenode.kerberos.principal", ""));
        RefreshUserMappingsProtocol refreshProtocol = NameNodeProxies.createProxy(conf, FileSystem.getDefaultUri((Configuration)conf), RefreshUserMappingsProtocol.class).getProxy();
        refreshProtocol.refreshSuperUserGroupsConfiguration();
        return 0;
    }

    public int refreshCallQueue() throws IOException {
        Configuration conf = this.getConf();
        conf.set("hadoop.security.service.user.name.key", conf.get("dfs.namenode.kerberos.principal", ""));
        RefreshCallQueueProtocol refreshProtocol = NameNodeProxies.createProxy(conf, FileSystem.getDefaultUri((Configuration)conf), RefreshCallQueueProtocol.class).getProxy();
        refreshProtocol.refreshCallQueue();
        return 0;
    }

    public int reconfig(String[] argv, int i) throws IOException {
        String nodeType = argv[i];
        String address = argv[i + 1];
        String op = argv[i + 2];
        if ("start".equals(op)) {
            return this.startReconfiguration(nodeType, address);
        }
        if ("status".equals(op)) {
            return this.getReconfigurationStatus(nodeType, address, System.out, System.err);
        }
        System.err.println("Unknown operation: " + op);
        return -1;
    }

    int startReconfiguration(String nodeType, String address) throws IOException {
        if ("datanode".equals(nodeType)) {
            ClientDatanodeProtocol dnProxy = this.getDataNodeProxy(address);
            dnProxy.startReconfiguration();
            System.out.println("Started reconfiguration task on DataNode " + address);
            return 0;
        }
        System.err.println("Node type " + nodeType + " does not support reconfiguration.");
        return 1;
    }

    int getReconfigurationStatus(String nodeType, String address, PrintStream out, PrintStream err) throws IOException {
        if ("datanode".equals(nodeType)) {
            ClientDatanodeProtocol dnProxy = this.getDataNodeProxy(address);
            try {
                ReconfigurationTaskStatus status = dnProxy.getReconfigurationStatus();
                out.print("Reconfiguring status for DataNode[" + address + "]: ");
                if (!status.hasTask()) {
                    out.println("no task was found.");
                    return 0;
                }
                out.print("started at " + new Date(status.getStartTime()));
                if (!status.stopped()) {
                    out.println(" and is still running.");
                    return 0;
                }
                out.println(" and finished at " + new Date(status.getEndTime()).toString() + ".");
                for (Map.Entry result : status.getStatus().entrySet()) {
                    if (!((Optional)result.getValue()).isPresent()) {
                        out.print("SUCCESS: ");
                    } else {
                        out.print("FAILED: ");
                    }
                    out.printf("Change property %s%n\tFrom: \"%s\"%n\tTo: \"%s\"%n", ((ReconfigurationUtil.PropertyChange)result.getKey()).prop, ((ReconfigurationUtil.PropertyChange)result.getKey()).oldVal, ((ReconfigurationUtil.PropertyChange)result.getKey()).newVal);
                    if (!((Optional)result.getValue()).isPresent()) continue;
                    out.println("\tError: " + (String)((Optional)result.getValue()).get() + ".");
                }
            }
            catch (IOException e) {
                err.println("DataNode reloading configuration: " + e + ".");
                return 1;
            }
        } else {
            err.println("Node type " + nodeType + " does not support reconfiguration.");
            return 1;
        }
        return 0;
    }

    /*
     * Loose catch block
     */
    public int genericRefresh(String[] argv, int i) throws IOException {
        String hostport = argv[i++];
        String identifier = argv[i++];
        String[] args = Arrays.copyOfRange(argv, i, argv.length);
        Configuration conf = this.getConf();
        conf.set("hadoop.security.service.user.name.key", conf.get("dfs.namenode.kerberos.principal", ""));
        Class<GenericRefreshProtocolPB> xface = GenericRefreshProtocolPB.class;
        InetSocketAddress address = NetUtils.createSocketAddr((String)hostport);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        RPC.setProtocolEngine((Configuration)conf, xface, ProtobufRpcEngine.class);
        GenericRefreshProtocolPB proxy = (GenericRefreshProtocolPB)RPC.getProxy(xface, (long)RPC.getProtocolVersion(xface), (InetSocketAddress)address, (UserGroupInformation)ugi, (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)0);
        Collection responses = null;
        try {
            try (GenericRefreshProtocolClientSideTranslatorPB xlator = new GenericRefreshProtocolClientSideTranslatorPB(proxy);){
                responses = xlator.refresh(identifier, args);
                int returnCode = 0;
                System.out.println("Refresh Responses:\n");
                for (RefreshResponse response : responses) {
                    System.out.println(response.toString());
                    if (returnCode == 0 && response.getReturnCode() != 0) {
                        returnCode = response.getReturnCode();
                        continue;
                    }
                    if (returnCode == 0 || response.getReturnCode() == 0) continue;
                    returnCode = -1;
                }
                int n = returnCode;
                return n;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (responses == null) {
                System.out.println("Failed to get response.\n");
                return -1;
            }
        }
    }

    private static void printUsage(String cmd) {
        if ("-report".equals(cmd)) {
            System.err.println("Usage: hdfs dfsadmin [-report] [-live] [-dead] [-decommissioning]");
        } else if ("-safemode".equals(cmd)) {
            System.err.println("Usage: hdfs DFSAdmin [-safemode enter | leave | get | wait]");
        } else if ("-refreshNodes".equals(cmd)) {
            System.err.println("Usage: hdfs dfsadmin [-refreshNodes]");
        } else if (RollingUpgradeCommand.matches(cmd)) {
            System.err.println("Usage: hdfs dfsadmin [-rollingUpgrade [<query|prepare|finalize>]]");
        } else if (SetQuotaCommand.matches(cmd)) {
            System.err.println("Usage: hdfs dfsadmin [-setQuota <quota> <dirname>...<dirname>]");
        } else if (ClearQuotaCommand.matches(cmd)) {
            System.err.println("Usage: hdfs dfsadmin [-clrQuota <dirname>...<dirname>]");
        } else if (SetSpaceQuotaCommand.matches(cmd)) {
            System.err.println("Usage: hdfs dfsadmin [-setSpaceQuota <quota> [-storageType <storagetype>] <dirname>...<dirname>]");
        } else if (ClearSpaceQuotaCommand.matches(cmd)) {
            System.err.println("Usage: hdfs dfsadmin [-clrSpaceQuota [-storageType <storagetype>] <dirname>...<dirname>]");
        } else if ("-refreshServiceAcl".equals(cmd)) {
            System.err.println("Usage: hdfs dfsadmin [-refreshServiceAcl]");
        } else if ("-refreshUserToGroupsMappings".equals(cmd)) {
            System.err.println("Usage: hdfs dfsadmin [-refreshUserToGroupsMappings]");
        } else if ("-refreshSuperUserGroupsConfiguration".equals(cmd)) {
            System.err.println("Usage: hdfs dfsadmin [-refreshSuperUserGroupsConfiguration]");
        } else if ("-refreshCallQueue".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-refreshCallQueue]");
        } else if ("-reconfig".equals(cmd)) {
            System.err.println("Usage: hdfs dfsadmin [-reconfig <datanode|...> <host:port> <start|status>]");
        } else if ("-refresh".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-refresh <hostname:port> <resource_identifier> [arg1..argn]");
        } else if ("-printTopology".equals(cmd)) {
            System.err.println("Usage: hdfs dfsadmin [-printTopology]");
        } else if ("-deleteBlockPool".equals(cmd)) {
            System.err.println("Usage: hdfs dfsadmin [-deleteBlockPool datanode-host:port blockpoolId [force]]");
        } else if ("-setBalancerBandwidth".equals(cmd)) {
            System.err.println("Usage: hdfs dfsadmin [-setBalancerBandwidth <bandwidth in bytes per second>]");
        } else if ("-shutdownDatanode".equals(cmd)) {
            System.err.println("Usage: hdfs dfsadmin [-shutdownDatanode <datanode_host:ipc_port> [upgrade]]");
        } else if ("-getDatanodeInfo".equals(cmd)) {
            System.err.println("Usage: hdfs dfsadmin [-getDatanodeInfo <datanode_host:ipc_port>]");
        } else if ("-triggerBlockReport".equals(cmd)) {
            System.err.println("Usage: hdfs dfsadmin [-triggerBlockReport [-incremental] <datanode_host:ipc_port>]");
        } else {
            System.err.println("Usage: hdfs dfsadmin");
            System.err.println("Note: Administrative commands can only be run as the HDFS superuser.");
            System.err.println(commonUsageSummary);
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
        }
    }

    public int run(String[] argv) throws Exception {
        String cmd;
        if (argv.length < 1) {
            DFSAdmin.printUsage("");
            return -1;
        }
        int exitCode = -1;
        int i = 0;
        if ("-safemode".equals(cmd = argv[i++])) {
            if (argv.length != 2) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-report".equals(cmd)) {
            if (argv.length < 1) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-refreshNodes".equals(cmd)) {
            if (argv.length != 1) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if (RollingUpgradeCommand.matches(cmd)) {
            if (argv.length < 1 || argv.length > 2) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-refreshServiceAcl".equals(cmd)) {
            if (argv.length != 1) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-refresh".equals(cmd)) {
            if (argv.length < 3) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-refreshUserToGroupsMappings".equals(cmd)) {
            if (argv.length != 1) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-printTopology".equals(cmd)) {
            if (argv.length != 1) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-reconfig".equals(cmd)) {
            if (argv.length != 4) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-deleteBlockPool".equals(cmd)) {
            if (argv.length != 3 && argv.length != 4) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-setBalancerBandwidth".equals(cmd)) {
            if (argv.length != 2) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-triggerBlockReport".equals(cmd)) {
            if (argv.length < 1) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-shutdownDatanode".equals(cmd)) {
            if (argv.length != 2 && argv.length != 3) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-getDatanodeInfo".equals(cmd) && argv.length != 2) {
            DFSAdmin.printUsage(cmd);
            return exitCode;
        }
        try {
            this.init();
        }
        catch (RPC.VersionMismatch v) {
            System.err.println("Version Mismatch between client and server... command aborted.");
            return exitCode;
        }
        catch (IOException e) {
            System.err.println("Bad connection to DFS... command aborted.");
            return exitCode;
        }
        Throwable debugException = null;
        exitCode = 0;
        try {
            if ("-report".equals(cmd)) {
                this.report(argv, i);
            } else if ("-safemode".equals(cmd)) {
                this.setSafeMode(argv, i);
            } else if ("-refreshNodes".equals(cmd)) {
                exitCode = this.refreshNodes();
            } else if (RollingUpgradeCommand.matches(cmd)) {
                exitCode = RollingUpgradeCommand.run(this.getDFS(), argv, i);
            } else if ("-metasave".equals(cmd)) {
                System.out.println("metasave is not supported by hops");
            } else if (ClearQuotaCommand.matches(cmd)) {
                exitCode = new ClearQuotaCommand(argv, i, this.getDFS()).runAll();
            } else if (SetQuotaCommand.matches(cmd)) {
                exitCode = new SetQuotaCommand(argv, i, this.getDFS()).runAll();
            } else if (ClearSpaceQuotaCommand.matches(cmd)) {
                exitCode = new ClearSpaceQuotaCommand(argv, i, this.getDFS()).runAll();
            } else if (SetSpaceQuotaCommand.matches(cmd)) {
                exitCode = new SetSpaceQuotaCommand(argv, i, this.getDFS()).runAll();
            } else if ("-refreshServiceAcl".equals(cmd)) {
                exitCode = this.refreshServiceAcl();
            } else if ("-refreshUserToGroupsMappings".equals(cmd)) {
                exitCode = this.refreshUserToGroupsMappings();
            } else if ("-refreshSuperUserGroupsConfiguration".equals(cmd)) {
                exitCode = this.refreshSuperUserGroupsConfiguration();
            } else if ("-refreshCallQueue".equals(cmd)) {
                exitCode = this.refreshCallQueue();
            } else if ("-refresh".equals(cmd)) {
                exitCode = this.genericRefresh(argv, i);
            } else if ("-printTopology".equals(cmd)) {
                exitCode = this.printTopology();
            } else if ("-deleteBlockPool".equals(cmd)) {
                exitCode = this.deleteBlockPool(argv, i);
            } else if ("-setBalancerBandwidth".equals(cmd)) {
                exitCode = this.setBalancerBandwidth(argv, i);
            } else if ("-triggerBlockReport".equals(cmd)) {
                exitCode = this.triggerBlockReport(argv);
            } else if ("-shutdownDatanode".equals(cmd)) {
                exitCode = this.shutdownDatanode(argv, i);
            } else if ("-getDatanodeInfo".equals(cmd)) {
                exitCode = this.getDatanodeInfo(argv, i);
            } else if ("-reconfig".equals(cmd)) {
                exitCode = this.reconfig(argv, i);
            } else if ("-help".equals(cmd)) {
                if (i < argv.length) {
                    this.printHelp(argv[i]);
                } else {
                    this.printHelp("");
                }
            } else {
                exitCode = -1;
                System.err.println(cmd.substring(1) + ": Unknown command");
                DFSAdmin.printUsage("");
            }
        }
        catch (IllegalArgumentException arge) {
            debugException = arge;
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + arge.getLocalizedMessage());
            DFSAdmin.printUsage(cmd);
        }
        catch (RemoteException e) {
            exitCode = -1;
            debugException = e;
            try {
                String[] content = e.getLocalizedMessage().split("\n");
                System.err.println(cmd.substring(1) + ": " + content[0]);
            }
            catch (Exception ex) {
                System.err.println(cmd.substring(1) + ": " + ex.getLocalizedMessage());
                debugException = ex;
            }
        }
        catch (Exception e) {
            exitCode = -1;
            debugException = e;
            System.err.println(cmd.substring(1) + ": " + e.getLocalizedMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Exception encountered:", debugException);
        }
        return exitCode;
    }

    private ClientDatanodeProtocol getDataNodeProxy(String datanode) throws IOException {
        InetSocketAddress datanodeAddr = NetUtils.createSocketAddr((String)datanode);
        Configuration conf = this.getConf();
        conf.set("hadoop.security.service.user.name.key", conf.get("dfs.datanode.kerberos.principal", ""));
        ClientDatanodeProtocol dnProtocol = DFSUtil.createClientDatanodeProtocolProxy(datanodeAddr, DFSAdmin.getUGI(), conf, NetUtils.getSocketFactory((Configuration)conf, ClientDatanodeProtocol.class));
        return dnProtocol;
    }

    private int deleteBlockPool(String[] argv, int i) throws IOException {
        ClientDatanodeProtocol dnProxy = this.getDataNodeProxy(argv[i]);
        boolean force = false;
        if (argv.length - 1 == i + 2) {
            if ("force".equals(argv[i + 2])) {
                force = true;
            } else {
                DFSAdmin.printUsage("-deleteBlockPool");
                return -1;
            }
        }
        dnProxy.deleteBlockPool(argv[i + 1], force);
        return 0;
    }

    private int shutdownDatanode(String[] argv, int i) throws IOException {
        String dn = argv[i];
        ClientDatanodeProtocol dnProxy = this.getDataNodeProxy(dn);
        boolean upgrade = false;
        if (argv.length - 1 == i + 1) {
            if ("upgrade".equalsIgnoreCase(argv[i + 1])) {
                upgrade = true;
            } else {
                DFSAdmin.printUsage("-shutdownDatanode");
                return -1;
            }
        }
        dnProxy.shutdownDatanode(upgrade);
        System.out.println("Submitted a shutdown request to datanode " + dn);
        return 0;
    }

    private int getDatanodeInfo(String[] argv, int i) throws IOException {
        ClientDatanodeProtocol dnProxy = this.getDataNodeProxy(argv[i]);
        try {
            DatanodeLocalInfo dnInfo = dnProxy.getDatanodeInfo();
            System.out.println(dnInfo.getDatanodeLocalReport());
        }
        catch (IOException ioe) {
            System.err.println("Datanode unreachable.");
            return -1;
        }
        return 0;
    }

    public static void main(String[] argv) throws Exception {
        int res = ToolRunner.run((Tool)new DFSAdmin(), (String[])argv);
        System.exit(res);
    }

    static {
        HdfsConfiguration.init();
        LOG = LogFactory.getLog(DFSAdmin.class);
    }

    private static class RollingUpgradeCommand {
        static final String NAME = "rollingUpgrade";
        static final String USAGE = "-rollingUpgrade [<query|prepare|finalize>]";
        static final String DESCRIPTION = "-rollingUpgrade [<query|prepare|finalize>]:\n     query: query the current rolling upgrade status.\n   prepare: prepare a new rolling upgrade.\n  finalize: finalize the current rolling upgrade.";

        private RollingUpgradeCommand() {
        }

        static boolean matches(String cmd) {
            return "-rollingUpgrade".equals(cmd);
        }

        private static void printMessage(RollingUpgradeInfo info, PrintStream out) {
            if (info != null && info.isStarted()) {
                if (!info.isFinalized()) {
                    out.println("Proceed with rolling upgrade:");
                    out.println(info);
                } else {
                    out.println("Rolling upgrade is finalized.");
                    out.println(info);
                }
            } else {
                out.println("There is no rolling upgrade in progress.");
            }
        }

        static int run(DistributedFileSystem dfs, String[] argv, int idx) throws IOException {
            HdfsConstants.RollingUpgradeAction action = HdfsConstants.RollingUpgradeAction.fromString(argv.length >= 2 ? argv[1] : "");
            if (action == null) {
                throw new IllegalArgumentException("Failed to covert \"" + argv[1] + "\" to " + HdfsConstants.RollingUpgradeAction.class.getSimpleName());
            }
            System.out.println((Object)((Object)action) + " rolling upgrade ...");
            RollingUpgradeInfo info = dfs.rollingUpgrade(action);
            switch (action) {
                case QUERY: {
                    break;
                }
                case PREPARE: {
                    Preconditions.checkState((boolean)info.isStarted());
                    break;
                }
                case FINALIZE: {
                    Preconditions.checkState((boolean)info.isFinalized());
                }
            }
            RollingUpgradeCommand.printMessage(info, System.out);
            return 0;
        }
    }

    private static class SetSpaceQuotaCommand
    extends DFSAdminCommand {
        private static final String NAME = "setSpaceQuota";
        private static final String USAGE = "-setSpaceQuota <quota> [-storageType <storagetype>] <dirname>...<dirname>";
        private static final String DESCRIPTION = "-setSpaceQuota <quota> [-storageType <storagetype>] <dirname>...<dirname>: Set the space quota <quota> for each directory <dirName>.\n\t\tThe space quota is a long integer that puts a hard limit\n\t\ton the total size of all the files under the directory tree.\n\t\tThe extra space required for replication is also counted. E.g.\n\t\ta 1GB file with replication of 3 consumes 3GB of the quota.\n\n\t\tQuota can also be specified with a binary prefix for terabytes,\n\t\tpetabytes etc (e.g. 50t is 50TB, 5m is 5MB, 3p is 3PB).\n\t\tFor each directory, attempt to set the quota. An error will be reported if\n\t\t1. N is not a positive integer, or\n\t\t2. user is not an administrator, or\n\t\t3. the directory does not exist or is a file.\n\t\tThe storage type specific quota is set when -storageType option is specified.\n";
        private long quota;
        private StorageType type;

        SetSpaceQuotaCommand(String[] args, int pos, FileSystem fs) {
            super(fs);
            CommandFormat c = new CommandFormat(2, Integer.MAX_VALUE, new String[0]);
            List parameters = c.parse(args, pos);
            String str = ((String)parameters.remove(0)).trim();
            try {
                this.quota = StringUtils.TraditionalBinaryPrefix.string2long((String)str);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("\"" + str + "\" is not a valid value for a quota.");
            }
            String storageTypeString = StringUtils.popOptionWithArgument((String)"-storageType", (List)parameters);
            if (storageTypeString != null) {
                this.type = StorageType.parseStorageType((String)storageTypeString);
            }
            this.args = parameters.toArray(new String[parameters.size()]);
        }

        public static boolean matches(String cmd) {
            return "-setSpaceQuota".equals(cmd);
        }

        public String getCommandName() {
            return NAME;
        }

        public void run(Path path) throws IOException {
            if (this.type != null) {
                this.dfs.setQuotaByStorageType(path, this.type, this.quota);
            } else {
                this.dfs.setQuota(path, Long.MAX_VALUE, this.quota);
            }
        }
    }

    private static class ClearSpaceQuotaCommand
    extends DFSAdminCommand {
        private static final String NAME = "clrSpaceQuota";
        private static final String USAGE = "-clrSpaceQuota [-storageType <storagetype>] <dirname>...<dirname>";
        private static final String DESCRIPTION = "-clrSpaceQuota [-storageType <storagetype>] <dirname>...<dirname>: Clear the space quota for each directory <dirName>.\n\t\tFor each directory, attempt to clear the quota. An error will be reported if\n\t\t1. the directory does not exist or is a file, or\n\t\t2. user is not an administrator.\n\t\tIt does not fault if the directory has no quota.\n\t\tThe storage type specific quota is cleared when -storageType option is specified.";
        private StorageType type;

        ClearSpaceQuotaCommand(String[] args, int pos, FileSystem fs) {
            super(fs);
            CommandFormat c = new CommandFormat(1, Integer.MAX_VALUE, new String[0]);
            c.addOptionWithValue("storageType");
            List parameters = c.parse(args, pos);
            String storageTypeString = c.getOptValue("storageType");
            if (storageTypeString != null) {
                this.type = StorageType.parseStorageType((String)storageTypeString);
            }
            this.args = parameters.toArray(new String[parameters.size()]);
        }

        public static boolean matches(String cmd) {
            return "-clrSpaceQuota".equals(cmd);
        }

        public String getCommandName() {
            return NAME;
        }

        public void run(Path path) throws IOException {
            if (this.type != null) {
                this.dfs.setQuotaByStorageType(path, this.type, -1L);
            } else {
                this.dfs.setQuota(path, Long.MAX_VALUE, -1L);
            }
        }
    }

    private static class SetQuotaCommand
    extends DFSAdminCommand {
        private static final String NAME = "setQuota";
        private static final String USAGE = "-setQuota <quota> <dirname>...<dirname>";
        private static final String DESCRIPTION = "-setQuota <quota> <dirname>...<dirname>: Set the quota <quota> for each directory <dirName>.\n\t\tThe directory quota is a long integer that puts a hard limit\n\t\ton the number of names in the directory tree\n\t\tFor each directory, attempt to set the quota. An error will be reported if\n\t\t1. N is not a positive integer, or\n\t\t2. User is not an administrator, or\n\t\t3. The directory does not exist or is a file.\n\t\tNote: A quota of 1 would force the directory to remain empty.\n";
        private final long quota;

        SetQuotaCommand(String[] args, int pos, FileSystem fs) {
            super(fs);
            CommandFormat c = new CommandFormat(2, Integer.MAX_VALUE, new String[0]);
            List parameters = c.parse(args, pos);
            this.quota = Long.parseLong((String)parameters.remove(0));
            this.args = parameters.toArray(new String[parameters.size()]);
        }

        public static boolean matches(String cmd) {
            return "-setQuota".equals(cmd);
        }

        public String getCommandName() {
            return NAME;
        }

        public void run(Path path) throws IOException {
            this.dfs.setQuota(path, this.quota, Long.MAX_VALUE);
        }
    }

    private static class ClearQuotaCommand
    extends DFSAdminCommand {
        private static final String NAME = "clrQuota";
        private static final String USAGE = "-clrQuota <dirname>...<dirname>";
        private static final String DESCRIPTION = "-clrQuota <dirname>...<dirname>: Clear the quota for each directory <dirName>.\n\t\tFor each directory, attempt to clear the quota. An error will be reported if\n\t\t1. the directory does not exist or is a file, or\n\t\t2. user is not an administrator.\n\t\tIt does not fault if the directory has no quota.";

        ClearQuotaCommand(String[] args, int pos, FileSystem fs) {
            super(fs);
            CommandFormat c = new CommandFormat(1, Integer.MAX_VALUE, new String[0]);
            List parameters = c.parse(args, pos);
            this.args = parameters.toArray(new String[parameters.size()]);
        }

        public static boolean matches(String cmd) {
            return "-clrQuota".equals(cmd);
        }

        public String getCommandName() {
            return NAME;
        }

        public void run(Path path) throws IOException {
            this.dfs.setQuota(path, -1L, Long.MAX_VALUE);
        }
    }

    private static abstract class DFSAdminCommand
    extends Command {
        final DistributedFileSystem dfs;

        public DFSAdminCommand(FileSystem fs) {
            super(fs.getConf());
            if (!(fs instanceof DistributedFileSystem)) {
                throw new IllegalArgumentException("FileSystem " + fs.getUri() + " is not an HDFS file system");
            }
            this.dfs = (DistributedFileSystem)fs;
        }
    }
}

