/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.impl.pb.client;

import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.api.ClientSCMProtocol;
import org.apache.hadoop.yarn.api.ClientSCMProtocolPB;
import org.apache.hadoop.yarn.api.protocolrecords.ReleaseSharedCacheResourceRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReleaseSharedCacheResourceResponse;
import org.apache.hadoop.yarn.api.protocolrecords.UseSharedCacheResourceRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UseSharedCacheResourceResponse;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.ReleaseSharedCacheResourceRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.ReleaseSharedCacheResourceResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.UseSharedCacheResourceRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.UseSharedCacheResourceResponsePBImpl;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

public class ClientSCMProtocolPBClientImpl
implements ClientSCMProtocol,
Closeable {
    private ClientSCMProtocolPB proxy;

    public ClientSCMProtocolPBClientImpl(long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, ClientSCMProtocolPB.class, ProtobufRpcEngine.class);
        this.proxy = (ClientSCMProtocolPB)RPC.getProxy(ClientSCMProtocolPB.class, (long)clientVersion, (InetSocketAddress)addr, (Configuration)conf);
    }

    @Override
    public void close() {
        if (this.proxy != null) {
            RPC.stopProxy((Object)this.proxy);
            this.proxy = null;
        }
    }

    @Override
    public UseSharedCacheResourceResponse use(UseSharedCacheResourceRequest request) throws YarnException, IOException {
        YarnServiceProtos.UseSharedCacheResourceRequestProto requestProto = ((UseSharedCacheResourceRequestPBImpl)request).getProto();
        try {
            return new UseSharedCacheResourceResponsePBImpl(this.proxy.use(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    @Override
    public ReleaseSharedCacheResourceResponse release(ReleaseSharedCacheResourceRequest request) throws YarnException, IOException {
        YarnServiceProtos.ReleaseSharedCacheResourceRequestProto requestProto = ((ReleaseSharedCacheResourceRequestPBImpl)request).getProto();
        try {
            return new ReleaseSharedCacheResourceResponsePBImpl(this.proxy.release(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }
}

