/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class AMRMClientUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AMRMClientUtils.class);
    public static final int PRE_REGISTER_RESPONSE_ID = -1;
    public static final String APP_ALREADY_REGISTERED_MESSAGE = "Application Master is already registered : ";
    public static final String EXPECTED_HB_RESPONSEID_MESSAGE = " expect responseId to be ";
    public static final String RECEIVED_HB_RESPONSEID_MESSAGE = " but get ";

    private AMRMClientUtils() {
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static <T> T createRMProxy(final Configuration configuration, final Class<T> protocol, UserGroupInformation user, Token<? extends TokenIdentifier> token) throws IOException {
        try {
            String rmClusterId = configuration.get("yarn.resourcemanager.cluster-id", "yarn_cluster");
            LOG.info("Creating RMProxy to RM {} for protocol {} for user {}", new Object[]{rmClusterId, protocol.getSimpleName(), user});
            if (token != null) {
                user.addToken(token);
                token.setService(ClientRMProxy.getAMRMTokenService(configuration));
                AMRMClientUtils.setAuthModeInConf(configuration);
            }
            Object proxyConnection = user.doAs(new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws Exception {
                    return ClientRMProxy.createRMProxy(configuration, protocol);
                }
            });
            return (T)proxyConnection;
        }
        catch (InterruptedException e) {
            throw new YarnRuntimeException(e);
        }
    }

    private static void setAuthModeInConf(Configuration conf) {
        conf.set("hadoop.security.authentication", SaslRpcServer.AuthMethod.TOKEN.toString());
    }

    public static String assembleInvalidResponseIdExceptionMessage(ApplicationAttemptId appAttemptId, int expected, int received) {
        return "Invalid responseId in AllocateRequest from application attempt: " + appAttemptId + EXPECTED_HB_RESPONSEID_MESSAGE + expected + RECEIVED_HB_RESPONSEID_MESSAGE + received;
    }

    public static int parseExpectedResponseIdFromException(String exceptionMessage) {
        if (exceptionMessage == null) {
            return -1;
        }
        int start = exceptionMessage.indexOf(EXPECTED_HB_RESPONSEID_MESSAGE);
        int end = exceptionMessage.indexOf(RECEIVED_HB_RESPONSEID_MESSAGE);
        if (start == -1 || end == -1) {
            return -1;
        }
        start += EXPECTED_HB_RESPONSEID_MESSAGE.length();
        try {
            return Integer.parseInt(exceptionMessage.substring(start, end));
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public static int getNextResponseId(int responseId) {
        return responseId + 1 & Integer.MAX_VALUE;
    }

    public static void addToOutstandingSchedulingRequests(Collection<SchedulingRequest> requests, Map<Set<String>, List<SchedulingRequest>> outstandingSchedRequests) {
        for (SchedulingRequest req : requests) {
            List schedulingRequests = outstandingSchedRequests.computeIfAbsent(req.getAllocationTags(), x -> new LinkedList());
            SchedulingRequest matchingReq = null;
            for (SchedulingRequest schedReq : schedulingRequests) {
                if (!AMRMClientUtils.isMatchingSchedulingRequests(req, schedReq)) continue;
                matchingReq = schedReq;
                break;
            }
            if (matchingReq != null) {
                matchingReq.getResourceSizing().setNumAllocations(req.getResourceSizing().getNumAllocations());
                continue;
            }
            schedulingRequests.add(req);
        }
    }

    public static boolean isMatchingSchedulingRequests(SchedulingRequest schedReq1, SchedulingRequest schedReq2) {
        return schedReq1.getPriority().equals(schedReq2.getPriority()) && schedReq1.getExecutionType().getExecutionType().equals((Object)schedReq1.getExecutionType().getExecutionType()) && schedReq1.getAllocationRequestId() == schedReq2.getAllocationRequestId();
    }

    public static void removeFromOutstandingSchedulingRequests(Collection<Container> containers, Map<Set<String>, List<SchedulingRequest>> outstandingSchedRequests) {
        if (containers == null || containers.isEmpty()) {
            return;
        }
        for (Container container : containers) {
            List<SchedulingRequest> schedReqs;
            if (container.getAllocationTags() == null || container.getAllocationTags().isEmpty() || (schedReqs = outstandingSchedRequests.get(container.getAllocationTags())) == null || schedReqs.isEmpty()) continue;
            Iterator<SchedulingRequest> iter = schedReqs.iterator();
            while (iter.hasNext()) {
                SchedulingRequest schedReq = iter.next();
                if (!schedReq.getPriority().equals(container.getPriority()) || schedReq.getAllocationRequestId() != container.getAllocationRequestId()) continue;
                int numAllocations = schedReq.getResourceSizing().getNumAllocations();
                if (--numAllocations == 0) {
                    iter.remove();
                    continue;
                }
                schedReq.getResourceSizing().setNumAllocations(numAllocations);
            }
        }
    }
}

