/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.LeasePathDataAccess;
import io.hops.metadata.hdfs.entity.LeasePath;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.lock.TransactionLocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sparkproject.guava.base.Predicate;

public class LeasePathContext
extends BaseEntityContext<LeasePathPK, LeasePath> {
    private final LeasePathDataAccess<LeasePath> dataAccess;
    private final Map<Integer, Set<LeasePath>> hIdToLPsMap = new HashMap<Integer, Set<LeasePath>>();
    private final List<String> nullLPs = new ArrayList<String>();

    public LeasePathContext(LeasePathDataAccess<LeasePath> dataAccess) {
        this.dataAccess = dataAccess;
    }

    public void update(LeasePath hopLeasePath) throws TransactionContextException {
        super.update((Object)hopLeasePath);
        this.addToHIdToLPsMap(hopLeasePath);
        if (this.isLogTraceEnabled()) {
            this.log("added-lpath", new Object[]{"path", hopLeasePath.getPath(), "hid", hopLeasePath.getHolderId()});
        }
    }

    public void remove(LeasePath hopLeasePath) throws TransactionContextException {
        super.remove((Object)hopLeasePath);
        this.removeFromHIdToLPsMap(hopLeasePath);
        if (this.isLogTraceEnabled()) {
            this.log("removed-lpath", new Object[]{"path", hopLeasePath.getPath(), "holderId ", hopLeasePath.getHolderId()});
        }
    }

    public LeasePath find(FinderType<LeasePath> finder, Object ... params) throws TransactionContextException, StorageException {
        LeasePath.Finder lFinder = (LeasePath.Finder)finder;
        switch (lFinder) {
            case ByPath: {
                return this.findByPath(lFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public Collection<LeasePath> findList(FinderType<LeasePath> finder, Object ... params) throws TransactionContextException, StorageException {
        LeasePath.Finder lFinder = (LeasePath.Finder)finder;
        switch (lFinder) {
            case ByHolderId: {
                return this.findByHolderId(lFinder, params);
            }
            case ByPrefix: {
                return this.findByPrefix(lFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        this.dataAccess.prepare(this.getRemoved(), this.getAdded(), this.getModified());
    }

    public void clear() throws TransactionContextException {
        super.clear();
        this.hIdToLPsMap.clear();
    }

    LeasePathPK getKey(LeasePath hopLeasePath) {
        return new LeasePathPK(hopLeasePath.getPath(), hopLeasePath.getHolderId());
    }

    private LeasePath findByPath(LeasePath.Finder lFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        String path = (String)params[0];
        LeasePath result = null;
        if (this.containsInHIdToLPsMap(path)) {
            result = this.getLPFromHIdToLPsMap(path);
            this.hit((FinderType)lFinder, result, new Object[]{"path", path});
        } else {
            if (this.nullLPs.contains(path)) {
                return null;
            }
            this.aboutToAccessStorage((FinderType)lFinder, params);
            result = (LeasePath)this.dataAccess.findByPath(path);
            if (result != null) {
                this.gotFromDBInternal(result);
            } else {
                this.nullLPs.add(path);
            }
            this.miss((FinderType)lFinder, result, new Object[]{"path", path});
        }
        return result;
    }

    private Collection<LeasePath> findByHolderId(LeasePath.Finder lFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        int holderId = (Integer)params[0];
        ArrayList<LeasePath> result = null;
        if (this.hIdToLPsMap.containsKey(holderId)) {
            result = new ArrayList<LeasePath>((Collection)this.hIdToLPsMap.get(holderId));
            this.hit((FinderType)lFinder, result, new Object[]{"hid", holderId});
        } else {
            this.aboutToAccessStorage((FinderType)lFinder, params);
            result = this.dataAccess.findByHolderId(holderId);
            this.gotFromDBInternal(holderId, result);
            this.miss((FinderType)lFinder, result, new Object[]{"hid", holderId});
        }
        return result;
    }

    private Collection<LeasePath> findByPrefix(LeasePath.Finder lFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        String prefix = (String)params[0];
        Collection result = null;
        try {
            this.aboutToAccessStorage((FinderType)lFinder, params);
            result = this.dataAccess.findByPrefix(prefix);
            this.gotFromDBInternal(result);
            this.miss((FinderType)lFinder, result, new Object[]{"prefix", prefix, "numOfLps", result.size()});
        }
        catch (StorageCallPreventedException ex) {
            result = this.getFilteredByPrefix(prefix);
            this.hit((FinderType)lFinder, result, new Object[]{"prefix", prefix, "numOfLps", result.size()});
        }
        return result;
    }

    private Collection<LeasePath> getFilteredByPrefix(final String prefix) {
        return this.get((Predicate)new Predicate<BaseEntityContext.ContextEntity>(){

            public boolean apply(BaseEntityContext.ContextEntity input) {
                LeasePath leasePath;
                if (input.getState() != BaseEntityContext.State.REMOVED && (leasePath = (LeasePath)input.getEntity()) != null) {
                    return leasePath.getPath().contains(prefix);
                }
                return false;
            }
        });
    }

    void gotFromDBInternal(LeasePath leasePath) {
        if (leasePath != null) {
            super.gotFromDB((Object)new LeasePathPK(leasePath.getPath(), leasePath.getHolderId()), (Object)leasePath);
            this.addToHIdToLPsMap(leasePath);
        }
    }

    void gotFromDBInternal(Collection<LeasePath> entityList) {
        if (entityList != null && !entityList.isEmpty()) {
            for (LeasePath lp : entityList) {
                this.gotFromDBInternal(lp);
            }
        }
    }

    void gotFromDBInternal(Integer holderId, Collection<LeasePath> entityList) {
        this.gotFromDBInternal(entityList);
        if (entityList == null || entityList.isEmpty()) {
            this.getPathList(holderId).clear();
        }
    }

    private Set<LeasePath> getPathList(int holderId) {
        Set<LeasePath> hopLeasePaths = this.hIdToLPsMap.get(holderId);
        if (hopLeasePaths == null) {
            hopLeasePaths = new HashSet<LeasePath>();
            this.hIdToLPsMap.put(holderId, hopLeasePaths);
        }
        return hopLeasePaths;
    }

    private void removeFromHIdToLPsMap(LeasePath hopLeasePath) {
        Set<LeasePath> hopLeasePaths = this.getPathList(hopLeasePath.getHolderId());
        hopLeasePaths.remove(hopLeasePath);
    }

    private void addToHIdToLPsMap(LeasePath leasePath) {
        Set<LeasePath> hopLeasePaths = this.getPathList(leasePath.getHolderId());
        hopLeasePaths.add(leasePath);
    }

    private boolean containsInHIdToLPsMap(String path) {
        for (int hid : this.hIdToLPsMap.keySet()) {
            for (LeasePath lp : this.hIdToLPsMap.get(hid)) {
                if (!lp.getPath().equals(path)) continue;
                return true;
            }
        }
        return false;
    }

    private LeasePath getLPFromHIdToLPsMap(String path) throws StorageException {
        LeasePath leasePath = null;
        int lpCount = 0;
        for (int hid : this.hIdToLPsMap.keySet()) {
            for (LeasePath lp : this.hIdToLPsMap.get(hid)) {
                if (!lp.getPath().equals(path)) continue;
                ++lpCount;
                leasePath = lp;
            }
        }
        if (lpCount > 1) {
            throw new StorageException("A path can be lease only once at a time");
        }
        return leasePath;
    }

    class LeasePathPK {
        private final String path;
        private final int holderId;

        public LeasePathPK(String path, int holderId) {
            this.path = path;
            this.holderId = holderId;
        }

        public String getPath() {
            return this.path;
        }

        public int getHolderId() {
            return this.holderId;
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + (this.path != null ? this.path.hashCode() : 0);
            hash = 97 * hash + this.holderId;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LeasePathPK other = (LeasePathPK)obj;
            if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
                return false;
            }
            return this.holderId == other.holderId;
        }
    }
}

