/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.common.INodeResolver;
import io.hops.common.INodeUtil;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.exception.TransientStorageException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.metadata.hdfs.entity.INodeCandidatePrimaryKey;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.resolvingcache.Cache;
import io.hops.transaction.EntityManager;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLockTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.sparkproject.guava.base.Joiner;
import org.sparkproject.guava.collect.Iterables;
import org.sparkproject.guava.collect.Lists;

public abstract class BaseINodeLock
extends Lock {
    private final Map<INode, TransactionLockTypes.INodeLockType> allLockedInodesInTx = new HashMap<INode, TransactionLockTypes.INodeLockType>();
    private final ResolvedINodesMap resolvedINodesMap = new ResolvedINodesMap();
    private boolean isPartitionKeyAlreaySet = false;
    private boolean enableHierarchicalLocking = false;
    protected static boolean setPartitionKeyEnabled = false;
    protected static boolean setRandomParitionKeyEnabled = false;
    protected static Random rand = new Random(System.currentTimeMillis());
    private CacheResolver instance = null;

    static void enableSetPartitionKey(boolean enable) {
        setPartitionKeyEnabled = enable;
    }

    static void enableSetRandomPartitionKey(boolean enable) {
        setRandomParitionKeyEnabled = enable;
    }

    protected BaseINodeLock() {
    }

    Iterable<INode> getAllResolvedINodes() {
        return this.resolvedINodesMap.getAll();
    }

    void addPathINodesAndUpdateResolvingCache(String path, List<INode> iNodes) {
        this.addPathINodes(path, iNodes);
        this.updateResolvingCache(path, iNodes);
    }

    void updateResolvingCache(String path, List<INode> iNodes) {
        Cache.getInstance().set(path, iNodes);
    }

    void addPathINodes(String path, List<INode> iNodes) {
        this.resolvedINodesMap.putPathINodes(path, iNodes);
    }

    void addChildINodes(String path, List<INode> iNodes) {
        this.resolvedINodesMap.putChildINodes(path, iNodes);
    }

    void addIndividualINode(INode iNode) {
        this.resolvedINodesMap.putIndividualINode(iNode);
    }

    void addIndividualINodes(List<INode> iNodes) {
        this.resolvedINodesMap.putIndividualINodes(iNodes);
    }

    List<INode> getPathINodes(String path) {
        return this.resolvedINodesMap.getPathINodes(path);
    }

    INode getTargetINode(String path) {
        List list = this.resolvedINodesMap.getPathINodes(path);
        return (INode)list.get(list.size() - 1);
    }

    List<INode> getTargetINodes() {
        ArrayList targetInodes = Lists.newArrayListWithExpectedSize((int)this.resolvedINodesMap.pathToPathINodes.size());
        for (String path : this.resolvedINodesMap.pathToPathINodes.keySet()) {
            List list = this.resolvedINodesMap.getPathINodes(path);
            targetInodes.add(list.get(list.size() - 1));
        }
        targetInodes.addAll(this.resolvedINodesMap.individualInodes);
        return targetInodes;
    }

    List<INode> getChildINodes(String path) {
        return this.resolvedINodesMap.getChildINodes(path);
    }

    public TransactionLockTypes.INodeLockType getLockedINodeLockType(INode inode) {
        return this.allLockedInodesInTx.get(inode);
    }

    protected INode find(TransactionLockTypes.INodeLockType lock, String name, long parentId, long partitionId, long possibleINodeId) throws StorageException, TransactionContextException {
        this.setINodeLockType(lock);
        INode inode = (INode)EntityManager.find((FinderType)INode.Finder.ByNameParentIdAndPartitionId, (Object[])new Object[]{name, parentId, partitionId, possibleINodeId});
        this.addLockedINodes(inode, lock);
        return inode;
    }

    protected INode find(TransactionLockTypes.INodeLockType lock, String name, long parentId, long partitionId) throws StorageException, TransactionContextException {
        this.setINodeLockType(lock);
        INode inode = (INode)EntityManager.find((FinderType)INode.Finder.ByNameParentIdAndPartitionId, (Object[])new Object[]{name, parentId, partitionId});
        this.addLockedINodes(inode, lock);
        return inode;
    }

    protected INode find(TransactionLockTypes.INodeLockType lock, long id) throws StorageException, TransactionContextException {
        this.setINodeLockType(lock);
        INode inode = (INode)EntityManager.find((FinderType)INode.Finder.ByINodeIdFTIS, (Object[])new Object[]{id});
        this.addLockedINodes(inode, lock);
        return inode;
    }

    protected List<INode> find(TransactionLockTypes.INodeLockType lock, String[] names, long[] parentIds, long[] partitionIds, boolean checkLocalCache) throws StorageException, TransactionContextException {
        this.setINodeLockType(lock);
        List inodes = (List)EntityManager.findList((FinderType)(checkLocalCache ? INode.Finder.ByNamesParentIdsAndPartitionIdsCheckLocal : INode.Finder.ByNamesParentIdsAndPartitionIds), (Object[])new Object[]{names, parentIds, partitionIds});
        if (inodes != null) {
            for (INode inode : inodes) {
                this.addLockedINodes(inode, lock);
            }
        }
        return inodes;
    }

    protected void addLockedINodes(INode inode, TransactionLockTypes.INodeLockType lock) {
        if (inode == null) {
            return;
        }
        TransactionLockTypes.INodeLockType oldLock = this.allLockedInodesInTx.get(inode);
        if (oldLock == null || oldLock.compareTo((Enum)lock) < 0) {
            this.allLockedInodesInTx.put(inode, lock);
        }
    }

    protected void setINodeLockType(TransactionLockTypes.INodeLockType lock) throws StorageException {
        switch (lock) {
            case WRITE: 
            case WRITE_ON_TARGET_AND_PARENT: {
                EntityManager.writeLock();
                break;
            }
            case READ: {
                EntityManager.readLock();
                break;
            }
            case READ_COMMITTED: {
                EntityManager.readCommited();
            }
        }
    }

    protected void acquireINodeAttributes() throws StorageException, TransactionContextException {
        ArrayList<INodeCandidatePrimaryKey> pks = new ArrayList<INodeCandidatePrimaryKey>();
        for (INode inode : this.getAllResolvedINodes()) {
            if (!(inode instanceof INodeDirectory) || !((INodeDirectory)inode).isWithQuota()) continue;
            INodeCandidatePrimaryKey pk = new INodeCandidatePrimaryKey(inode.getId());
            pks.add(pk);
        }
        this.acquireLockList(DEFAULT_LOCK_TYPE, DirectoryWithQuotaFeature.Finder.ByINodeIds, new Object[]{pks});
    }

    protected void setPartitioningKey(Long partitionId) throws StorageException, TransactionContextException {
        if (setPartitionKeyEnabled && partitionId != null && !this.isPartitionKeyAlreaySet) {
            Object[] key = new Object[]{partitionId, 0L, ""};
            EntityManager.setPartitionKey(INodeDataAccess.class, (Object)key);
            this.isPartitionKeyAlreaySet = true;
            LOG.trace((Object)("Setting PartitionKey to be " + partitionId));
        } else {
            LOG.trace((Object)"Transaction PartitionKey is not Set");
        }
    }

    protected final Lock.Type getType() {
        return Lock.Type.INode;
    }

    protected static boolean isStoredInDB(INode inode) {
        if (inode instanceof INodeFile) {
            INodeFile file = (INodeFile)inode;
            return file.isFileStoredInDB();
        }
        return false;
    }

    protected List<INode> readUpInodes(INode leaf) throws StorageException, TransactionContextException {
        LinkedList<INode> pathInodes = new LinkedList<INode>();
        pathInodes.add(leaf);
        INode curr = leaf;
        while (curr.getParentId() != 0L && (curr = this.find(TransactionLockTypes.INodeLockType.READ_COMMITTED, curr.getParentId())) != null) {
            pathInodes.addFirst(curr);
        }
        return pathInodes;
    }

    public BaseINodeLock enableHierarchicalLocking(boolean val) {
        this.enableHierarchicalLocking = val;
        return this;
    }

    public TransactionLockTypes.INodeLockType getDefaultInodeLockType() {
        if (this.enableHierarchicalLocking) {
            return TransactionLockTypes.INodeLockType.READ;
        }
        return TransactionLockTypes.INodeLockType.READ_COMMITTED;
    }

    protected TransactionLockTypes.INodeLockType identifyLockType(TransactionLockTypes.INodeLockType lockType, int count, byte[][] components) {
        TransactionLockTypes.INodeLockType lkType = this.isTarget(count, components) ? lockType : (this.isParent(count, components) && TransactionLockTypes.impliesParentWriteLock((TransactionLockTypes.INodeLockType)lockType) ? TransactionLockTypes.INodeLockType.WRITE : this.getDefaultInodeLockType());
        return lkType;
    }

    protected boolean isTarget(int count, byte[][] components) {
        return count == components.length - 1;
    }

    protected boolean isParent(int count, byte[][] components) {
        return count == components.length - 2;
    }

    protected List<INode> resolveUsingCache(TransactionLockTypes.INodeLockType lockType, long inodeId) throws IOException {
        CacheResolver cacheResolver = this.getCacheResolver();
        return cacheResolver.fetchINodes(lockType, inodeId);
    }

    protected CacheResolver getCacheResolver() {
        if (this.instance == null) {
            this.instance = new PathResolver();
        }
        return this.instance;
    }

    protected class PathResolver
    extends CacheResolver {
        protected PathResolver() {
        }

        @Override
        List<INode> fetchINodes(TransactionLockTypes.INodeLockType lockType, String path, boolean resolveLink) throws IOException {
            long[] inodeIds = Cache.getInstance().get(path);
            if (inodeIds != null) {
                String[] names = INode.getPathNames(path);
                boolean partial = names.length > inodeIds.length;
                long[] parentIds = this.getParentIds(inodeIds, partial);
                long[] partitionIds = new long[parentIds.length];
                short depth = 0;
                partitionIds[0] = INodeDirectory.getRootDirPartitionKey();
                for (int i = 1; i < partitionIds.length; ++i) {
                    depth = (short)(depth + 1);
                    partitionIds[i] = INode.calculatePartitionId(parentIds[i], names[i], depth);
                }
                this.setPartitionKey(inodeIds, parentIds, partitionIds, partial);
                List<INode> inodes = this.readINodesWhileRespectingLocks(lockType, path, names, parentIds, partitionIds, resolveLink);
                if (inodes != null && !inodes.isEmpty()) {
                    int verifiedInode = this.verifyINodesPartial(inodes, names, parentIds, inodeIds);
                    for (int diff = inodes.size() - verifiedInode; diff > 0; --diff) {
                        INode node = inodes.remove(inodes.size() - 1);
                        if (node == null) continue;
                        Cache.getInstance().delete(node);
                    }
                    if (verifiedInode <= 1) {
                        return null;
                    }
                    this.tryResolvingTheRest(lockType, path, inodes, resolveLink);
                    return inodes;
                }
            }
            return null;
        }

        INode lockInode(TransactionLockTypes.INodeLockType lockType, long inodeId) throws IOException {
            BaseINodeLock.this.setINodeLockType(lockType);
            INode targetInode = INodeUtil.getNode(inodeId, true);
            BaseINodeLock.this.setINodeLockType(BaseINodeLock.this.getDefaultInodeLockType());
            if (targetInode == null) {
                throw new LeaseExpiredException("No lease on inode: " + inodeId + ": File does not exist. ");
            }
            Cache.getInstance().set(targetInode);
            return targetInode;
        }

        List<INode> lockInodeAndParent(TransactionLockTypes.INodeLockType lockType, long inodeId) throws IOException {
            LinkedList<INode> inodes = new LinkedList<INode>();
            INodeIdentifier targetIdentifier = Cache.getInstance().get(inodeId);
            if (targetIdentifier == null) {
                INode targetInode = INodeUtil.getNode(inodeId, false);
                if (targetInode == null) {
                    throw new LeaseExpiredException("No lease on " + inodeId + ": File does not exist. ");
                }
                targetIdentifier = new INodeIdentifier(Long.valueOf(targetInode.getId()), Long.valueOf(targetInode.getParentId()), targetInode.getLocalName(), targetInode.getPartitionId());
            }
            if (targetIdentifier.getInodeId() == 1L) {
                inodes.add(this.lockInode(lockType, inodeId));
                return inodes;
            }
            BaseINodeLock.this.setINodeLockType(TransactionLockTypes.INodeLockType.WRITE);
            INode parentInode = INodeUtil.getNode(targetIdentifier.getPid(), true);
            if (parentInode == null) {
                Cache.getInstance().delete(targetIdentifier);
                throw new TransientStorageException("wrong inode in the cache");
            }
            inodes.add(parentInode);
            Cache.getInstance().set(parentInode);
            INode targetINode = this.lockInode(lockType, inodeId);
            if (targetINode.getParentId() != parentInode.getId()) {
                throw new TransientStorageException("wrong inode in the cache");
            }
            inodes.add(targetINode);
            return inodes;
        }

        void getPathInodes(long parentId, Map<Long, INode> alreadyFetchedInodes) throws IOException {
            if (parentId == 0L) {
                return;
            }
            INodeIdentifier cur = Cache.getInstance().get(parentId);
            if (cur == null) {
                INode inode = INodeUtil.getNode(parentId, true);
                if (inode == null) {
                    return;
                }
                Cache.getInstance().set(inode);
                alreadyFetchedInodes.put(inode.getId(), inode);
                cur = new INodeIdentifier(Long.valueOf(inode.getId()), Long.valueOf(inode.getParentId()), inode.getLocalName(), inode.getPartitionId());
            }
            HashMap<Long, INodeIdentifier> inodeIdentifiers = new HashMap<Long, INodeIdentifier>();
            while (cur != null) {
                inodeIdentifiers.put(cur.getInodeId(), cur);
                parentId = cur.getPid();
                cur = Cache.getInstance().get(parentId);
            }
            for (INodeIdentifier identifier : inodeIdentifiers.values()) {
                if (!alreadyFetchedInodes.containsKey(identifier.getInodeId())) continue;
                inodeIdentifiers.remove(identifier);
            }
            if (!inodeIdentifiers.isEmpty()) {
                long[] inodeIds = new long[inodeIdentifiers.size()];
                String[] names = new String[inodeIdentifiers.size()];
                long[] parentIds = new long[inodeIdentifiers.size()];
                long[] partitionIds = new long[inodeIdentifiers.size()];
                int i = 0;
                for (INodeIdentifier inode : inodeIdentifiers.values()) {
                    inodeIds[i] = inode.getInodeId();
                    names[i] = inode.getName();
                    parentIds[i] = inode.getPid();
                    partitionIds[i] = inode.getPartitionId();
                    ++i;
                }
                List<INode> inodesFound = BaseINodeLock.this.find(BaseINodeLock.this.getDefaultInodeLockType(), names, parentIds, partitionIds, true);
                for (INode inode : inodesFound) {
                    INodeIdentifier identifier = (INodeIdentifier)inodeIdentifiers.get(inode.getId());
                    if (identifier == null || !inode.getLocalName().equals(identifier.getName()) || inode.getParentId() != identifier.getPid().longValue()) continue;
                    inodeIdentifiers.remove(inode.getId());
                    alreadyFetchedInodes.put(inode.getId(), inode);
                    Cache.getInstance().set(inode);
                }
                for (INodeIdentifier identifier : inodeIdentifiers.values()) {
                    Cache.getInstance().delete(identifier);
                    this.getPathInodes(identifier.getInodeId(), alreadyFetchedInodes);
                }
            }
            if (parentId != 0L) {
                this.getPathInodes(parentId, alreadyFetchedInodes);
            }
        }

        @Override
        List<INode> fetchINodes(TransactionLockTypes.INodeLockType lockType, long inodeId) throws IOException {
            LinkedList<INode> inodes = new LinkedList<INode>();
            if (TransactionLockTypes.impliesParentWriteLock((TransactionLockTypes.INodeLockType)lockType)) {
                inodes.addAll(this.lockInodeAndParent(lockType, inodeId));
            } else {
                inodes.add(this.lockInode(lockType, inodeId));
            }
            HashMap<Long, INode> parentsMap = new HashMap<Long, INode>();
            this.getPathInodes(((INode)inodes.get(0)).getParentId(), parentsMap);
            INode cur = (INode)parentsMap.get(((INode)inodes.get(0)).getParentId());
            while (cur != null) {
                inodes.add(0, cur);
                cur = (INode)parentsMap.get(cur.getParentId());
            }
            return inodes;
        }

        protected void tryResolvingTheRest(TransactionLockTypes.INodeLockType lockType, String path, List<INode> inodes, boolean resolveLink) throws TransactionContextException, UnresolvedPathException, StorageException {
            int offset = inodes.size();
            this.resolveRestOfThePath(lockType, path, inodes, resolveLink);
            this.addPathINodesWithOffset(path, inodes, offset);
        }

        private void addPathINodesWithOffset(String path, List<INode> inodes, int offset) {
            BaseINodeLock.this.addPathINodes(path, inodes);
            if (offset == 0) {
                BaseINodeLock.this.updateResolvingCache(path, inodes);
            } else {
                if (offset == inodes.size()) {
                    return;
                }
                List<INode> newInodes = inodes.subList(offset, inodes.size());
                Object[] newPath = Arrays.copyOfRange(INode.getPathNames(path), offset, inodes.size());
                BaseINodeLock.this.updateResolvingCache(Joiner.on((char)'/').join(newPath), newInodes);
            }
        }

        protected List<INode> readINodesWhileRespectingLocks(TransactionLockTypes.INodeLockType lockType, String path, String[] names, long[] parentIds, long[] partitionIds, boolean resolveLink) throws TransactionContextException, StorageException, UnresolvedPathException {
            boolean partialPath;
            int rowsToReadWithDefaultLock = names.length;
            if (!lockType.equals((Object)BaseINodeLock.this.getDefaultInodeLockType())) {
                rowsToReadWithDefaultLock = lockType.equals((Object)TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT) ? (rowsToReadWithDefaultLock -= 2) : --rowsToReadWithDefaultLock;
            }
            rowsToReadWithDefaultLock = Math.min(rowsToReadWithDefaultLock, parentIds.length);
            List<INode> inodes = null;
            if (rowsToReadWithDefaultLock > 0) {
                inodes = BaseINodeLock.this.find(BaseINodeLock.this.getDefaultInodeLockType(), Arrays.copyOf(names, rowsToReadWithDefaultLock), Arrays.copyOf(parentIds, rowsToReadWithDefaultLock), Arrays.copyOf(partitionIds, rowsToReadWithDefaultLock), true);
            }
            if (inodes != null) {
                for (INode inode : inodes) {
                    BaseINodeLock.this.addLockedINodes(inode, BaseINodeLock.this.getDefaultInodeLockType());
                }
            }
            if (rowsToReadWithDefaultLock == names.length) {
                return inodes;
            }
            boolean bl = partialPath = parentIds.length < names.length;
            if (inodes != null && !partialPath) {
                this.resolveRestOfThePath(lockType, path, inodes, resolveLink);
            }
            return inodes;
        }

        protected void resolveRestOfThePath(TransactionLockTypes.INodeLockType lockType, String path, List<INode> inodes, boolean resolveLink) throws StorageException, TransactionContextException, UnresolvedPathException {
            byte[][] components = INode.getPathComponents(path);
            INode currentINode = inodes.get(inodes.size() - 1);
            INodeResolver resolver = new INodeResolver(components, currentINode, resolveLink, true, inodes.size() - 1);
            while (resolver.hasNext()) {
                TransactionLockTypes.INodeLockType currentINodeLock = BaseINodeLock.this.identifyLockType(lockType, resolver.getCount() + 1, components);
                BaseINodeLock.this.setINodeLockType(currentINodeLock);
                currentINode = resolver.next();
                if (currentINode == null) continue;
                BaseINodeLock.this.addLockedINodes(currentINode, currentINodeLock);
                inodes.add(currentINode);
            }
        }
    }

    protected abstract class CacheResolver {
        protected CacheResolver() {
        }

        abstract List<INode> fetchINodes(TransactionLockTypes.INodeLockType var1, String var2, boolean var3) throws IOException;

        abstract List<INode> fetchINodes(TransactionLockTypes.INodeLockType var1, long var2) throws IOException;

        protected int verifyINodesFull(List<INode> inodes, String[] names, long[] parentIds, long[] inodeIds) throws IOException {
            int index = -1;
            if (names.length == parentIds.length && inodes.size() == names.length) {
                index = this.verifyINodesPartial(inodes, names, parentIds, inodeIds);
            }
            return index;
        }

        protected int verifyINodesPartial(List<INode> inodes, String[] names, long[] parentIds, long[] inodeIds) throws IOException {
            int index = (int)StatUtils.min((double[])new double[]{inodes.size(), inodeIds.length, parentIds.length, names.length});
            for (int i = 0; i < index; ++i) {
                boolean noChangeInInodes;
                INode inode = inodes.get(i);
                boolean bl = noChangeInInodes = inode != null && inode.getLocalName().equals(names[i]) && inode.getParentId() == parentIds[i] && inode.getId() == inodeIds[i];
                if (noChangeInInodes) continue;
                index = i;
                break;
            }
            return index;
        }

        protected int reverseVerifyINodesPartial(List<INode> inodes, String[] names, long[] parentIds, long[] inodeIds) throws IOException {
            int maxIndex = (int)StatUtils.min((double[])new double[]{inodes.size(), inodeIds.length, parentIds.length, names.length});
            for (int i = 1; i <= maxIndex; ++i) {
                boolean noChangeInInodes;
                INode inode = inodes.get(inodes.size() - i);
                boolean bl = noChangeInInodes = inode != null && inode.getLocalName().equals(names[names.length - i]) && inode.getParentId() == parentIds[parentIds.length - i] && inode.getId() == inodeIds[inodeIds.length - i];
                if (noChangeInInodes) continue;
                return i;
            }
            return maxIndex + 1;
        }

        protected long[] getParentIds(long[] inodeIds) {
            return this.getParentIds(inodeIds, false);
        }

        protected long[] getParentIds(long[] inodeIds, boolean partial) {
            long[] parentIds = new long[partial ? inodeIds.length + 1 : inodeIds.length];
            parentIds[0] = 0L;
            System.arraycopy(inodeIds, 0, parentIds, 1, partial ? inodeIds.length : inodeIds.length - 1);
            return parentIds;
        }

        protected void setPartitionKey(long[] inodeIds, long[] parentIds, long[] partitionIds, boolean partial) throws TransactionContextException, StorageException {
            Long partId = null;
            if (partial) {
                if (setRandomParitionKeyEnabled && partId == null) {
                    Lock.LOG.trace((Object)"Setting Random PartitionKey");
                    partId = Math.abs(rand.nextLong());
                }
            } else {
                partId = inodeIds[inodeIds.length - 1];
            }
            BaseINodeLock.this.setPartitioningKey(partId);
        }
    }

    private class ResolvedINodesMap {
        private final Map<String, PathRelatedINodes> pathToPathINodes = new HashMap<String, PathRelatedINodes>();
        private final Collection<INode> individualInodes = new ArrayList<INode>();

        private ResolvedINodesMap() {
        }

        private PathRelatedINodes getWithLazyInit(String path) {
            if (!this.pathToPathINodes.containsKey(path)) {
                PathRelatedINodes pathRelatedINodes = new PathRelatedINodes();
                this.pathToPathINodes.put(path, pathRelatedINodes);
                return pathRelatedINodes;
            }
            return this.pathToPathINodes.get(path);
        }

        private void putPathINodes(String path, List<INode> iNodes) {
            PathRelatedINodes pathRelatedINodes = this.getWithLazyInit(path);
            pathRelatedINodes.pathINodes = iNodes;
        }

        private void putChildINodes(String path, List<INode> iNodes) {
            PathRelatedINodes pathRelatedINodes = this.getWithLazyInit(path);
            pathRelatedINodes.childINodes = iNodes;
        }

        private void putIndividualINode(INode iNode) {
            this.individualInodes.add(iNode);
        }

        private void putIndividualINodes(List<INode> iNodes) {
            for (INode iNode : iNodes) {
                this.individualInodes.add(iNode);
            }
        }

        private List<INode> getPathINodes(String path) {
            PathRelatedINodes pri = this.pathToPathINodes.get(path);
            return pri.pathINodes;
        }

        private final int countResolvedFilesStoredInDB() {
            return this.fileCount(true);
        }

        private final int countResolvedFilesStoredOnDataNodes() {
            return this.fileCount(false);
        }

        private final int fileCount(boolean isStoredInDB) {
            int count = 0;
            for (INode inode : this.getAll()) {
                if (!(inode instanceof INodeFile)) continue;
                INodeFile file = (INodeFile)inode;
                if (isStoredInDB && file.isFileStoredInDB()) {
                    ++count;
                    continue;
                }
                if (isStoredInDB || file.isFileStoredInDB()) continue;
                ++count;
            }
            return count;
        }

        private List<INode> getChildINodes(String path) {
            return this.pathToPathINodes.get(path).childINodes;
        }

        public Iterable<INode> getAll() {
            Iterable iterable = null;
            for (PathRelatedINodes pathRelatedINodes : this.pathToPathINodes.values()) {
                List childINodes;
                List pathINodes = pathRelatedINodes.pathINodes == null ? Collections.EMPTY_LIST : pathRelatedINodes.pathINodes;
                List list = childINodes = pathRelatedINodes.childINodes == null ? Collections.EMPTY_LIST : pathRelatedINodes.childINodes;
                if (iterable == null) {
                    iterable = Iterables.concat((Iterable)pathINodes, (Iterable)childINodes);
                    continue;
                }
                iterable = Iterables.concat((Iterable)iterable, (Iterable)pathINodes, (Iterable)childINodes);
            }
            if (iterable == null) {
                iterable = Collections.EMPTY_LIST;
            }
            return Iterables.concat((Iterable)iterable, this.individualInodes);
        }

        private class PathRelatedINodes {
            private List<INode> pathINodes;
            private List<INode> childINodes;

            private PathRelatedINodes() {
            }
        }
    }
}

