/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.top.metrics;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hdfs.server.namenode.top.window.RollingWindowManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.guava.collect.Lists;

@InterfaceAudience.Private
public class TopMetrics {
    public static final Logger LOG = LoggerFactory.getLogger(TopMetrics.class);
    final Map<Integer, RollingWindowManager> rollingWindowManagers = new HashMap<Integer, RollingWindowManager>();

    private static void logConf(Configuration conf) {
        LOG.info("NNTop conf: dfs.namenode.top.window.num.buckets = " + conf.get("dfs.namenode.top.window.num.buckets"));
        LOG.info("NNTop conf: dfs.namenode.top.num.users = " + conf.get("dfs.namenode.top.num.users"));
        LOG.info("NNTop conf: dfs.namenode.top.windows.minutes = " + conf.get("dfs.namenode.top.windows.minutes"));
    }

    public TopMetrics(Configuration conf, int[] reportingPeriods) {
        TopMetrics.logConf(conf);
        for (int i = 0; i < reportingPeriods.length; ++i) {
            this.rollingWindowManagers.put(reportingPeriods[i], new RollingWindowManager(conf, reportingPeriods[i]));
        }
    }

    public List<RollingWindowManager.TopWindow> getTopWindows() {
        long monoTime = Time.monotonicNow();
        ArrayList windows = Lists.newArrayListWithCapacity((int)this.rollingWindowManagers.size());
        for (Map.Entry<Integer, RollingWindowManager> entry : this.rollingWindowManagers.entrySet()) {
            RollingWindowManager.TopWindow window = entry.getValue().snapshot(monoTime);
            windows.add(window);
        }
        return windows;
    }

    public void report(boolean succeeded, String userName, InetAddress addr, String cmd, String src, String dst, FileStatus status) {
        this.report(userName, cmd);
    }

    public void report(String userName, String cmd) {
        long currTime = Time.monotonicNow();
        this.report(currTime, userName, cmd);
    }

    public void report(long currTime, String userName, String cmd) {
        LOG.debug("a metric is reported: cmd: {} user: {}", (Object)cmd, (Object)userName);
        userName = UserGroupInformation.trimLoginMethod((String)userName);
        for (RollingWindowManager rollingWindowManager : this.rollingWindowManagers.values()) {
            rollingWindowManager.recordMetric(currTime, cmd, userName, 1L);
            rollingWindowManager.recordMetric(currTime, "*", userName, 1L);
        }
    }
}

