/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public class DFSck
extends Configured
implements Tool {
    private static final String USAGE = "Usage: hdfs fsck <path> [-list-corruptfileblocks | [-move | -delete | -openforwrite] [-files [-blocks [-locations | -racks]]]]\n\t<path>\tstart checking from this path\n\t-move\tmove corrupted files to /lost+found\n\t-delete\tdelete corrupted files\n\t-files\tprint out files being checked\n\t-openforwrite\tprint out files opened for write\n\t-list-corruptfileblocks\tprint out list of missing blocks and files they belong to\n\t-blocks\tprint out block report\n\t-locations\tprint out locations for every block\n\t-racks\tprint out network topology for data-node locations\n\t-storagepolicies\tprint out storage policy summary for the blocks\n\n\t-blockId\tprint out which file this blockId belongs to, locations (nodes, racks) of this block, and other diagnostics info (under replicated, corrupted or not, etc)\n\t-replicaDetails\tprint out each replica details \n\nPlease Note:\n\t1. By default fsck ignores files opened for write, use -openforwrite to report such files. They are usually  tagged CORRUPT or HEALTHY depending on their block allocation status\n";
    private final UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
    private final PrintStream out;
    private final URLConnectionFactory connectionFactory;
    private final boolean isSpnegoEnabled;

    public DFSck(Configuration conf) throws IOException {
        this(conf, System.out);
    }

    public DFSck(Configuration conf, PrintStream out) throws IOException {
        super(conf);
        this.out = out;
        this.connectionFactory = URLConnectionFactory.newDefaultURLConnectionFactory(conf);
        this.isSpnegoEnabled = UserGroupInformation.isSecurityEnabled();
    }

    static void printUsage(PrintStream out) {
        out.println("Usage: hdfs fsck <path> [-list-corruptfileblocks | [-move | -delete | -openforwrite] [-files [-blocks [-locations | -racks]]]]\n\t<path>\tstart checking from this path\n\t-move\tmove corrupted files to /lost+found\n\t-delete\tdelete corrupted files\n\t-files\tprint out files being checked\n\t-openforwrite\tprint out files opened for write\n\t-list-corruptfileblocks\tprint out list of missing blocks and files they belong to\n\t-blocks\tprint out block report\n\t-locations\tprint out locations for every block\n\t-racks\tprint out network topology for data-node locations\n\t-storagepolicies\tprint out storage policy summary for the blocks\n\n\t-blockId\tprint out which file this blockId belongs to, locations (nodes, racks) of this block, and other diagnostics info (under replicated, corrupted or not, etc)\n\t-replicaDetails\tprint out each replica details \n\nPlease Note:\n\t1. By default fsck ignores files opened for write, use -openforwrite to report such files. They are usually  tagged CORRUPT or HEALTHY depending on their block allocation status\n\n");
        ToolRunner.printGenericCommandUsage((PrintStream)out);
    }

    public int run(final String[] args) throws IOException {
        if (args.length == 0) {
            DFSck.printUsage(System.err);
            return -1;
        }
        try {
            return (Integer)UserGroupInformation.getCurrentUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() throws Exception {
                    return DFSck.this.doWork(args);
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer listCorruptFileBlocks(String dir, String baseUrl) throws IOException {
        int errCode = -1;
        int numCorrupt = 0;
        int cookie = 0;
        String noCorruptLine = "has no CORRUPT files";
        String noMoreCorruptLine = "has no more CORRUPT files";
        String cookiePrefix = "Cookie:";
        boolean allDone = false;
        block7: while (!allDone) {
            URLConnection connection;
            StringBuffer url = new StringBuffer(baseUrl);
            if (cookie > 0) {
                url.append("&startblockafter=").append(String.valueOf(cookie));
            }
            URL path = new URL(url.toString());
            try {
                connection = this.connectionFactory.openConnection(path, this.isSpnegoEnabled);
            }
            catch (AuthenticationException e) {
                throw new IOException(e);
            }
            InputStream stream = connection.getInputStream();
            try (BufferedReader input = new BufferedReader(new InputStreamReader(stream, "UTF-8"));){
                String line = null;
                while ((line = input.readLine()) != null) {
                    if (line.startsWith("Cookie:")) {
                        try {
                            cookie = Integer.parseInt(line.split("\t")[1]);
                            continue;
                        }
                        catch (Exception e) {
                            allDone = true;
                            continue block7;
                        }
                    }
                    if (line.endsWith("has no CORRUPT files") || line.endsWith("has no more CORRUPT files") || line.endsWith("does not exist")) {
                        allDone = true;
                        continue block7;
                    }
                    if (line.isEmpty() || line.startsWith("FSCK started by") || line.startsWith("The filesystem under path")) continue;
                    if (++numCorrupt == 1) {
                        this.out.println("The list of corrupt files under path '" + dir + "' are:");
                    }
                    this.out.println(line);
                }
            }
        }
        this.out.println("The filesystem under path '" + dir + "' has " + numCorrupt + " CORRUPT files");
        if (numCorrupt == 0) {
            errCode = 0;
        }
        return errCode;
    }

    private Path getResolvedPath(String dir) throws IOException {
        Configuration conf = this.getConf();
        Path dirPath = new Path(dir);
        FileSystem fs = dirPath.getFileSystem(conf);
        return fs.resolvePath(dirPath);
    }

    private URI getCurrentNamenodeAddress(Path target) throws IOException {
        Configuration conf = this.getConf();
        FileSystem fs = target.getFileSystem(conf);
        if (!(fs instanceof DistributedFileSystem)) {
            System.err.println("FileSystem is " + fs.getUri());
            return null;
        }
        return DFSUtil.getInfoServer(HAUtil.getAddressOfActive(fs), conf, DFSUtil.getHttpClientScheme(conf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doWork(String[] args) throws IOException {
        URLConnection connection;
        StringBuilder url = new StringBuilder();
        url.append("/fsck?ugi=").append(this.ugi.getShortUserName());
        String dir = null;
        boolean doListCorruptFileBlocks = false;
        for (int idx = 0; idx < args.length; ++idx) {
            if (args[idx].equals("-move")) {
                url.append("&move=1");
                continue;
            }
            if (args[idx].equals("-delete")) {
                url.append("&delete=1");
                continue;
            }
            if (args[idx].equals("-files")) {
                url.append("&files=1");
                continue;
            }
            if (args[idx].equals("-openforwrite")) {
                url.append("&openforwrite=1");
                continue;
            }
            if (args[idx].equals("-blocks")) {
                url.append("&blocks=1");
                continue;
            }
            if (args[idx].equals("-locations")) {
                url.append("&locations=1");
                continue;
            }
            if (args[idx].equals("-racks")) {
                url.append("&racks=1");
                continue;
            }
            if (args[idx].equals("-replicaDetails")) {
                url.append("&replicadetails=1");
                continue;
            }
            if (args[idx].equals("-storagepolicies")) {
                url.append("&storagepolicies=1");
                continue;
            }
            if (args[idx].equals("-list-corruptfileblocks")) {
                url.append("&listcorruptfileblocks=1");
                doListCorruptFileBlocks = true;
                continue;
            }
            if (args[idx].equals("-blockId")) {
                StringBuilder sb = new StringBuilder();
                ++idx;
                while (idx < args.length && !args[idx].startsWith("-")) {
                    sb.append(args[idx]);
                    sb.append(" ");
                    ++idx;
                }
                url.append("&blockId=").append(URLEncoder.encode(sb.toString(), "UTF-8"));
                continue;
            }
            if (!args[idx].startsWith("-")) {
                if (null == dir) {
                    dir = args[idx];
                    continue;
                }
                System.err.println("fsck: can only operate on one path at a time '" + args[idx] + "'");
                DFSck.printUsage(System.err);
                return -1;
            }
            System.err.println("fsck: Illegal option '" + args[idx] + "'");
            DFSck.printUsage(System.err);
            return -1;
        }
        if (null == dir) {
            dir = "/";
        }
        Path dirpath = null;
        URI namenodeAddress = null;
        try {
            dirpath = this.getResolvedPath(dir);
            namenodeAddress = this.getCurrentNamenodeAddress(dirpath);
        }
        catch (IOException ioe) {
            System.err.println("FileSystem is inaccessible due to:\n" + StringUtils.stringifyException((Throwable)ioe));
        }
        if (namenodeAddress == null) {
            System.err.println("DFSck exiting.");
            return 0;
        }
        url.insert(0, namenodeAddress.toString());
        url.append("&path=").append(URLEncoder.encode(Path.getPathWithoutSchemeAndAuthority((Path)dirpath).toString(), "UTF-8"));
        System.err.println("Connecting to namenode via " + url.toString());
        if (doListCorruptFileBlocks) {
            return this.listCorruptFileBlocks(dir, url.toString());
        }
        URL path = new URL(url.toString());
        try {
            connection = this.connectionFactory.openConnection(path, this.isSpnegoEnabled);
        }
        catch (AuthenticationException e) {
            throw new IOException(e);
        }
        InputStream stream = connection.getInputStream();
        BufferedReader input = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        String line = null;
        String lastLine = null;
        int errCode = -1;
        try {
            while ((line = input.readLine()) != null) {
                this.out.println(line);
                lastLine = line;
            }
        }
        finally {
            input.close();
        }
        if (lastLine.endsWith("is HEALTHY")) {
            errCode = 0;
        } else if (lastLine.endsWith("is CORRUPT")) {
            errCode = 1;
        } else if (lastLine.endsWith("does not exist")) {
            errCode = 0;
        } else if (lastLine.contains("Incorrect blockId format:")) {
            errCode = 0;
        } else if (lastLine.endsWith("is DECOMMISSIONED")) {
            errCode = 2;
        } else if (lastLine.endsWith("is DECOMMISSIONING")) {
            errCode = 3;
        }
        return errCode;
    }

    public static void main(String[] args) throws Exception {
        int res = -1;
        if (args.length == 0 || "-files".equals(args[0])) {
            DFSck.printUsage(System.err);
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
        } else {
            res = DFSUtil.parseHelpArgument(args, USAGE, System.out, true) ? 0 : ToolRunner.run((Tool)new DFSck(new HdfsConfiguration()), (String[])args);
        }
        System.exit(res);
    }

    static {
        HdfsConfiguration.init();
    }
}

