/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web.webhdfs;

import io.hops.common.security.FsSecurityActions;
import io.hops.common.security.HopsworksFsSecurityActions;
import io.hops.security.CertificateLocalizationCtx;
import io.hops.security.HopsSecurityActionsFactory;
import io.hops.security.HopsX509AuthenticationException;
import io.hops.security.HopsX509Authenticator;
import io.hops.security.HopsX509AuthenticatorFactory;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.ssl.SslHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.commons.net.util.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.WebHdfsHandler;
import org.sparkproject.guava.base.Preconditions;

public class HopsWebHdfsHandler
extends WebHdfsHandler {
    private final HopsX509Authenticator authenticator;
    private final FsSecurityActions fsSecurityActions;

    public HopsWebHdfsHandler(Configuration conf, Configuration confForCreate) throws Exception {
        super(conf, confForCreate);
        this.authenticator = HopsX509AuthenticatorFactory.getInstance((Configuration)conf).getAuthenticator();
        this.fsSecurityActions = (FsSecurityActions)HopsSecurityActionsFactory.getInstance().getActor(conf, conf.get("dfs.security-actions.actor-class", "io.hops.common.security.HopsworksFsSecurityActions"));
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, HttpRequest req) throws Exception {
        Preconditions.checkArgument((boolean)req.getUri().startsWith("/webhdfs/v1"));
        this.extractParams(req);
        this.buildUGI();
        this.injectToken();
        InetAddress remoteAddress = ((InetSocketAddress)ctx.channel().remoteAddress()).getAddress();
        X509Certificate clientCertificate = this.extractUserX509(ctx);
        this.authenticator.authenticateConnection(this.ugi, clientCertificate, remoteAddress, "WebHDFS");
        this.localizeUserX509Material();
        this.doHandle(ctx, req);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        super.exceptionCaught(ctx, cause);
        try {
            CertificateLocalizationCtx.getInstance().getCertificateLocalization().removeX509Material(this.ugi.getUserName());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private void localizeUserX509Material() throws URISyntaxException, GeneralSecurityException, IOException, InterruptedException {
        HopsworksFsSecurityActions.X509CredentialsDTO credentials = this.fsSecurityActions.getX509Credentials(this.ugi.getUserName());
        if (!"jks".equals(credentials.getFileExtension())) {
            throw new IOException("Unknown X.509 format: " + credentials.getFileExtension());
        }
        ByteBuffer keyStore = ByteBuffer.wrap(Base64.decodeBase64((String)credentials.getkStore()));
        ByteBuffer trustStore = ByteBuffer.wrap(Base64.decodeBase64((String)credentials.gettStore()));
        String password = credentials.getPassword();
        CertificateLocalizationCtx.getInstance().getCertificateLocalization().materializeCertificates(this.ugi.getUserName(), this.ugi.getUserName(), keyStore, password, trustStore, password);
    }

    private X509Certificate extractUserX509(ChannelHandlerContext ctx) throws HopsX509AuthenticationException {
        SslHandler sslHandler = ctx.pipeline().get(SslHandler.class);
        if (sslHandler == null) {
            throw new HopsX509AuthenticationException("Could not get SSLHandler from pipeline");
        }
        try {
            return (X509Certificate)sslHandler.engine().getSession().getPeerCertificates()[0];
        }
        catch (SSLPeerUnverifiedException ex) {
            throw new HopsX509AuthenticationException((Throwable)ex);
        }
    }
}

