/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.util.Arrays;
import org.sparkproject.guava.base.Preconditions;

public class EnumDoubles<E extends Enum<E>> {
    private final Class<E> enumClass;
    private final double[] doubles;

    public EnumDoubles(Class<E> enumClass) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        Preconditions.checkNotNull((Object)enumConstants);
        this.enumClass = enumClass;
        this.doubles = new double[enumConstants.length];
    }

    public final double get(E e) {
        return this.doubles[((Enum)e).ordinal()];
    }

    public final void negation() {
        for (int i = 0; i < this.doubles.length; ++i) {
            this.doubles[i] = -this.doubles[i];
        }
    }

    public final void set(E e, double value) {
        this.doubles[((Enum)e).ordinal()] = value;
    }

    public final void set(EnumDoubles<E> that) {
        for (int i = 0; i < this.doubles.length; ++i) {
            this.doubles[i] = that.doubles[i];
        }
    }

    public final void reset() {
        for (int i = 0; i < this.doubles.length; ++i) {
            this.doubles[i] = 0.0;
        }
    }

    public final void add(E e, double value) {
        int n = ((Enum)e).ordinal();
        this.doubles[n] = this.doubles[n] + value;
    }

    public final void add(EnumDoubles<E> that) {
        for (int i = 0; i < this.doubles.length; ++i) {
            int n = i;
            this.doubles[n] = this.doubles[n] + that.doubles[i];
        }
    }

    public final void subtract(E e, double value) {
        int n = ((Enum)e).ordinal();
        this.doubles[n] = this.doubles[n] - value;
    }

    public final void subtract(EnumDoubles<E> that) {
        for (int i = 0; i < this.doubles.length; ++i) {
            int n = i;
            this.doubles[n] = this.doubles[n] - that.doubles[i];
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof EnumDoubles)) {
            return false;
        }
        EnumDoubles that = (EnumDoubles)obj;
        return this.enumClass == that.enumClass && Arrays.equals(this.doubles, that.doubles);
    }

    public int hashCode() {
        return Arrays.hashCode(this.doubles);
    }

    public String toString() {
        Enum[] enumConstants = (Enum[])this.enumClass.getEnumConstants();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.doubles.length; ++i) {
            String name = enumConstants[i].name();
            b.append(name).append("=").append(this.doubles[i]).append(", ");
        }
        return b.substring(0, b.length() - 2);
    }
}

