/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.util.AtomicFileOutputStream;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.util.StringUtils;
import org.sparkproject.guava.base.Charsets;

public abstract class MD5FileUtils {
    private static final Log LOG = LogFactory.getLog(MD5FileUtils.class);
    public static final String MD5_SUFFIX = ".md5";
    private static final Pattern LINE_REGEX = Pattern.compile("([0-9a-f]{32}) [ \\*](.+)");

    public static void verifySavedMD5(File dataFile, MD5Hash expectedMD5) throws IOException {
        MD5Hash storedHash = MD5FileUtils.readStoredMd5ForFile(dataFile);
        if (!expectedMD5.equals((Object)storedHash)) {
            throw new IOException("File " + dataFile + " did not match stored MD5 checksum  (stored: " + storedHash + ", computed: " + expectedMD5);
        }
    }

    private static Matcher readStoredMd5(File md5File) throws IOException {
        String md5Line;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(md5File), Charsets.UTF_8));
        try {
            md5Line = reader.readLine();
            if (md5Line == null) {
                md5Line = "";
            }
            md5Line = md5Line.trim();
        }
        catch (IOException ioe) {
            try {
                throw new IOException("Error reading md5 file at " + md5File, ioe);
            }
            catch (Throwable throwable) {
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{reader});
                throw throwable;
            }
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{reader});
        Matcher matcher = LINE_REGEX.matcher(md5Line);
        if (!matcher.matches()) {
            throw new IOException("Invalid MD5 file " + md5File + ": the content \"" + md5Line + "\" does not match the expected pattern.");
        }
        return matcher;
    }

    public static MD5Hash readStoredMd5ForFile(File dataFile) throws IOException {
        File md5File = MD5FileUtils.getDigestFileForFile(dataFile);
        if (!md5File.exists()) {
            return null;
        }
        Matcher matcher = MD5FileUtils.readStoredMd5(md5File);
        String storedHash = matcher.group(1);
        File referencedFile = new File(matcher.group(2));
        if (!referencedFile.getName().equals(dataFile.getName())) {
            throw new IOException("MD5 file at " + md5File + " references file named " + referencedFile.getName() + " but we expected it to reference " + dataFile);
        }
        return new MD5Hash(storedHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MD5Hash computeMd5ForFile(File dataFile) throws IOException {
        FileInputStream in = new FileInputStream(dataFile);
        try {
            MessageDigest digester = MD5Hash.getDigester();
            DigestInputStream dis = new DigestInputStream(in, digester);
            IOUtils.copyBytes((InputStream)dis, (OutputStream)new IOUtils.NullOutputStream(), (int)131072);
            MD5Hash mD5Hash = new MD5Hash(digester.digest());
            return mD5Hash;
        }
        finally {
            IOUtils.closeStream((Closeable)in);
        }
    }

    public static void saveMD5File(File dataFile, MD5Hash digest) throws IOException {
        String digestString = StringUtils.byteToHexString((byte[])digest.getDigest());
        MD5FileUtils.saveMD5File(dataFile, digestString);
    }

    private static void saveMD5File(File dataFile, String digestString) throws IOException {
        File md5File = MD5FileUtils.getDigestFileForFile(dataFile);
        String md5Line = digestString + " *" + dataFile.getName() + "\n";
        AtomicFileOutputStream afos = new AtomicFileOutputStream(md5File);
        afos.write(md5Line.getBytes(Charsets.UTF_8));
        afos.close();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Saved MD5 " + digestString + " to " + md5File));
        }
    }

    public static void renameMD5File(File oldDataFile, File newDataFile) throws IOException {
        File fromFile = MD5FileUtils.getDigestFileForFile(oldDataFile);
        if (!fromFile.exists()) {
            throw new FileNotFoundException(fromFile + " does not exist.");
        }
        String digestString = MD5FileUtils.readStoredMd5(fromFile).group(1);
        MD5FileUtils.saveMD5File(newDataFile, digestString);
        if (!fromFile.delete()) {
            LOG.warn((Object)("deleting  " + fromFile.getAbsolutePath() + " FAILED"));
        }
    }

    public static File getDigestFileForFile(File file) {
        return new File(file.getParentFile(), file.getName() + MD5_SUFFIX);
    }
}

