/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class GetNewApplicationResponsePBImpl
extends GetNewApplicationResponse {
    YarnServiceProtos.GetNewApplicationResponseProto proto = YarnServiceProtos.GetNewApplicationResponseProto.getDefaultInstance();
    YarnServiceProtos.GetNewApplicationResponseProto.Builder builder = null;
    boolean viaProto = false;
    private ApplicationId applicationId = null;
    private Resource maximumResourceCapability = null;

    public GetNewApplicationResponsePBImpl() {
        this.builder = YarnServiceProtos.GetNewApplicationResponseProto.newBuilder();
    }

    public GetNewApplicationResponsePBImpl(YarnServiceProtos.GetNewApplicationResponseProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServiceProtos.GetNewApplicationResponseProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((GetNewApplicationResponsePBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    private void mergeLocalToBuilder() {
        if (this.applicationId != null) {
            this.builder.setApplicationId(this.convertToProtoFormat(this.applicationId));
        }
        if (this.maximumResourceCapability != null) {
            this.builder.setMaximumCapability(this.convertToProtoFormat(this.maximumResourceCapability));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.GetNewApplicationResponseProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public ApplicationId getApplicationId() {
        YarnServiceProtos.GetNewApplicationResponseProtoOrBuilder p;
        if (this.applicationId != null) {
            return this.applicationId;
        }
        YarnServiceProtos.GetNewApplicationResponseProtoOrBuilder getNewApplicationResponseProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasApplicationId()) {
            return null;
        }
        this.applicationId = this.convertFromProtoFormat(p.getApplicationId());
        return this.applicationId;
    }

    @Override
    public void setApplicationId(ApplicationId applicationId) {
        this.maybeInitBuilder();
        if (applicationId == null) {
            this.builder.clearApplicationId();
        }
        this.applicationId = applicationId;
    }

    @Override
    public Resource getMaximumResourceCapability() {
        YarnServiceProtos.GetNewApplicationResponseProtoOrBuilder p;
        if (this.maximumResourceCapability != null) {
            return this.maximumResourceCapability;
        }
        YarnServiceProtos.GetNewApplicationResponseProtoOrBuilder getNewApplicationResponseProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasMaximumCapability()) {
            return null;
        }
        this.maximumResourceCapability = this.convertFromProtoFormat(p.getMaximumCapability());
        return this.maximumResourceCapability;
    }

    @Override
    public void setMaximumResourceCapability(Resource capability) {
        this.maybeInitBuilder();
        if (this.maximumResourceCapability == null) {
            this.builder.clearMaximumCapability();
        }
        this.maximumResourceCapability = capability;
    }

    private ApplicationIdPBImpl convertFromProtoFormat(YarnProtos.ApplicationIdProto p) {
        return new ApplicationIdPBImpl(p);
    }

    private YarnProtos.ApplicationIdProto convertToProtoFormat(ApplicationId t) {
        return ((ApplicationIdPBImpl)t).getProto();
    }

    private Resource convertFromProtoFormat(YarnProtos.ResourceProto resource) {
        return new ResourcePBImpl(resource);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource resource) {
        return ProtoUtils.convertToProtoFormat(resource);
    }
}

