/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.streaming.kafka010.ConsumerStrategies;
import org.apache.spark.streaming.kafka010.ConsumerStrategy;
import org.junit.Assert;
import org.junit.Test;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Map;

public class JavaConsumerStrategySuite
implements Serializable {
    @Test
    public void testConsumerStrategyConstructors() {
        String topic1 = "topic1";
        Pattern pat = Pattern.compile("top.*");
        List<String> topics = Arrays.asList("topic1");
        Iterable sTopics = (Iterable)JavaConverters.collectionAsScalaIterableConverter(topics).asScala();
        TopicPartition tp1 = new TopicPartition("topic1", 0);
        TopicPartition tp2 = new TopicPartition("topic1", 1);
        List<TopicPartition> parts = Arrays.asList(tp1, tp2);
        Iterable sParts = (Iterable)JavaConverters.collectionAsScalaIterableConverter(parts).asScala();
        HashMap<String, String> kafkaParams = new HashMap<String, String>();
        kafkaParams.put("bootstrap.servers", "not used");
        Map sKafkaParams = (Map)JavaConverters.mapAsScalaMapConverter(kafkaParams).asScala();
        HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
        offsets.put(tp1, 23L);
        HashMap dummyOffsets = new HashMap();
        for (Map.Entry kv : offsets.entrySet()) {
            dummyOffsets.put(kv.getKey(), kv.getValue());
        }
        scala.collection.mutable.Map sOffsets = JavaConverters.mapAsScalaMap(dummyOffsets);
        ConsumerStrategy sub1 = ConsumerStrategies.Subscribe((Iterable)sTopics, (Map)sKafkaParams, (Map)sOffsets);
        ConsumerStrategy sub2 = ConsumerStrategies.Subscribe((Iterable)sTopics, (Map)sKafkaParams);
        ConsumerStrategy sub3 = ConsumerStrategies.Subscribe(topics, kafkaParams, offsets);
        ConsumerStrategy sub4 = ConsumerStrategies.Subscribe(topics, kafkaParams);
        Assert.assertEquals(sub1.executorKafkaParams().get("bootstrap.servers"), sub3.executorKafkaParams().get("bootstrap.servers"));
        ConsumerStrategy psub1 = ConsumerStrategies.SubscribePattern((Pattern)pat, (Map)sKafkaParams, (Map)sOffsets);
        ConsumerStrategy psub2 = ConsumerStrategies.SubscribePattern((Pattern)pat, (Map)sKafkaParams);
        ConsumerStrategy psub3 = ConsumerStrategies.SubscribePattern((Pattern)pat, kafkaParams, offsets);
        ConsumerStrategy psub4 = ConsumerStrategies.SubscribePattern((Pattern)pat, kafkaParams);
        Assert.assertEquals(psub1.executorKafkaParams().get("bootstrap.servers"), psub3.executorKafkaParams().get("bootstrap.servers"));
        ConsumerStrategy asn1 = ConsumerStrategies.Assign((Iterable)sParts, (Map)sKafkaParams, (Map)sOffsets);
        ConsumerStrategy asn2 = ConsumerStrategies.Assign((Iterable)sParts, (Map)sKafkaParams);
        ConsumerStrategy asn3 = ConsumerStrategies.Assign(parts, kafkaParams, offsets);
        ConsumerStrategy asn4 = ConsumerStrategies.Assign(parts, kafkaParams);
        Assert.assertEquals(asn1.executorKafkaParams().get("bootstrap.servers"), asn3.executorKafkaParams().get("bootstrap.servers"));
    }
}

