/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.spark.Dependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.TestUtils$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rdd.PairRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.streaming.BatchCounter;
import org.apache.spark.streaming.Checkpoint;
import org.apache.spark.streaming.Checkpoint$;
import org.apache.spark.streaming.CheckpointInputDStream;
import org.apache.spark.streaming.CheckpointSuite$;
import org.apache.spark.streaming.CheckpointSuite$$anonfun$34$;
import org.apache.spark.streaming.CheckpointSuite$$anonfun$40$;
import org.apache.spark.streaming.CheckpointSuite$$anonfun$40$$anonfun$apply$19$;
import org.apache.spark.streaming.CheckpointSuite$$anonfun$40$$anonfun$apply$25$;
import org.apache.spark.streaming.CheckpointSuite$$anonfun$45$;
import org.apache.spark.streaming.CheckpointWriter;
import org.apache.spark.streaming.DStreamCheckpointTester;
import org.apache.spark.streaming.DStreamCheckpointTester$class;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Milliseconds$;
import org.apache.spark.streaming.ObjectInputStreamWithLoader;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.StreamingContext$;
import org.apache.spark.streaming.TestOutputStream;
import org.apache.spark.streaming.TestOutputStreamWithPartitions;
import org.apache.spark.streaming.TestOutputStreamWithPartitions$;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.TestSuiteBase$class;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.streaming.dstream.FileInputDStream;
import org.apache.spark.streaming.dstream.PairDStreamFunctions;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.scheduler.ConstantEstimator;
import org.apache.spark.streaming.scheduler.JobGenerator;
import org.apache.spark.streaming.scheduler.RateTestInputDStream;
import org.apache.spark.streaming.scheduler.RateTestReceiver;
import org.apache.spark.streaming.scheduler.RateTestReceiver$;
import org.apache.spark.streaming.scheduler.rate.RateEstimator;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.apache.spark.util.MutableURLClassLoader;
import org.apache.spark.util.ResetSystemProperties;
import org.apache.spark.util.Utils$;
import org.mockito.Mockito;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.time.SpanSugar$;
import org.spark_project.guava.io.Files;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.VolatileBooleanRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0001\u0003\u0001-\u0011qb\u00115fG.\u0004x.\u001b8u'VLG/\u001a\u0006\u0003\u0007\u0011\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003\u0019\t\u0007/Y2iK*\t\u0011\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001\u0019A!r\u0003\u0005\u0002\u000e\u001d5\tA!\u0003\u0002\u0010\t\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003\u001bQ+7\u000f^*vSR,')Y:f!\t\tR#\u0003\u0002\u0017\u0005\t9Bi\u0015;sK\u0006l7\t[3dWB|\u0017N\u001c;UKN$XM\u001d\t\u00031mi\u0011!\u0007\u0006\u00035\u0011\tA!\u001e;jY&\u0011A$\u0007\u0002\u0016%\u0016\u001cX\r^*zgR,W\u000e\u0015:pa\u0016\u0014H/[3t\u0011\u0015q\u0002\u0001\"\u0001 \u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\u0012\u0001!9!\u0005\u0001a\u0001\n\u0003\u0019\u0013aA:tGV\tA\u0005\u0005\u0002\u0012K%\u0011aE\u0001\u0002\u0011'R\u0014X-Y7j]\u001e\u001cuN\u001c;fqRDq\u0001\u000b\u0001A\u0002\u0013\u0005\u0011&A\u0004tg\u000e|F%Z9\u0015\u0005)\u0002\u0004CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#\u0001B+oSRDq!M\u0014\u0002\u0002\u0003\u0007A%A\u0002yIEBaa\r\u0001!B\u0013!\u0013\u0001B:tG\u0002BQ!\u000e\u0001\u0005BY\nQBY1uG\"$UO]1uS>tW#A\u001c\u0011\u0005EA\u0014BA\u001d\u0003\u0005!!UO]1uS>t\u0007\"B\u001e\u0001\t\u0003b\u0014A\u00042fM>\u0014XMR;oGRLwN\u001c\u000b\u0002U!)a\b\u0001C!y\u0005i\u0011M\u001a;fe\u001a+hn\u0019;j_:DQ\u0001\u0011\u0001\u0005\u0002\u0005\u000b\u0001$\u00193wC:\u001cW\rV5nK^KG\u000f\u001b*fC2$U\r\\1z+\t\u0011U\u000bF\u0002DM\u001e$\"\u0001\u00120\u0011\u0007\u0015k\u0005K\u0004\u0002G\u0017:\u0011qIS\u0007\u0002\u0011*\u0011\u0011JC\u0001\u0007yI|w\u000e\u001e \n\u00035J!\u0001\u0014\u0017\u0002\u000fA\f7m[1hK&\u0011aj\u0014\u0002\t\u0013R,'/\u00192mK*\u0011A\n\f\t\u0004\u000bF\u001b\u0016B\u0001*P\u0005\r\u0019V-\u001d\t\u0003)Vc\u0001\u0001B\u0003W\u007f\t\u0007qKA\u0001W#\tA6\f\u0005\u0002,3&\u0011!\f\f\u0002\b\u001d>$\b.\u001b8h!\tYC,\u0003\u0002^Y\t\u0019\u0011I\\=\t\u000f}{\u0014\u0011!a\u0002A\u0006QQM^5eK:\u001cW\r\n\u001c\u0011\u0007\u0005$7+D\u0001c\u0015\t\u0019G&A\u0004sK\u001adWm\u0019;\n\u0005\u0015\u0014'\u0001C\"mCN\u001cH+Y4\t\u000b\tz\u0004\u0019\u0001\u0013\t\u000b!|\u0004\u0019A5\u0002\u00159,XNQ1uG\",7\u000f\u0005\u0002,U&\u00111\u000e\f\u0002\u0005\u0019>twmB\u0003n\u0005!%a.A\bDQ\u0016\u001c7\u000e]8j]R\u001cV/\u001b;f!\t\trNB\u0003\u0002\u0005!%\u0001oE\u0002pcR\u0004\"a\u000b:\n\u0005Md#AB!osJ+g\r\u0005\u0002vu6\taO\u0003\u0002xq\u0006\u0011\u0011n\u001c\u0006\u0002s\u0006!!.\u0019<b\u0013\tYhO\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003\u001f_\u0012\u0005Q\u0010F\u0001o\u0011!yx\u000e1A\u0005\u0002\u0005\u0005\u0011A\b2bi\u000eDG\u000b\u001b:fKNCw.\u001e7e\u00052|7m[!M_:<G+[7f+\t\t\u0019\u0001E\u0002,\u0003\u000bI1!a\u0002-\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u0003p\u0001\u0004%\t!!\u0004\u0002E\t\fGo\u00195UQJ,Wm\u00155pk2$'\t\\8dW\u0006cuN\\4US6,w\fJ3r)\rQ\u0013q\u0002\u0005\nc\u0005%\u0011\u0011!a\u0001\u0003\u0007A\u0001\"a\u0005pA\u0003&\u00111A\u0001 E\u0006$8\r\u001b+ie\u0016,7\u000b[8vY\u0012\u0014En\\2l\u00032{gn\u001a+j[\u0016\u0004\u0003\"CA\f_\u0006\u0005I\u0011BA\r\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005m\u0001\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u0005\u00020\u0001\u0003mC:<\u0017\u0002BA\u0013\u0003?\u0011aa\u00142kK\u000e$\b")
public class CheckpointSuite
extends SparkFunSuite
implements TestSuiteBase,
DStreamCheckpointTester,
ResetSystemProperties {
    private StreamingContext ssc;
    private Properties oldProperties;
    private final String checkpointDir;
    private final SparkConf conf;
    private final PatienceConfiguration.Timeout eventuallyTimeout;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    private volatile boolean bitmap$0;

    public static void batchThreeShouldBlockALongTime_$eq(boolean bl) {
        CheckpointSuite$.MODULE$.batchThreeShouldBlockALongTime_$eq(bl);
    }

    public static boolean batchThreeShouldBlockALongTime() {
        return CheckpointSuite$.MODULE$.batchThreeShouldBlockALongTime();
    }

    public Properties oldProperties() {
        return this.oldProperties;
    }

    public void oldProperties_$eq(Properties x$1) {
        this.oldProperties = x$1;
    }

    public /* synthetic */ void org$apache$spark$util$ResetSystemProperties$$super$beforeEach() {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this);
    }

    public /* synthetic */ void org$apache$spark$util$ResetSystemProperties$$super$afterEach() {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this);
    }

    public void beforeEach() {
        ResetSystemProperties.class.beforeEach((ResetSystemProperties)this);
    }

    public void afterEach() {
        ResetSystemProperties.class.afterEach((ResetSystemProperties)this);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.class.runTest((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    @Override
    public <U, V> void testCheckpointedOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation2, Seq<Seq<V>> expectedOutput, int numBatchesBeforeRestart, Duration batchDuration, boolean stopSparkContextAfterTest, ClassTag<U> evidence$1, ClassTag<V> evidence$2) {
        DStreamCheckpointTester$class.testCheckpointedOperation(this, input, operation2, expectedOutput, numBatchesBeforeRestart, batchDuration, stopSparkContextAfterTest, evidence$1, evidence$2);
    }

    @Override
    public StreamingContext createContextForCheckpointOperation(Duration batchDuration) {
        return DStreamCheckpointTester$class.createContextForCheckpointOperation(this, batchDuration);
    }

    @Override
    public <V> TestOutputStreamWithPartitions<V> getTestOutputStream(DStream<?>[] streams, ClassTag<V> evidence$3) {
        return DStreamCheckpointTester$class.getTestOutputStream(this, streams, evidence$3);
    }

    @Override
    public <V> Seq<Seq<V>> generateOutput(StreamingContext ssc, Time targetBatchTime, String checkpointDir2, boolean stopSparkContext, ClassTag<V> evidence$4) {
        return DStreamCheckpointTester$class.generateOutput(this, ssc, targetBatchTime, checkpointDir2, stopSparkContext, evidence$4);
    }

    @Override
    public <U, V> Duration testCheckpointedOperation$default$5() {
        return DStreamCheckpointTester$class.testCheckpointedOperation$default$5(this);
    }

    @Override
    public <U, V> boolean testCheckpointedOperation$default$6() {
        return DStreamCheckpointTester$class.testCheckpointedOperation$default$6(this);
    }

    private String checkpointDir$lzycompute() {
        CheckpointSuite checkpointSuite = this;
        synchronized (checkpointSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase$class.checkpointDir(this);
                this.bitmap$0 = true;
            }
            return this.checkpointDir;
        }
    }

    @Override
    public String checkpointDir() {
        return this.bitmap$0 ? this.checkpointDir : this.checkpointDir$lzycompute();
    }

    @Override
    public SparkConf conf() {
        return this.conf;
    }

    @Override
    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    @Override
    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    @Override
    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    @Override
    public String framework() {
        return TestSuiteBase$class.framework(this);
    }

    @Override
    public String master() {
        return TestSuiteBase$class.master(this);
    }

    @Override
    public int numInputPartitions() {
        return TestSuiteBase$class.numInputPartitions(this);
    }

    @Override
    public int maxWaitTimeMillis() {
        return TestSuiteBase$class.maxWaitTimeMillis(this);
    }

    @Override
    public boolean useManualClock() {
        return TestSuiteBase$class.useManualClock(this);
    }

    @Override
    public boolean actuallyWait() {
        return TestSuiteBase$class.actuallyWait(this);
    }

    @Override
    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase$class.withStreamingContext(this, ssc, block);
    }

    @Override
    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase$class.withTestServer(this, testServer, block);
    }

    @Override
    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation2, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase$class.setupStreams(this, input, operation2, numPartitions, evidence$4, evidence$5);
    }

    @Override
    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation2, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase$class.setupStreams(this, input1, input2, operation2, evidence$6, evidence$7, evidence$8);
    }

    @Override
    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$9) {
        return TestSuiteBase$class.runStreams(this, ssc, numBatches, numExpectedOutput, preStop, evidence$9);
    }

    @Override
    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$10) {
        return TestSuiteBase$class.runStreamsWithPartitions(this, ssc, numBatches, numExpectedOutput, preStop, evidence$10);
    }

    @Override
    public <V> void verifyOutput(Seq<Seq<V>> output2, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase$class.verifyOutput(this, output2, expectedOutput, useSet, evidence$11);
    }

    @Override
    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation2, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase$class.testOperation(this, input, operation2, expectedOutput, useSet, evidence$12, evidence$13);
    }

    @Override
    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation2, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase$class.testOperation(this, input, operation2, expectedOutput, numBatches, useSet, evidence$14, evidence$15);
    }

    @Override
    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation2, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase$class.testOperation(this, input1, input2, operation2, expectedOutput, useSet, evidence$16, evidence$17, evidence$18);
    }

    @Override
    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation2, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase$class.testOperation(this, input1, input2, operation2, expectedOutput, numBatches, useSet, evidence$19, evidence$20, evidence$21);
    }

    @Override
    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase$class.testOperation$default$4(this);
    }

    @Override
    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase$class.setupStreams$default$3(this);
    }

    @Override
    public <V> Function0<BoxedUnit> runStreamsWithPartitions$default$4() {
        return TestSuiteBase$class.runStreamsWithPartitions$default$4(this);
    }

    @Override
    public <V> Function0<BoxedUnit> runStreams$default$4() {
        return TestSuiteBase$class.runStreams$default$4(this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public StreamingContext ssc() {
        return this.ssc;
    }

    public void ssc_$eq(StreamingContext x$1) {
        this.ssc = x$1;
    }

    @Override
    public Duration batchDuration() {
        return Milliseconds$.MODULE$.apply(500L);
    }

    @Override
    public void beforeFunction() {
        TestSuiteBase$class.beforeFunction(this);
        Utils$.MODULE$.deleteRecursively(new File(this.checkpointDir()));
    }

    @Override
    public void afterFunction() {
        try {
            if (this.ssc() != null) {
                StreamingContext qual$2 = this.ssc();
                boolean x$31 = qual$2.stop$default$1();
                qual$2.stop(x$31);
            }
            Utils$.MODULE$.deleteRecursively(new File(this.checkpointDir()));
            return;
        }
        finally {
            TestSuiteBase$class.afterFunction(this);
        }
    }

    public <V> Iterable<Seq<V>> advanceTimeWithRealDelay(StreamingContext ssc, long numBatches, ClassTag<V> evidence$6) {
        ManualClock clock = (ManualClock)ssc.scheduler().clock();
        this.logInfo((Function0)new Serializable(this, clock){
            public static final long serialVersionUID = 0L;
            private final ManualClock clock$3;

            public final String apply() {
                return new StringBuilder().append((Object)"Manual clock before advancing = ").append((Object)BoxesRunTime.boxToLong((long)this.clock$3.getTimeMillis())).toString();
            }
            {
                this.clock$3 = clock$3;
            }
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), (int)numBatches).foreach$mVc$sp((Function1)new Serializable(this, clock){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckpointSuite $outer;
            private final ManualClock clock$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.clock$3.advance(this.$outer.batchDuration().milliseconds());
                Thread.sleep(this.$outer.batchDuration().milliseconds());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.clock$3 = clock$3;
            }
        });
        this.logInfo((Function0)new Serializable(this, clock){
            public static final long serialVersionUID = 0L;
            private final ManualClock clock$3;

            public final String apply() {
                return new StringBuilder().append((Object)"Manual clock after advancing = ").append((Object)BoxesRunTime.boxToLong((long)this.clock$3.getTimeMillis())).toString();
            }
            {
                this.clock$3 = clock$3;
            }
        });
        Thread.sleep(this.batchDuration().milliseconds());
        TestOutputStreamWithPartitions<V> outputStream = this.getTestOutputStream(ssc.graph().getOutputStreams(), evidence$6);
        return (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(outputStream.output()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<V> apply(Seq<Seq<V>> x$26) {
                return (Seq)x$26.flatten((Function1)Predef$.MODULE$.$conforms());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public CheckpointSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        TestSuiteBase$class.$init$(this);
        DStreamCheckpointTester$class.$init$(this);
        BeforeAndAfterEach.class.$init$((BeforeAndAfterEach)this);
        ResetSystemProperties.class.$init$((ResetSystemProperties)this);
        this.ssc = null;
        this.test("non-existent checkpoint dir", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckpointSuite $outer;

            public final IllegalArgumentException apply() {
                return (IllegalArgumentException)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StreamingContext apply() {
                        return new StreamingContext("nosuchdirectory");
                    }
                }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
        this.test("basic rdd checkpoints + dstream graph checkpoint recovery", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckpointSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                long firstNumBatches;
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.batchDuration());
                Duration $org_scalatest_assert_macro_right = Milliseconds$.MODULE$.apply(500L);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"batchDuration for this test must be 1 second", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
                this.$outer.conf().set("spark.streaming.clock", "org.apache.spark.util.ManualClock");
                Duration stateStreamCheckpointInterval = Seconds$.MODULE$.apply(1L);
                LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
                long secondNumBatches = firstNumBatches = (long)stateStreamCheckpointInterval.$div(this.$outer.batchDuration()) * 2L;
                scala.collection.immutable.Seq input = ((scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<String> apply(int x$3) {
                        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toSeq();
                Serializable operation2 = new Serializable(this, stateStreamCheckpointInterval){
                    public static final long serialVersionUID = 0L;
                    private final Duration stateStreamCheckpointInterval$1;

                    public final DStream<Tuple2<String, Object>> apply(DStream<String> st) {
                        Serializable updateFunc = new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Some<Object> apply(Seq<Object> values, Option<Object> state) {
                                return new Some((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)values.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + BoxesRunTime.unboxToInt((Object)state.getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply() {
                                        return this.apply$mcI$sp();
                                    }

                                    public int apply$mcI$sp() {
                                        return 0;
                                    }
                                })))));
                            }
                        };
                        return DStream$.MODULE$.toPairDStreamFunctions(st.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<String, Object> apply(String x) {
                                return new Tuple2((Object)x, (Object)BoxesRunTime.boxToInteger((int)1));
                            }
                        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).updateStateByKey((Function2)updateFunc, ClassTag$.MODULE$.Int()).checkpoint(this.stateStreamCheckpointInterval$1).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<String, Object> apply(Tuple2<String, Object> t) {
                                return new Tuple2(t._1(), (Object)BoxesRunTime.boxToInteger((int)t._2$mcI$sp()));
                            }
                        }, ClassTag$.MODULE$.apply(Tuple2.class));
                    }
                    {
                        this.stateStreamCheckpointInterval$1 = stateStreamCheckpointInterval$1;
                    }
                };
                StreamingContext ssc = this.$outer.setupStreams(input, operation2, this.$outer.setupStreams$default$3(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class));
                ObjectRef stateStream = ObjectRef.create((Object)((DStream)((DStream)((DStream)Predef$.MODULE$.refArrayOps((Object[])ssc.graph().getOutputStreams()).head()).dependencies().head()).dependencies().head()));
                ssc.start();
                this.$outer.advanceTimeWithRealDelay(ssc, firstNumBatches, ClassTag$.MODULE$.Nothing());
                this.$outer.logInfo((Function0)new Serializable(this, stateStream){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef stateStream$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Checkpoint data of state stream = \n").append((Object)((DStream)this.stateStream$1.elem).checkpointData()).toString();
                    }
                    {
                        this.stateStream$1 = stateStream$1;
                    }
                });
                HashMap $org_scalatest_assert_macro_left2 = ((DStream)stateStream.elem).checkpointData().currentCheckpointFiles();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"No checkpointed RDDs in state stream before first failure", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
                ((DStream)stateStream.elem).checkpointData().currentCheckpointFiles().foreach((Function1)new Serializable(this, fs){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final LocalFileSystem fs$1;

                    public final Assertion apply(Tuple2<Time, String> x0$2) {
                        Tuple2<Time, String> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Time time = (Time)tuple2._1();
                            String file = (String)tuple2._2();
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.fs$1.exists(new Path(file)), "fs.exists(new org.apache.hadoop.fs.Path(file))", Prettifier$.MODULE$.default());
                            Assertion assertion = this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append((Object)"Checkpoint file '").append((Object)file).append((Object)"' for time ").append((Object)time).append((Object)" for state stream before first failure does not exist").toString(), Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
                            return assertion;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.fs$1 = fs$1;
                    }
                });
                scala.collection.mutable.Iterable checkpointFiles = (scala.collection.mutable.Iterable)((DStream)stateStream.elem).checkpointData().currentCheckpointFiles().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final File apply(Tuple2<Time, String> x) {
                        return new File((String)x._2());
                    }
                }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
                this.$outer.advanceTimeWithRealDelay(ssc, secondNumBatches, ClassTag$.MODULE$.Nothing());
                checkpointFiles.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final Assertion apply(File file) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(file.exists(), "file.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append((Object)"Checkpoint file '").append((Object)file).append((Object)"' was not deleted").toString(), Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                StreamingContext qual$3 = ssc;
                boolean x$32 = qual$3.stop$default$1();
                qual$3.stop(x$32);
                ssc = new StreamingContext(this.$outer.checkpointDir());
                stateStream.elem = (DStream)((DStream)((DStream)Predef$.MODULE$.refArrayOps((Object[])ssc.graph().getOutputStreams()).head()).dependencies().head()).dependencies().head();
                this.$outer.logInfo((Function0)new Serializable(this, stateStream){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef stateStream$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Restored data of state stream = \n[").append((Object)((DStream)this.stateStream$1.elem).generatedRDDs().mkString("\n")).append((Object)"]").toString();
                    }
                    {
                        this.stateStream$1 = stateStream$1;
                    }
                });
                HashMap $org_scalatest_assert_macro_left3 = ((DStream)stateStream.elem).generatedRDDs();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"No restored RDDs in state stream after recovery from first failure", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
                ssc.start();
                this.$outer.advanceTimeWithRealDelay(ssc, 1L, ClassTag$.MODULE$.Nothing());
                HashMap $org_scalatest_assert_macro_left4 = ((DStream)stateStream.elem).checkpointData().currentCheckpointFiles();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"No checkpointed RDDs in state stream before second failure", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
                ((DStream)stateStream.elem).checkpointData().currentCheckpointFiles().foreach((Function1)new Serializable(this, fs){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final LocalFileSystem fs$1;

                    public final Assertion apply(Tuple2<Time, String> x0$3) {
                        Tuple2<Time, String> tuple2 = x0$3;
                        if (tuple2 != null) {
                            Time time = (Time)tuple2._1();
                            String file = (String)tuple2._2();
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.fs$1.exists(new Path(file)), "fs.exists(new org.apache.hadoop.fs.Path(file))", Prettifier$.MODULE$.default());
                            Assertion assertion = this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append((Object)"Checkpoint file '").append((Object)file).append((Object)"' for time ").append((Object)time).append((Object)" for state stream before seconds failure does not exist").toString(), Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
                            return assertion;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.fs$1 = fs$1;
                    }
                });
                StreamingContext qual$4 = ssc;
                boolean x$33 = qual$4.stop$default$1();
                qual$4.stop(x$33);
                ssc = new StreamingContext(this.$outer.checkpointDir());
                stateStream.elem = (DStream)((DStream)((DStream)Predef$.MODULE$.refArrayOps((Object[])ssc.graph().getOutputStreams()).head()).dependencies().head()).dependencies().head();
                this.$outer.logInfo((Function0)new Serializable(this, stateStream){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef stateStream$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Restored data of state stream = \n[").append((Object)((DStream)this.stateStream$1.elem).generatedRDDs().mkString("\n")).append((Object)"]").toString();
                    }
                    {
                        this.stateStream$1 = stateStream$1;
                    }
                });
                HashMap $org_scalatest_assert_macro_left5 = ((DStream)stateStream.elem).generatedRDDs();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"No restored RDDs in state stream after recovery from second failure", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
                ssc.conf().set("spark.streaming.manualClock.jump", ((Object)BoxesRunTime.boxToLong((long)(this.$outer.batchDuration().milliseconds() * 7L))).toString());
                ssc.start();
                this.$outer.advanceTimeWithRealDelay(ssc, 4L, ClassTag$.MODULE$.Nothing());
                StreamingContext qual$5 = ssc;
                boolean x$34 = qual$5.stop$default$1();
                qual$5.stop(x$34);
                ssc = null;
            }

            public /* synthetic */ CheckpointSuite org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        this.test("recovery of conf through checkpoints", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckpointSuite $outer;

            public final Object apply() {
                String key = "spark.mykey";
                String value = "myvalue";
                System.setProperty(key, value);
                this.$outer.ssc_$eq(new StreamingContext(this.$outer.master(), this.$outer.framework(), this.$outer.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
                SparkConf originalConf = this.$outer.ssc().conf();
                Checkpoint cp = new Checkpoint(this.$outer.ssc(), new Time(1000L));
                SparkConf cpConf = cp.createSparkConf();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(cpConf.get("spark.master"));
                String $org_scalatest_assert_macro_right = originalConf.get("spark.master");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(cpConf.get("spark.app.name"));
                String $org_scalatest_assert_macro_right2 = originalConf.get("spark.app.name");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(cpConf.get(key));
                String $org_scalatest_assert_macro_right3 = value;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
                StreamingContext qual$6 = this.$outer.ssc();
                boolean x$35 = qual$6.stop$default$1();
                qual$6.stop(x$35);
                Checkpoint newCp = (Checkpoint)Utils$.MODULE$.deserialize(Utils$.MODULE$.serialize((Object)cp));
                SparkConf newCpConf = newCp.createSparkConf();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(newCpConf.get("spark.master"));
                String $org_scalatest_assert_macro_right4 = originalConf.get("spark.master");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(newCpConf.get("spark.app.name"));
                String $org_scalatest_assert_macro_right5 = originalConf.get("spark.app.name");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(newCpConf.get(key));
                String $org_scalatest_assert_macro_right6 = value;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
                SparkConf $org_scalatest_assert_macro_left7 = newCpConf;
                String $org_scalatest_assert_macro_right7 = "spark.driver.host";
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.contains($org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
                SparkConf $org_scalatest_assert_macro_left8 = newCpConf;
                String $org_scalatest_assert_macro_right8 = "spark.driver.port";
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "contains", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.contains($org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
                this.$outer.ssc_$eq(new StreamingContext(null, newCp, null));
                SparkConf restoredConf = this.$outer.ssc().conf();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(restoredConf.get(key));
                String $org_scalatest_assert_macro_right9 = value;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
                StreamingContext qual$7 = this.$outer.ssc();
                boolean x$36 = qual$7.stop$default$1();
                qual$7.stop(x$36);
                try {
                    String newMaster = "local[100]";
                    System.setProperty("spark.master", newMaster);
                    SparkConf newCpConf2 = newCp.createSparkConf();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(newCpConf2.get("spark.master"));
                    String $org_scalatest_assert_macro_right10 = newMaster;
                    Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(newCpConf2.get("spark.app.name"));
                    String $org_scalatest_assert_macro_right11 = originalConf.get("spark.app.name");
                    Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
                    this.$outer.ssc_$eq(new StreamingContext(null, newCp, null));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.$outer.convertToEqualizer(this.$outer.ssc().sparkContext().master());
                    String $org_scalatest_assert_macro_right12 = newMaster;
                    Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
                }
                finally {
                    System.clearProperty("spark.master");
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
        this.test("get correct spark.driver.[host|port] from checkpoint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckpointSuite $outer;

            public final Assertion apply() {
                SparkConf newCpConf1;
                SparkConf newCpConf;
                Map conf = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.driver.host"), (Object)"localhost"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.driver.port"), (Object)"9999")}));
                conf.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<String, String> kv) {
                        return System.setProperty((String)kv._1(), (String)kv._2());
                    }
                });
                this.$outer.ssc_$eq(new StreamingContext(this.$outer.master(), this.$outer.framework(), this.$outer.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
                SparkConf originalConf = this.$outer.ssc().conf();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(originalConf.get("spark.driver.host"));
                String $org_scalatest_assert_macro_right = "localhost";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(originalConf.get("spark.driver.port"));
                String $org_scalatest_assert_macro_right2 = "9999";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
                Checkpoint cp = new Checkpoint(this.$outer.ssc(), new Time(1000L));
                StreamingContext qual$8 = this.$outer.ssc();
                boolean x$37 = qual$8.stop$default$1();
                qual$8.stop(x$37);
                Checkpoint newCp = (Checkpoint)Utils$.MODULE$.deserialize(Utils$.MODULE$.serialize((Object)cp));
                SparkConf $org_scalatest_assert_macro_left3 = newCpConf = newCp.createSparkConf();
                String $org_scalatest_assert_macro_right3 = "spark.driver.host";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
                SparkConf $org_scalatest_assert_macro_left4 = newCpConf;
                String $org_scalatest_assert_macro_right4 = "spark.driver.port";
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(newCpConf.get("spark.driver.host"));
                String $org_scalatest_assert_macro_right5 = "localhost";
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(newCpConf.get("spark.driver.port"));
                String $org_scalatest_assert_macro_right6 = "9999";
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
                this.$outer.ssc_$eq(new StreamingContext(null, newCp, null));
                SparkConf restoredConf = this.$outer.ssc().conf();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(restoredConf.get("spark.driver.host"));
                String $org_scalatest_assert_macro_right7 = "localhost";
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(restoredConf.get("spark.driver.port"));
                String $org_scalatest_assert_macro_right8 = "9999";
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
                StreamingContext qual$9 = this.$outer.ssc();
                boolean x$38 = qual$9.stop$default$1();
                qual$9.stop(x$38);
                conf.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<String, String> kv) {
                        return System.clearProperty((String)kv._1());
                    }
                });
                SparkConf $org_scalatest_assert_macro_left9 = newCpConf1 = newCp.createSparkConf();
                String $org_scalatest_assert_macro_right9 = "spark.driver.host";
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "contains", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.contains($org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
                SparkConf $org_scalatest_assert_macro_left10 = newCpConf1;
                String $org_scalatest_assert_macro_right10 = "spark.driver.port";
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "contains", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.contains($org_scalatest_assert_macro_right10), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
                this.$outer.ssc_$eq(new StreamingContext(null, newCp, null));
                SparkConf restoredConf1 = this.$outer.ssc().conf();
                SparkConf defaultConf = new SparkConf();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(restoredConf1.get("spark.driver.host"));
                String $org_scalatest_assert_macro_right11 = (String)defaultConf.get(package$.MODULE$.DRIVER_HOST_ADDRESS());
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.$outer.convertToEqualizer(restoredConf1.get("spark.driver.port"));
                String $org_scalatest_assert_macro_right12 = "9999";
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "!==", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$bang$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
        this.test("recovery with map and reduceByKey operations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckpointSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testCheckpointedOperation((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "a", "b"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "a", "b"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)})), new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DStream<Tuple2<String, Object>> apply(DStream<String> s) {
                        return DStream$.MODULE$.toPairDStreamFunctions(s.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<String, Object> apply(String x) {
                                return new Tuple2((Object)x, (Object)BoxesRunTime.boxToInteger((int)1));
                            }
                        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(int x$4, int x$5) {
                                return this.apply$mcIII$sp(x$4, x$5);
                            }

                            public int apply$mcIII$sp(int x$4, int x$5) {
                                return x$4 + x$5;
                            }
                        });
                    }
                }, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)})), 3, this.$outer.testCheckpointedOperation$default$5(), this.$outer.testCheckpointedOperation$default$6(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
        this.test("recovery with invertible reduceByKeyAndWindow operation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckpointSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int n = 10;
                int w = 4;
                scala.collection.immutable.Seq input = ((scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), n).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<String> apply(int x$6) {
                        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toSeq();
                Seq output2 = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)3))}))}))).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), n - w + 1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Tuple2<String, Object>> apply(int x) {
                        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)4))}));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                Serializable operation2 = new Serializable(this, w){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final int w$1;

                    public final DStream<Tuple2<String, Object>> apply(DStream<String> st) {
                        PairDStreamFunctions qual$10 = DStream$.MODULE$.toPairDStreamFunctions(st.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<String, Object> apply(String x) {
                                return new Tuple2((Object)x, (Object)BoxesRunTime.boxToInteger((int)1));
                            }
                        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$);
                        Serializable x$39 = new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(int x$7, int x$8) {
                                return this.apply$mcIII$sp(x$7, x$8);
                            }

                            public int apply$mcIII$sp(int x$7, int x$8) {
                                return x$7 + x$8;
                            }
                        };
                        Serializable x$40 = new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(int x$9, int x$10) {
                                return this.apply$mcIII$sp(x$9, x$10);
                            }

                            public int apply$mcIII$sp(int x$9, int x$10) {
                                return x$9 - x$10;
                            }
                        };
                        Duration x$41 = this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().batchDuration().$times(this.w$1);
                        Duration x$42 = this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().batchDuration();
                        int x$43 = qual$10.reduceByKeyAndWindow$default$5();
                        Function1 x$44 = qual$10.reduceByKeyAndWindow$default$6();
                        return qual$10.reduceByKeyAndWindow((Function2)x$39, (Function2)x$40, x$41, x$42, x$43, x$44).checkpoint(this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().batchDuration().$times(2));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.w$1 = w$1;
                    }
                };
                this.$outer.testCheckpointedOperation(input, operation2, output2, 7, this.$outer.testCheckpointedOperation$default$5(), this.$outer.testCheckpointedOperation$default$6(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class));
            }

            public /* synthetic */ CheckpointSuite org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
        this.test("recovery with saveAsHadoopFiles operation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckpointSuite $outer;

            /*
             * WARNING - void declaration
             */
            public final Object apply() {
                BoxedUnit boxedUnit;
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                try {
                    this.$outer.testCheckpointedOperation((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "a", "b"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "a", "b"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)})), new Serializable(this, tempDir){
                        public static final long serialVersionUID = 0L;
                        private final File tempDir$1;

                        /*
                         * WARNING - void declaration
                         */
                        public final DStream<Tuple2<String, Object>> apply(DStream<String> s) {
                            void var2_2;
                            DStream output2 = DStream$.MODULE$.toPairDStreamFunctions(s.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Tuple2<String, Object> apply(String x) {
                                    return new Tuple2((Object)x, (Object)BoxesRunTime.boxToInteger((int)1));
                                }
                            }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply(int x$11, int x$12) {
                                    return this.apply$mcIII$sp(x$11, x$12);
                                }

                                public int apply$mcIII$sp(int x$11, int x$12) {
                                    return x$11 + x$12;
                                }
                            });
                            PairDStreamFunctions qual$11 = DStream$.MODULE$.toPairDStreamFunctions(output2, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$);
                            String x$45 = this.tempDir$1.toURI().toString();
                            String x$46 = "result";
                            Class<Text> x$47 = Text.class;
                            Class<IntWritable> x$48 = IntWritable.class;
                            Class<TextOutputFormat> x$49 = TextOutputFormat.class;
                            JobConf x$50 = qual$11.saveAsHadoopFiles$default$6();
                            qual$11.saveAsHadoopFiles(x$45, x$46, x$47, x$48, x$49, x$50);
                            return var2_2;
                        }
                        {
                            this.tempDir$1 = tempDir$1;
                        }
                    }, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)})), 3, this.$outer.testCheckpointedOperation$default$5(), this.$outer.testCheckpointedOperation$default$6(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class));
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    void var1_1;
                    Utils$.MODULE$.deleteRecursively((File)var1_1);
                    throw throwable;
                }
                Utils$.MODULE$.deleteRecursively(tempDir);
                return boxedUnit;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 450));
        this.test("recovery with saveAsNewAPIHadoopFiles operation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckpointSuite $outer;

            /*
             * WARNING - void declaration
             */
            public final Object apply() {
                BoxedUnit boxedUnit;
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                try {
                    this.$outer.testCheckpointedOperation((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "a", "b"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "a", "b"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)})), new Serializable(this, tempDir){
                        public static final long serialVersionUID = 0L;
                        private final File tempDir$2;

                        /*
                         * WARNING - void declaration
                         */
                        public final DStream<Tuple2<String, Object>> apply(DStream<String> s) {
                            void var2_2;
                            DStream output2 = DStream$.MODULE$.toPairDStreamFunctions(s.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Tuple2<String, Object> apply(String x) {
                                    return new Tuple2((Object)x, (Object)BoxesRunTime.boxToInteger((int)1));
                                }
                            }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply(int x$13, int x$14) {
                                    return this.apply$mcIII$sp(x$13, x$14);
                                }

                                public int apply$mcIII$sp(int x$13, int x$14) {
                                    return x$13 + x$14;
                                }
                            });
                            PairDStreamFunctions qual$12 = DStream$.MODULE$.toPairDStreamFunctions(output2, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$);
                            String x$51 = this.tempDir$2.toURI().toString();
                            String x$52 = "result";
                            Class<Text> x$53 = Text.class;
                            Class<IntWritable> x$54 = IntWritable.class;
                            Class<org.apache.hadoop.mapreduce.lib.output.TextOutputFormat> x$55 = org.apache.hadoop.mapreduce.lib.output.TextOutputFormat.class;
                            Configuration x$56 = qual$12.saveAsNewAPIHadoopFiles$default$6();
                            qual$12.saveAsNewAPIHadoopFiles(x$51, x$52, x$53, x$54, x$55, x$56);
                            return var2_2;
                        }
                        {
                            this.tempDir$2 = tempDir$2;
                        }
                    }, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)})), 3, this.$outer.testCheckpointedOperation$default$5(), this.$outer.testCheckpointedOperation$default$6(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class));
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    void var1_1;
                    Utils$.MODULE$.deleteRecursively((File)var1_1);
                    throw throwable;
                }
                Utils$.MODULE$.deleteRecursively(tempDir);
                return boxedUnit;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 479));
        this.test("recovery with saveAsHadoopFile inside transform operation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckpointSuite $outer;

            /*
             * WARNING - void declaration
             */
            public final Object apply() {
                BoxedUnit boxedUnit;
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                try {
                    this.$outer.testCheckpointedOperation((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "a", "b"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "a", "b"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)})), new Serializable(this, tempDir){
                        public static final long serialVersionUID = 0L;
                        public final File tempDir$3;

                        public final DStream<Tuple2<String, Object>> apply(DStream<String> s) {
                            return s.transform((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$34$$anonfun$apply$15 $outer;

                                /*
                                 * WARNING - void declaration
                                 */
                                public final RDD<Tuple2<String, Object>> apply(RDD<String> rdd, Time time) {
                                    void var3_3;
                                    RDD output2 = RDD$.MODULE$.rddToPairRDDFunctions(rdd.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final Tuple2<String, Object> apply(String x) {
                                            return new Tuple2((Object)x, (Object)BoxesRunTime.boxToInteger((int)1));
                                        }
                                    }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply(int x$15, int x$16) {
                                            return this.apply$mcIII$sp(x$15, x$16);
                                        }

                                        public int apply$mcIII$sp(int x$15, int x$16) {
                                            return x$15 + x$16;
                                        }
                                    });
                                    PairRDDFunctions qual$13 = RDD$.MODULE$.rddToPairRDDFunctions(output2, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$);
                                    String x$57 = new File(this.$outer.tempDir$3, new StringBuilder().append((Object)"result-").append((Object)BoxesRunTime.boxToLong((long)time.milliseconds())).toString()).getAbsolutePath();
                                    Class<Text> x$58 = Text.class;
                                    Class<IntWritable> x$59 = IntWritable.class;
                                    Class<TextOutputFormat> x$60 = TextOutputFormat.class;
                                    JobConf x$61 = qual$13.saveAsHadoopFile$default$5();
                                    Option x$62 = qual$13.saveAsHadoopFile$default$6();
                                    qual$13.saveAsHadoopFile(x$57, x$58, x$59, x$60, x$61, x$62);
                                    return var3_3;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, ClassTag$.MODULE$.apply(Tuple2.class));
                        }
                        {
                            this.tempDir$3 = tempDir$3;
                        }
                    }, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)})), 3, this.$outer.testCheckpointedOperation$default$5(), this.$outer.testCheckpointedOperation$default$6(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class));
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    void var1_1;
                    Utils$.MODULE$.deleteRecursively((File)var1_1);
                    throw throwable;
                }
                Utils$.MODULE$.deleteRecursively(tempDir);
                return boxedUnit;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 508));
        this.test("recovery with updateStateByKey operation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckpointSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                scala.collection.immutable.Seq input = ((scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<String> apply(int x$17) {
                        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toSeq();
                scala.collection.immutable.Seq output2 = ((scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Tuple2<String, Object>> apply(int x) {
                        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)x))}));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toSeq();
                Serializable operation2 = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final DStream<Tuple2<String, Object>> apply(DStream<String> st) {
                        Serializable updateFunc = new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Some<Object> apply(Seq<Object> values, Option<Object> state) {
                                return new Some((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)values.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + BoxesRunTime.unboxToInt((Object)state.getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply() {
                                        return this.apply$mcI$sp();
                                    }

                                    public int apply$mcI$sp() {
                                        return 0;
                                    }
                                })))));
                            }
                        };
                        return DStream$.MODULE$.toPairDStreamFunctions(st.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<String, Object> apply(String x) {
                                return new Tuple2((Object)x, (Object)BoxesRunTime.boxToInteger((int)1));
                            }
                        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).updateStateByKey((Function2)updateFunc, ClassTag$.MODULE$.Int()).checkpoint(this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().batchDuration().$times(2)).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<String, Object> apply(Tuple2<String, Object> t) {
                                return new Tuple2(t._1(), (Object)BoxesRunTime.boxToInteger((int)t._2$mcI$sp()));
                            }
                        }, ClassTag$.MODULE$.apply(Tuple2.class));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
                this.$outer.testCheckpointedOperation(input, operation2, output2, 7, this.$outer.testCheckpointedOperation$default$5(), this.$outer.testCheckpointedOperation$default$6(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class));
            }

            public /* synthetic */ CheckpointSuite org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 556));
        this.test("recovery maintains rate controller", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckpointSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.ssc_$eq(new StreamingContext(this.$outer.conf(), this.$outer.batchDuration()));
                this.$outer.ssc().checkpoint(this.$outer.checkpointDir());
                RateTestInputDStream dstream = new RateTestInputDStream(this){
                    private final Some<ReceiverInputDStream.ReceiverRateController> rateController;

                    public Some<ReceiverInputDStream.ReceiverRateController> rateController() {
                        return this.rateController;
                    }
                    {
                        super($outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().ssc());
                        this.rateController = new Some((Object)new ReceiverInputDStream.ReceiverRateController((ReceiverInputDStream)this, this.id(), (RateEstimator)new ConstantEstimator(200L)));
                    }
                };
                TestOutputStreamWithPartitions<T> output2 = new TestOutputStreamWithPartitions<T>(dstream.checkpoint(this.$outer.batchDuration().$times(2)), TestOutputStreamWithPartitions$.MODULE$.$lessinit$greater$default$2(), ClassTag$.MODULE$.Int());
                output2.register();
                this.$outer.runStreams(this.$outer.ssc(), 5, 5, this.$outer.runStreams$default$4(), ClassTag$.MODULE$.Nothing());
                this.$outer.ssc_$eq(new StreamingContext(this.$outer.checkpointDir()));
                this.$outer.ssc().start();
                Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds()), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;

                    public final Assertion apply() {
                        Option<RateTestReceiver> $org_scalatest_assert_macro_left = RateTestReceiver$.MODULE$.getActive();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
                        return this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 588));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Eventually$.MODULE$.patienceConfig(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 587));
                this.$outer.advanceTimeWithRealDelay(this.$outer.ssc(), 2L, ClassTag$.MODULE$.Nothing());
                Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds()), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;

                    public final Assertion apply() {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)((RateTestReceiver)((Object)RateTestReceiver$.MODULE$.getActive().get())).getDefaultBlockGeneratorRateLimit()));
                        int $org_scalatest_assert_macro_right = 200;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Eventually$.MODULE$.patienceConfig(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 593));
                StreamingContext qual$14 = this.$outer.ssc();
                boolean x$63 = qual$14.stop$default$1();
                qual$14.stop(x$63);
            }

            public /* synthetic */ CheckpointSuite org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 571));
        this.test("recovery with file input stream", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckpointSuite $outer;

            public final Object apply() {
                Throwable throwable5;
                block7: {
                    R r;
                    Duration batchDuration = Seconds$.MODULE$.apply(2L);
                    File testDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                    ConcurrentLinkedQueue<E> outputBuffer = new ConcurrentLinkedQueue<E>();
                    try {
                        ObjectRef clock = ObjectRef.create(null);
                        this.$outer.withStreamingContext(new StreamingContext(this.$outer.conf(), batchDuration), new Serializable(this, batchDuration, testDir, outputBuffer, clock){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$40 $outer;
                            public final Duration batchDuration$1;
                            public final File testDir$1;
                            private final ConcurrentLinkedQueue outputBuffer$1;
                            public final ObjectRef clock$2;

                            public final Assertion apply(StreamingContext ssc) {
                                ssc.checkpoint(this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().checkpointDir());
                                this.clock$2.elem = (ManualClock)ssc.scheduler().clock();
                                BatchCounter batchCounter = new BatchCounter(ssc);
                                DStream fileStream = ssc.textFileStream(this.testDir$1.toString());
                                CheckpointSuite$.MODULE$.batchThreeShouldBlockALongTime_$eq(true);
                                DStream mappedStream = fileStream.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final int apply(String s) {
                                        void var2_2;
                                        int i = new StringOps(Predef$.MODULE$.augmentString(s)).toInt();
                                        if (i == 3 && CheckpointSuite$.MODULE$.batchThreeShouldBlockALongTime()) {
                                            Thread.sleep(6000L);
                                        }
                                        return (int)var2_2;
                                    }
                                }, ClassTag$.MODULE$.Int());
                                DStream reducedStream = mappedStream.reduceByWindow((Function2)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply(int x$19, int x$20) {
                                        return this.apply$mcIII$sp(x$19, x$20);
                                    }

                                    public int apply$mcIII$sp(int x$19, int x$20) {
                                        return x$19 + x$20;
                                    }
                                }, this.batchDuration$1.$times(30), this.batchDuration$1);
                                TestOutputStream<T> outputStream = new TestOutputStream<T>(reducedStream, this.outputBuffer$1, ClassTag$.MODULE$.Int());
                                outputStream.register();
                                ssc.start();
                                ((ManualClock)this.clock$2.elem).advance(this.batchDuration$1.milliseconds() / 2L);
                                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).foreach((Function1)new Serializable(this, batchCounter){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$40$$anonfun$apply$19 $outer;
                                    public final BatchCounter batchCounter$2;

                                    public final Object apply(int i) {
                                        this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$CheckpointSuite$$anonfun$$writeFile$1(i, (Clock)((ManualClock)this.$outer.clock$2.elem), this.$outer.testDir$1);
                                        ((ManualClock)this.$outer.clock$2.elem).advance(this.$outer.batchDuration$1.milliseconds());
                                        return i != 3 ? Eventually$.MODULE$.eventually(this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().eventuallyTimeout(), (Function0)new Serializable(this, i){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$40$$anonfun$apply$19$$anonfun$apply$20 $outer;
                                            private final int i$1;

                                            public final Assertion apply() {
                                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)this.$outer.batchCounter$2.getNumCompletedBatches()));
                                                int $org_scalatest_assert_macro_right = this.i$1;
                                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                                return this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 674));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.i$1 = i$1;
                                            }
                                        }, Eventually$.MODULE$.patienceConfig(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 673)) : BoxedUnit.UNIT;
                                    }

                                    public /* synthetic */ $anonfun$40$$anonfun$apply$19 org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.batchCounter$2 = batchCounter$2;
                                    }
                                });
                                Eventually$.MODULE$.eventually(this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().eventuallyTimeout(), (Function0)new Serializable(this, batchCounter, ssc){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$40$$anonfun$apply$19 $outer;
                                    private final BatchCounter batchCounter$2;
                                    private final StreamingContext ssc$1;

                                    public final Assertion apply() {
                                        Bool bool;
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().convertToEqualizer(this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$CheckpointSuite$$anonfun$$recordedFiles$1(this.ssc$1));
                                        Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
                                        Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                        if ($org_scalatest_assert_macro_left2.value()) {
                                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)this.batchCounter$2.getNumStartedBatches()));
                                            int $org_scalatest_assert_macro_right2 = 3;
                                            bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                        } else {
                                            bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                                        }
                                        Bool $org_scalatest_assert_macro_right3 = bool;
                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                                        return this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 680));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.batchCounter$2 = batchCounter$2;
                                        this.ssc$1 = ssc$1;
                                    }
                                }, Eventually$.MODULE$.patienceConfig(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 678));
                                ((ManualClock)this.clock$2.elem).advance(this.batchDuration$1.milliseconds());
                                Eventually$.MODULE$.eventually(this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().eventuallyTimeout(), (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$40$$anonfun$apply$19 $outer;

                                    public final Assertion apply() {
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)Checkpoint$.MODULE$.getCheckpointFiles(this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().checkpointDir(), Checkpoint$.MODULE$.getCheckpointFiles$default$2()).size()));
                                        int $org_scalatest_assert_macro_right = 6;
                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                        return this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 685));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                }, Eventually$.MODULE$.patienceConfig(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 684));
                                ssc.stop(ssc.stop$default$1());
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)batchCounter.getNumCompletedBatches()));
                                int $org_scalatest_assert_macro_right = 2;
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 689));
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().convertToEqualizer(((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(outputStream.output()).asScala()).toSeq().flatten((Function1)Predef$.MODULE$.$conforms()));
                                Seq $org_scalatest_assert_macro_right2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3}));
                                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                return this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 690));
                            }

                            public /* synthetic */ $anonfun$40 org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.batchDuration$1 = batchDuration$1;
                                this.testDir$1 = testDir$1;
                                this.outputBuffer$1 = outputBuffer$1;
                                this.clock$2 = clock$2;
                            }
                        });
                        CheckpointSuite$.MODULE$.batchThreeShouldBlockALongTime_$eq(false);
                        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6}))).foreach((Function1)new Serializable(this, batchDuration, testDir, clock){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$40 $outer;
                            private final Duration batchDuration$1;
                            private final File testDir$1;
                            private final ObjectRef clock$2;

                            public final void apply(int i) {
                                this.apply$mcVI$sp(i);
                            }

                            public void apply$mcVI$sp(int i) {
                                this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$writeFile$1(i, (Clock)((ManualClock)this.clock$2.elem), this.testDir$1);
                                ((ManualClock)this.clock$2.elem).advance(this.batchDuration$1.milliseconds());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.batchDuration$1 = batchDuration$1;
                                this.testDir$1 = testDir$1;
                                this.clock$2 = clock$2;
                            }
                        });
                        this.$outer.logInfo((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "*********** RESTARTING ************";
                            }
                        });
                        r = this.$outer.withStreamingContext(new StreamingContext(this.$outer.checkpointDir()), new Serializable(this, batchDuration, testDir, outputBuffer, clock){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$40 $outer;
                            public final Duration batchDuration$1;
                            public final File testDir$1;
                            private final ConcurrentLinkedQueue outputBuffer$1;
                            public final ObjectRef clock$2;

                            public final Assertion apply(StreamingContext ssc) {
                                ssc.conf().set("spark.streaming.manualClock.jump", ((Object)BoxesRunTime.boxToLong((long)(this.batchDuration$1.milliseconds() / 2L + this.batchDuration$1.milliseconds() * 3L))).toString());
                                long oldClockTime = ((ManualClock)this.clock$2.elem).getTimeMillis();
                                this.clock$2.elem = (ManualClock)ssc.scheduler().clock();
                                BatchCounter batchCounter = new BatchCounter(ssc);
                                TestOutputStream outputStream = (TestOutputStream)((Object)Predef$.MODULE$.refArrayOps((Object[])ssc.graph().getOutputStreams()).head());
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().convertToEqualizer(this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$recordedFiles$1(ssc));
                                Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 718));
                                ssc.start();
                                Eventually$.MODULE$.eventually(this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().eventuallyTimeout(), (Function0)new Serializable(this, oldClockTime){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$40$$anonfun$apply$25 $outer;
                                    private final long oldClockTime$1;

                                    public final Assertion apply() {
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)((ManualClock)this.$outer.clock$2.elem).getTimeMillis()));
                                        long $org_scalatest_assert_macro_right = this.oldClockTime$1;
                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                        return this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 724));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.oldClockTime$1 = oldClockTime$1;
                                    }
                                }, Eventually$.MODULE$.patienceConfig(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 723));
                                int numBatchesAfterRestart = 5;
                                Eventually$.MODULE$.eventually(this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().eventuallyTimeout(), (Function0)new Serializable(this, batchCounter, numBatchesAfterRestart){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$40$$anonfun$apply$25 $outer;
                                    private final BatchCounter batchCounter$3;
                                    private final int numBatchesAfterRestart$1;

                                    public final Assertion apply() {
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)this.batchCounter$3.getNumCompletedBatches()));
                                        int $org_scalatest_assert_macro_right = this.numBatchesAfterRestart$1;
                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                        return this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 729));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.batchCounter$3 = batchCounter$3;
                                        this.numBatchesAfterRestart$1 = numBatchesAfterRestart$1;
                                    }
                                }, Eventually$.MODULE$.patienceConfig(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 728));
                                ((TraversableLike)((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9}))).zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                                        Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                                        boolean bl = tuple2 != null;
                                        return bl;
                                    }
                                }).foreach((Function1)new Serializable(this, batchCounter, numBatchesAfterRestart){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$40$$anonfun$apply$25 $outer;
                                    public final BatchCounter batchCounter$3;
                                    public final int numBatchesAfterRestart$1;

                                    public final Assertion apply(Tuple2<Object, Object> x$21) {
                                        Tuple2<Object, Object> tuple2 = x$21;
                                        if (tuple2 != null) {
                                            int i = tuple2._1$mcI$sp();
                                            int index = tuple2._2$mcI$sp();
                                            this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$CheckpointSuite$$anonfun$$writeFile$1(i, (Clock)((ManualClock)this.$outer.clock$2.elem), this.$outer.testDir$1);
                                            ((ManualClock)this.$outer.clock$2.elem).advance(this.$outer.batchDuration$1.milliseconds());
                                            Assertion assertion = (Assertion)Eventually$.MODULE$.eventually(this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().eventuallyTimeout(), (Function0)new Serializable(this, index){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ $anonfun$40$$anonfun$apply$25$$anonfun$apply$29 $outer;
                                                private final int index$1;

                                                public final Assertion apply() {
                                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)this.$outer.batchCounter$3.getNumCompletedBatches()));
                                                    int $org_scalatest_assert_macro_right = this.index$1 + this.$outer.numBatchesAfterRestart$1 + 1;
                                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                                    return this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 737));
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                    this.index$1 = index$1;
                                                }
                                            }, Eventually$.MODULE$.patienceConfig(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 736));
                                            return assertion;
                                        }
                                        throw new MatchError(tuple2);
                                    }

                                    public /* synthetic */ $anonfun$40$$anonfun$apply$25 org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.batchCounter$3 = batchCounter$3;
                                        this.numBatchesAfterRestart$1 = numBatchesAfterRestart$1;
                                    }
                                });
                                this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this, outputStream){
                                    public static final long serialVersionUID = 0L;
                                    private final TestOutputStream outputStream$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"Output after restart = ").append((Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.outputStream$1.output()).asScala()).mkString("[", ", ", "]")).toString();
                                    }
                                    {
                                        this.outputStream$1 = outputStream$1;
                                    }
                                });
                                int $org_scalatest_assert_macro_left2 = outputStream.output().size();
                                int $org_scalatest_assert_macro_right2 = 0;
                                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                                this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"No files processed after restart", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 741));
                                ssc.stop(ssc.stop$default$1());
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().convertToEqualizer(this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$recordedFiles$1(ssc));
                                Range.Inclusive $org_scalatest_assert_macro_right3 = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 9);
                                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 746));
                                this.outputBuffer$1.addAll(outputStream.output());
                                Seq expectedOutput = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 6, 10, 15, 21, 28, 36, 45}));
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().convertToEqualizer(((TraversableOnce)((GenericTraversableTemplate)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)this.outputBuffer$1).asScala()).flatten((Function1)Predef$.MODULE$.$conforms())).toSet());
                                Set $org_scalatest_assert_macro_right4 = expectedOutput.toSet();
                                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                return this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 753));
                            }

                            public /* synthetic */ $anonfun$40 org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.batchDuration$1 = batchDuration$1;
                                this.testDir$1 = testDir$1;
                                this.outputBuffer$1 = outputBuffer$1;
                                this.clock$2 = clock$2;
                            }
                        });
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable32;
                        block6: {
                            try {
                                Utils$.MODULE$.deleteRecursively(testDir);
                            }
                            catch (Throwable throwable32) {
                                Throwable throwable4 = throwable32;
                                if (!(throwable4 instanceof IOException)) break block6;
                                IOException iOException = (IOException)throwable4;
                                if (!Utils$.MODULE$.isWindows()) break block6;
                                this.$outer.logWarning((Function0)new Serializable(this, iOException){
                                    public static final long serialVersionUID = 0L;
                                    private final IOException x5$1;

                                    public final String apply() {
                                        return this.x5$1.getMessage();
                                    }
                                    {
                                        this.x5$1 = x5$1;
                                    }
                                });
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            throw throwable2;
                        }
                        throw throwable32;
                    }
                    try {
                        Utils$.MODULE$.deleteRecursively(testDir);
                    }
                    catch (Throwable throwable5) {
                        Throwable throwable6 = throwable5;
                        if (!(throwable6 instanceof IOException)) break block7;
                        IOException iOException = (IOException)throwable6;
                        if (!Utils$.MODULE$.isWindows()) break block7;
                        this.$outer.logWarning((Function0)new /* invalid duplicate definition of identical inner class */);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return r;
                }
                throw throwable5;
            }

            public /* synthetic */ CheckpointSuite org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer() {
                return this.$outer;
            }

            public final void org$apache$spark$streaming$CheckpointSuite$$anonfun$$writeFile$1(int i, Clock clock, File testDir$1) {
                File file = new File(testDir$1, ((Object)BoxesRunTime.boxToInteger((int)i)).toString());
                Files.write((CharSequence)new StringBuilder().append(i).append((Object)"\n").toString(), (File)file, (Charset)StandardCharsets.UTF_8);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(file.setLastModified(clock.getTimeMillis()), "file.setLastModified(clock.getTimeMillis())", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 616));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)file.lastModified()));
                long $org_scalatest_assert_macro_right = clock.getTimeMillis();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 619));
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Seq org$apache$spark$streaming$CheckpointSuite$$anonfun$$recordedFiles$1(StreamingContext ssc) {
                GenTraversable genTraversable;
                FileInputDStream fileInputDStream = (FileInputDStream)Predef$.MODULE$.refArrayOps((Object[])ssc.graph().getInputStreams()).head();
                HashMap hashMap = fileInputDStream.batchTimeToSelectedFiles();
                synchronized (hashMap) {
                    genTraversable = fileInputDStream.batchTimeToSelectedFiles().values().flatten((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ArrayOps<String> apply(String[] xs) {
                            return Predef$.MODULE$.refArrayOps((Object[])xs);
                        }
                    });
                }
                Iterable filenames = (Iterable)genTraversable;
                return (Seq)((TraversableOnce)filenames.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(String x$18) {
                        return new StringOps(Predef$.MODULE$.augmentString((String)Predef$.MODULE$.refArrayOps((Object[])x$18.split("/")).last())).toInt();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.Int$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 603));
        this.test("DStreamCheckpointData.restore invoking times", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckpointSuite $outer;

            public final Assertion apply() {
                this.$outer.withStreamingContext(new StreamingContext(this.$outer.conf(), this.$outer.batchDuration()), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$43 $outer;

                    public final Assertion apply(StreamingContext ssc) {
                        ssc.checkpoint(this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().checkpointDir());
                        CheckpointInputDStream inputDStream = new CheckpointInputDStream(ssc);
                        CheckpointInputDStream.FileInputDStreamCheckpointData checkpointData = inputDStream.checkpointData();
                        DStream mappedDStream = inputDStream.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(int x$22) {
                                return this.apply$mcII$sp(x$22);
                            }

                            public int apply$mcII$sp(int x$22) {
                                return x$22 + 100;
                            }
                        }, ClassTag$.MODULE$.Int());
                        TestOutputStreamWithPartitions<T> outputStream = new TestOutputStreamWithPartitions<T>(mappedDStream, TestOutputStreamWithPartitions$.MODULE$.$lessinit$greater$default$2(), ClassTag$.MODULE$.Int());
                        outputStream.register();
                        mappedDStream.foreachRDD((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(RDD<Object> rdd) {
                                rdd.count();
                            }
                        });
                        mappedDStream.foreachRDD((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(RDD<Object> rdd) {
                                rdd.count();
                            }
                        });
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)checkpointData.restoredTimes()));
                        int $org_scalatest_assert_macro_right = 0;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
                        long batchDurationMillis = ssc.progressListener().batchDuration();
                        this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().generateOutput(ssc, new Time(batchDurationMillis * 3L), this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().checkpointDir(), true, ClassTag$.MODULE$.Nothing());
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)checkpointData.restoredTimes()));
                        int $org_scalatest_assert_macro_right2 = 0;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 782));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.logInfo((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "*********** RESTARTING ************";
                    }
                });
                return (Assertion)this.$outer.withStreamingContext(new StreamingContext(this.$outer.checkpointDir()), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$43 $outer;

                    public final Assertion apply(StreamingContext ssc) {
                        CheckpointInputDStream.FileInputDStreamCheckpointData checkpointData = ((CheckpointInputDStream)((Object)Predef$.MODULE$.refArrayOps((Object[])ssc.graph().getInputStreams()).head())).checkpointData();
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)checkpointData.restoredTimes()));
                        int $org_scalatest_assert_macro_right = 1;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 788));
                        ssc.start();
                        ssc.stop(ssc.stop$default$1());
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)checkpointData.restoredTimes()));
                        int $org_scalatest_assert_macro_right2 = 1;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 791));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ CheckpointSuite org$apache$spark$streaming$CheckpointSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 768));
        this.test("recovery from checkpoint contains array object", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckpointSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                URL jar = TestUtils$.MODULE$.createJarWithClasses((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testClz"})), "testStringValue", TestUtils$.MODULE$.createJarWithClasses$default$3(), TestUtils$.MODULE$.createJarWithClasses$default$4());
                ClassLoader appClassLoader = this.$outer.getClass().getClassLoader();
                this.$outer.intercept((Function0)new Serializable(this, appClassLoader){
                    public static final long serialVersionUID = 0L;
                    private final ClassLoader appClassLoader$1;

                    public final Class<Object> apply() {
                        return this.appClassLoader$1.loadClass("testClz");
                    }
                    {
                        this.appClassLoader$1 = appClassLoader$1;
                    }
                }, ClassTag$.MODULE$.apply(ClassNotFoundException.class), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 806));
                MutableURLClassLoader loader = new MutableURLClassLoader((URL[])((Object[])new URL[]{jar}), appClassLoader);
                String $org_scalatest_assert_macro_left = loader.loadClass("testClz").newInstance().toString();
                String $org_scalatest_assert_macro_right = "testStringValue";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 811));
                Class<?> arrayObj = Class.forName("[LtestClz;", false, (ClassLoader)loader);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                new ObjectOutputStream(bos).writeObject(arrayObj);
                ObjectInputStreamWithLoader ois = new ObjectInputStreamWithLoader((InputStream)new ByteArrayInputStream(bos.toByteArray()), (ClassLoader)loader);
                String $org_scalatest_assert_macro_left2 = ((Class)ois.readObject()).getName();
                String $org_scalatest_assert_macro_right2 = "[LtestClz;";
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 823));
                ois.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 797));
        this.test("SPARK-11267: the race condition of two checkpoints in a batch", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckpointSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JobGenerator jobGenerator = (JobGenerator)Mockito.mock(JobGenerator.class);
                String checkpointDir2 = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toString();
                CheckpointWriter checkpointWriter = new CheckpointWriter(jobGenerator, this.$outer.conf(), checkpointDir2, new Configuration());
                byte[] bytes1 = (byte[])Array$.MODULE$.fill(10, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final byte apply() {
                        return this.apply$mcB$sp();
                    }

                    public byte apply$mcB$sp() {
                        return 1;
                    }
                }, ClassTag$.MODULE$.Byte());
                new CheckpointWriter.CheckpointWriteHandler(checkpointWriter, new Time(2000L), bytes1, false).run();
                byte[] bytes2 = (byte[])Array$.MODULE$.fill(10, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final byte apply() {
                        return this.apply$mcB$sp();
                    }

                    public byte apply$mcB$sp() {
                        return 2;
                    }
                }, ClassTag$.MODULE$.Byte());
                new CheckpointWriter.CheckpointWriteHandler(checkpointWriter, new Time(1000L), bytes2, true).run();
                Seq checkpointFiles = (Seq)((TraversableLike)Checkpoint$.MODULE$.getCheckpointFiles(checkpointDir2, Checkpoint$.MODULE$.getCheckpointFiles$default$2()).reverse()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final File apply(Path path) {
                        return new File(path.toUri());
                    }
                }, Seq$.MODULE$.canBuildFrom());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)checkpointFiles.size()));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 841));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(Files.toByteArray((File)((File)checkpointFiles.apply(0))));
                byte[] $org_scalatest_assert_macro_right2 = bytes2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 844));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(Files.toByteArray((File)((File)checkpointFiles.apply(1))));
                byte[] $org_scalatest_assert_macro_right3 = bytes1;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
                checkpointWriter.stop();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 827));
        this.test("SPARK-6847: stack overflow when updateStateByKey is followed by a checkpointed dstream", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckpointSuite $outer;

            public final Assertion apply() {
                this.$outer.ssc_$eq(new StreamingContext(this.$outer.master(), this.$outer.framework(), this.$outer.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
                BatchCounter batchCounter = new BatchCounter(this.$outer.ssc());
                this.$outer.ssc().checkpoint(this.$outer.checkpointDir());
                CheckpointInputDStream inputDStream = new CheckpointInputDStream(this.$outer.ssc());
                Serializable updateFunc = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Some<Object> apply(Seq<Object> values, Option<Object> state) {
                        return new Some((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)values.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + BoxesRunTime.unboxToInt((Object)state.getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return 0;
                            }
                        })))));
                    }
                };
                VolatileBooleanRef shouldCheckpointAllMarkedRDDs = VolatileBooleanRef.create((boolean)false);
                VolatileBooleanRef rddsCheckpointed = VolatileBooleanRef.create((boolean)false);
                DStream$.MODULE$.toPairDStreamFunctions(DStream$.MODULE$.toPairDStreamFunctions(inputDStream.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(int i) {
                        return new Tuple2.mcII.sp(i, i);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).updateStateByKey((Function2)updateFunc, ClassTag$.MODULE$.Int()).checkpoint(this.$outer.batchDuration()), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).updateStateByKey((Function2)updateFunc, ClassTag$.MODULE$.Int()).checkpoint(this.$outer.batchDuration()).foreachRDD((Function1)new Serializable(this, shouldCheckpointAllMarkedRDDs, rddsCheckpointed){
                    public static final long serialVersionUID = 0L;
                    private final VolatileBooleanRef shouldCheckpointAllMarkedRDDs$1;
                    private final VolatileBooleanRef rddsCheckpointed$1;

                    public final void apply(RDD<Tuple2<Object, Object>> rdd) {
                        this.shouldCheckpointAllMarkedRDDs$1.elem = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)rdd.sparkContext().getLocalProperty(RDD$.MODULE$.CHECKPOINT_ALL_MARKED_ANCESTORS())).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String x$24) {
                                return new StringOps(Predef$.MODULE$.augmentString(x$24)).toBoolean();
                            }
                        }).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply() {
                                return this.apply$mcZ$sp();
                            }

                            public boolean apply$mcZ$sp() {
                                return false;
                            }
                        }));
                        List stateRDDs = this.org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$findAllMarkedRDDs$1(rdd);
                        rdd.count();
                        this.rddsCheckpointed$1.elem = stateRDDs.size() == 2 && stateRDDs.forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(RDD<?> x$25) {
                                return x$25.isCheckpointed();
                            }
                        });
                    }

                    public final List org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$findAllMarkedRDDs$1(RDD rdd) {
                        List list;
                        List markedRDDs = ((TraversableOnce)rdd.dependencies().flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$45$$anonfun$apply$39 $outer;

                            public final List<RDD<?>> apply(Dependency<?> dep) {
                                return this.$outer.org$apache$spark$streaming$CheckpointSuite$$anonfun$$anonfun$$findAllMarkedRDDs$1(dep.rdd());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).toList();
                        if (rdd.checkpointData().isDefined()) {
                            RDD rDD = rdd;
                            list = markedRDDs.$colon$colon((Object)rDD);
                        } else {
                            list = markedRDDs;
                        }
                        return list;
                    }
                    {
                        this.shouldCheckpointAllMarkedRDDs$1 = shouldCheckpointAllMarkedRDDs$1;
                        this.rddsCheckpointed$1 = rddsCheckpointed$1;
                    }
                });
                this.$outer.ssc().start();
                batchCounter.waitUntilBatchesCompleted(1, 10000L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)shouldCheckpointAllMarkedRDDs.elem));
                boolean $org_scalatest_assert_macro_right = true;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 914));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)rddsCheckpointed.elem));
                boolean $org_scalatest_assert_macro_right2 = true;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 915));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 849));
    }
}

