/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rdd.BlockRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.ReceiverInputDStreamSuite$;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.StreamingContext$;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.TestSuiteBase$class;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD;
import org.apache.spark.streaming.receiver.BlockManagerBasedStoreResult;
import org.apache.spark.streaming.receiver.ReceivedBlockStoreResult;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.receiver.WriteAheadLogBasedStoreResult;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import org.apache.spark.streaming.util.WriteAheadLogRecordHandle;
import org.apache.spark.streaming.util.WriteAheadLogUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.concurrent.PatienceConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u0001-\u0011\u0011DU3dK&4XM]%oaV$Hi\u0015;sK\u0006l7+^5uK*\u00111\u0001B\u0001\ngR\u0014X-Y7j]\u001eT!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dA\u0011AB1qC\u000eDWMC\u0001\n\u0003\ry'oZ\u0002\u0001'\u0011\u0001A\u0002\u0005\u000b\u0011\u00055qQ\"\u0001\u0003\n\u0005=!!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\tiA+Z:u'VLG/\u001a\"bg\u0016\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0005\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA\r\u0017\u0005E\u0011UMZ8sK\u0006sG-\u00114uKJ\fE\u000e\u001c\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"!\u0005\u0001\t\u000b}\u0001A\u0011\t\u0011\u0002\u0011\u00054G/\u001a:BY2$\u0012!\t\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0005+:LG\u000fC\u0003)\u0001\u0011%\u0011&\u0001\buKN$x+\u001b;i_V$x+\u0011'\u0015\u0005)\u0012ECA\u0011,\u0011\u0015as\u00051\u0001.\u0003\u0011\u0011w\u000eZ=\u0011\t\tr\u0003'I\u0005\u0003_\r\u0012\u0011BR;oGRLwN\\\u00191\u0005EJ\u0004c\u0001\u001a6o5\t1G\u0003\u00025\u0005\u00059Am\u001d;sK\u0006l\u0017B\u0001\u001c4\u0005Q\u0011VmY3jm\u0016\u0014\u0018J\u001c9vi\u0012\u001bFO]3b[B\u0011\u0001(\u000f\u0007\u0001\t%Q4&!A\u0001\u0002\u000b\u00051H\u0001\u0003`IE\u001a\u0014C\u0001\u001f@!\t\u0011S(\u0003\u0002?G\t9aj\u001c;iS:<\u0007C\u0001\u0012A\u0013\t\t5EA\u0002B]fDQaQ\u0014A\u0002\u0011\u000b1!\\:h!\t)\u0005J\u0004\u0002#\r&\u0011qiI\u0001\u0007!J,G-\u001a4\n\u0005%S%AB*ue&twM\u0003\u0002HG!)A\n\u0001C\u0005\u001b\u0006YA/Z:u/&$\bnV!M)\tqe\u000b\u0006\u0002\"\u001f\")Af\u0013a\u0001!B!!EL)\"a\t\u0011F\u000bE\u00023kM\u0003\"\u0001\u000f+\u0005\u0013U{\u0015\u0011!A\u0001\u0006\u0003Y$\u0001B0%cQBQaQ&A\u0002\u0011CQ\u0001\u0017\u0001\u0005\ne\u000bqA];o)\u0016\u001cH\u000fF\u0002\"5~CQaW,A\u0002q\u000b\u0011\"\u001a8bE2,w+\u0011'\u0011\u0005\tj\u0016B\u00010$\u0005\u001d\u0011un\u001c7fC:DQ\u0001L,A\u0002\u0001\u0004BA\t\u0018bCA\u0012!\r\u001a\t\u0004eU\u001a\u0007C\u0001\u001de\t%)w,!A\u0001\u0002\u000b\u00051H\u0001\u0003`IE*\u0004\"B4\u0001\t\u0013A\u0017aD2sK\u0006$XM\u00117pG.LeNZ8\u0015\u0007%|\u0017\u000f\u0005\u0002k[6\t1N\u0003\u0002m\u0005\u0005I1o\u00195fIVdWM]\u0005\u0003].\u0014\u0011CU3dK&4X\r\u001a\"m_\u000e\\\u0017J\u001c4p\u0011\u0015\u0001h\r1\u0001]\u0003-9\u0018\u000e\u001e5X\u00032KeNZ8\t\u000fI4\u0007\u0013!a\u00019\u0006Y1M]3bi\u0016\u0014En\\2l\u0011\u001d!\b!%A\u0005\nU\f\u0011d\u0019:fCR,'\t\\8dW&sgm\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\taO\u000b\u0002]o.\n\u0001\u0010\u0005\u0002z}6\t!P\u0003\u0002|y\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003{\u000e\n!\"\u00198o_R\fG/[8o\u0013\ty(PA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class ReceiverInputDStreamSuite
extends SparkFunSuite
implements TestSuiteBase {
    private final String checkpointDir;
    private final SparkConf conf;
    private final PatienceConfiguration.Timeout eventuallyTimeout;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    private volatile boolean bitmap$0;

    private String checkpointDir$lzycompute() {
        ReceiverInputDStreamSuite receiverInputDStreamSuite = this;
        synchronized (receiverInputDStreamSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase$class.checkpointDir(this);
                this.bitmap$0 = true;
            }
            return this.checkpointDir;
        }
    }

    @Override
    public String checkpointDir() {
        return this.bitmap$0 ? this.checkpointDir : this.checkpointDir$lzycompute();
    }

    @Override
    public SparkConf conf() {
        return this.conf;
    }

    @Override
    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    @Override
    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    @Override
    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    @Override
    public String framework() {
        return TestSuiteBase$class.framework(this);
    }

    @Override
    public String master() {
        return TestSuiteBase$class.master(this);
    }

    @Override
    public Duration batchDuration() {
        return TestSuiteBase$class.batchDuration(this);
    }

    @Override
    public int numInputPartitions() {
        return TestSuiteBase$class.numInputPartitions(this);
    }

    @Override
    public int maxWaitTimeMillis() {
        return TestSuiteBase$class.maxWaitTimeMillis(this);
    }

    @Override
    public boolean useManualClock() {
        return TestSuiteBase$class.useManualClock(this);
    }

    @Override
    public boolean actuallyWait() {
        return TestSuiteBase$class.actuallyWait(this);
    }

    @Override
    public void beforeFunction() {
        TestSuiteBase$class.beforeFunction(this);
    }

    @Override
    public void afterFunction() {
        TestSuiteBase$class.afterFunction(this);
    }

    @Override
    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase$class.withStreamingContext(this, ssc, block);
    }

    @Override
    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase$class.withTestServer(this, testServer, block);
    }

    @Override
    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation2, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase$class.setupStreams(this, input, operation2, numPartitions, evidence$4, evidence$5);
    }

    @Override
    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation2, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase$class.setupStreams(this, input1, input2, operation2, evidence$6, evidence$7, evidence$8);
    }

    @Override
    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$9) {
        return TestSuiteBase$class.runStreams(this, ssc, numBatches, numExpectedOutput, preStop, evidence$9);
    }

    @Override
    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$10) {
        return TestSuiteBase$class.runStreamsWithPartitions(this, ssc, numBatches, numExpectedOutput, preStop, evidence$10);
    }

    @Override
    public <V> void verifyOutput(Seq<Seq<V>> output2, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase$class.verifyOutput(this, output2, expectedOutput, useSet, evidence$11);
    }

    @Override
    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation2, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase$class.testOperation(this, input, operation2, expectedOutput, useSet, evidence$12, evidence$13);
    }

    @Override
    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation2, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase$class.testOperation(this, input, operation2, expectedOutput, numBatches, useSet, evidence$14, evidence$15);
    }

    @Override
    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation2, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase$class.testOperation(this, input1, input2, operation2, expectedOutput, useSet, evidence$16, evidence$17, evidence$18);
    }

    @Override
    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation2, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase$class.testOperation(this, input1, input2, operation2, expectedOutput, numBatches, useSet, evidence$19, evidence$20, evidence$21);
    }

    @Override
    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase$class.testOperation$default$4(this);
    }

    @Override
    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase$class.setupStreams$default$3(this);
    }

    @Override
    public <V> Function0<BoxedUnit> runStreamsWithPartitions$default$4() {
        return TestSuiteBase$class.runStreamsWithPartitions$default$4(this);
    }

    @Override
    public <V> Function0<BoxedUnit> runStreams$default$4() {
        return TestSuiteBase$class.runStreams$default$4(this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public void afterAll() {
        try {
            StreamingContext$.MODULE$.getActive().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(StreamingContext x$1) {
                    x$1.stop(x$1.stop$default$1());
                }
            });
            return;
        }
        finally {
            super.afterAll();
        }
    }

    private void testWithoutWAL(String msg, Function1<ReceiverInputDStream<?>, BoxedUnit> body) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Without WAL enabled: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, body){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverInputDStreamSuite $outer;
            private final Function1 body$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$streaming$ReceiverInputDStreamSuite$$runTest(false, this.body$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.body$1 = body$1;
            }
        }, new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
    }

    private void testWithWAL(String msg, Function1<ReceiverInputDStream<?>, BoxedUnit> body) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"With WAL enabled: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, body){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverInputDStreamSuite $outer;
            private final Function1 body$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$streaming$ReceiverInputDStreamSuite$$runTest(true, this.body$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.body$2 = body$2;
            }
        }, new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
    }

    public void org$apache$spark$streaming$ReceiverInputDStreamSuite$$runTest(boolean enableWAL, Function1<ReceiverInputDStream<?>, BoxedUnit> body) {
        SparkConf conf = new SparkConf();
        conf.setMaster("local[4]").setAppName("ReceiverInputDStreamSuite");
        conf.set(WriteAheadLogUtils$.MODULE$.RECEIVER_WAL_ENABLE_CONF_KEY(), ((Object)BoxesRunTime.boxToBoolean((boolean)enableWAL)).toString());
        Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)WriteAheadLogUtils$.MODULE$.enableReceiverLog(conf))).$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)enableWAL), Equality$.MODULE$.default()));
        StreamingContext ssc = new StreamingContext(conf, Seconds$.MODULE$.apply(1L));
        ReceiverInputDStream<Object> receiverStream = new ReceiverInputDStream<Object>(this, ssc){

            public Receiver<Object> getReceiver() {
                return null;
            }
        };
        this.withStreamingContext(ssc, (Function1)new Serializable(this, body, (ReceiverInputDStream)receiverStream){
            public static final long serialVersionUID = 0L;
            private final Function1 body$3;
            private final ReceiverInputDStream receiverStream$1;

            public final void apply(StreamingContext ssc) {
                this.body$3.apply((Object)this.receiverStream$1);
            }
            {
                this.body$3 = body$3;
                this.receiverStream$1 = receiverStream$1;
            }
        });
    }

    public ReceivedBlockInfo org$apache$spark$streaming$ReceiverInputDStreamSuite$$createBlockInfo(boolean withWALInfo, boolean createBlock) {
        StreamBlockId blockId = new StreamBlockId(0, Random$.MODULE$.nextLong());
        if (createBlock) {
            SparkEnv$.MODULE$.get().blockManager().putSingle((BlockId)blockId, (Object)BoxesRunTime.boxToInteger((int)1), StorageLevel$.MODULE$.MEMORY_ONLY(), true, ClassTag$.MODULE$.Int());
            Predef$.MODULE$.require(SparkEnv$.MODULE$.get().blockManager().master().contains((BlockId)blockId));
        }
        WriteAheadLogBasedStoreResult storeResult = withWALInfo ? new WriteAheadLogBasedStoreResult(blockId, (Option)None$.MODULE$, new WriteAheadLogRecordHandle(this){}) : new BlockManagerBasedStoreResult(blockId, (Option)None$.MODULE$);
        return new ReceivedBlockInfo(0, (Option)None$.MODULE$, (Option)None$.MODULE$, (ReceivedBlockStoreResult)storeResult);
    }

    public boolean org$apache$spark$streaming$ReceiverInputDStreamSuite$$createBlockInfo$default$2() {
        return true;
    }

    public ReceiverInputDStreamSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        TestSuiteBase$class.$init$(this);
        this.testWithoutWAL("createBlockRDD creates empty BlockRDD when no block info", (Function1<ReceiverInputDStream<?>, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverInputDStreamSuite $outer;

            public final void apply(ReceiverInputDStream<?> receiverStream) {
                RDD rdd = receiverStream.createBlockRDD(new Time(0L), (Seq)Seq$.MODULE$.empty());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rdd instanceof BlockRDD, "rdd.isInstanceOf[org.apache.spark.rdd.BlockRDD[_]]", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(rdd instanceof WriteAheadLogBackedBlockRDD, "rdd.isInstanceOf[org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD[_]]", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
                RDD $org_scalatest_assert_macro_left = rdd;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.testWithoutWAL("createBlockRDD creates correct BlockRDD with block info", (Function1<ReceiverInputDStream<?>, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverInputDStreamSuite $outer;

            public final void apply(ReceiverInputDStream<?> receiverStream) {
                Seq blockInfos = (Seq)Seq$.MODULE$.fill(5, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final ReceivedBlockInfo apply() {
                        return this.$outer.org$apache$spark$streaming$ReceiverInputDStreamSuite$$anonfun$$$outer().org$apache$spark$streaming$ReceiverInputDStreamSuite$$createBlockInfo(false, this.$outer.org$apache$spark$streaming$ReceiverInputDStreamSuite$$anonfun$$$outer().org$apache$spark$streaming$ReceiverInputDStreamSuite$$createBlockInfo$default$2());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Seq blockIds = (Seq)blockInfos.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StreamBlockId apply(ReceivedBlockInfo x$2) {
                        return x$2.blockId();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Predef$.MODULE$.require(blockIds.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(StreamBlockId blockId) {
                        return SparkEnv$.MODULE$.get().blockManager().master().contains((BlockId)blockId);
                    }
                }));
                RDD rdd = receiverStream.createBlockRDD(new Time(0L), blockInfos);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rdd instanceof BlockRDD, "rdd.isInstanceOf[org.apache.spark.rdd.BlockRDD[_]]", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(rdd instanceof WriteAheadLogBackedBlockRDD, "rdd.isInstanceOf[org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD[_]]", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
                BlockRDD blockRDD = (BlockRDD)rdd;
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(Predef$.MODULE$.refArrayOps((Object[])blockRDD.blockIds()).toSeq());
                Seq $org_scalatest_assert_macro_right = blockIds;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            }

            public /* synthetic */ ReceiverInputDStreamSuite org$apache$spark$streaming$ReceiverInputDStreamSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.testWithoutWAL("createBlockRDD filters non-existent blocks before creating BlockRDD", (Function1<ReceiverInputDStream<?>, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverInputDStreamSuite $outer;

            public final void apply(ReceiverInputDStream<?> receiverStream) {
                Seq presentBlockInfos = (Seq)Seq$.MODULE$.fill(2, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final ReceivedBlockInfo apply() {
                        return this.$outer.org$apache$spark$streaming$ReceiverInputDStreamSuite$$anonfun$$$outer().org$apache$spark$streaming$ReceiverInputDStreamSuite$$createBlockInfo(false, true);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Seq absentBlockInfos = (Seq)Seq$.MODULE$.fill(3, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final ReceivedBlockInfo apply() {
                        return this.$outer.org$apache$spark$streaming$ReceiverInputDStreamSuite$$anonfun$$$outer().org$apache$spark$streaming$ReceiverInputDStreamSuite$$createBlockInfo(false, false);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Seq blockInfos = (Seq)presentBlockInfos.$plus$plus((GenTraversableOnce)absentBlockInfos, Seq$.MODULE$.canBuildFrom());
                Seq blockIds = (Seq)blockInfos.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StreamBlockId apply(ReceivedBlockInfo x$3) {
                        return x$3.blockId();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Predef$.MODULE$.require(blockIds.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(StreamBlockId blockId) {
                        return SparkEnv$.MODULE$.get().blockManager().master().contains((BlockId)blockId);
                    }
                }));
                Predef$.MODULE$.require(blockIds.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(StreamBlockId blockId) {
                        return !SparkEnv$.MODULE$.get().blockManager().master().contains((BlockId)blockId);
                    }
                }));
                RDD rdd = receiverStream.createBlockRDD(new Time(0L), blockInfos);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rdd instanceof BlockRDD, "rdd.isInstanceOf[org.apache.spark.rdd.BlockRDD[_]]", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
                BlockRDD blockRDD = (BlockRDD)rdd;
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(Predef$.MODULE$.refArrayOps((Object[])blockRDD.blockIds()).toSeq());
                Seq $org_scalatest_assert_macro_right = (Seq)presentBlockInfos.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StreamBlockId apply(ReceivedBlockInfo x$4) {
                        return x$4.blockId();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
            }

            public /* synthetic */ ReceiverInputDStreamSuite org$apache$spark$streaming$ReceiverInputDStreamSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.testWithWAL("createBlockRDD creates empty WALBackedBlockRDD when no block info", (Function1<ReceiverInputDStream<?>, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverInputDStreamSuite $outer;

            public final void apply(ReceiverInputDStream<?> receiverStream) {
                RDD rdd = receiverStream.createBlockRDD(new Time(0L), (Seq)Seq$.MODULE$.empty());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rdd instanceof WriteAheadLogBackedBlockRDD, "rdd.isInstanceOf[org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD[_]]", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
                RDD $org_scalatest_assert_macro_left = rdd;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.testWithWAL("createBlockRDD creates correct WALBackedBlockRDD with all block info having WAL info", (Function1<ReceiverInputDStream<?>, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverInputDStreamSuite $outer;

            public final void apply(ReceiverInputDStream<?> receiverStream) {
                Seq blockInfos = (Seq)Seq$.MODULE$.fill(5, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$11 $outer;

                    public final ReceivedBlockInfo apply() {
                        return this.$outer.org$apache$spark$streaming$ReceiverInputDStreamSuite$$anonfun$$$outer().org$apache$spark$streaming$ReceiverInputDStreamSuite$$createBlockInfo(true, this.$outer.org$apache$spark$streaming$ReceiverInputDStreamSuite$$anonfun$$$outer().org$apache$spark$streaming$ReceiverInputDStreamSuite$$createBlockInfo$default$2());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Seq blockIds = (Seq)blockInfos.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StreamBlockId apply(ReceivedBlockInfo x$5) {
                        return x$5.blockId();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                RDD rdd = receiverStream.createBlockRDD(new Time(0L), blockInfos);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rdd instanceof WriteAheadLogBackedBlockRDD, "rdd.isInstanceOf[org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD[_]]", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
                WriteAheadLogBackedBlockRDD blockRDD = (WriteAheadLogBackedBlockRDD)rdd;
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(Predef$.MODULE$.refArrayOps((Object[])blockRDD.blockIds()).toSeq());
                Seq $org_scalatest_assert_macro_right = blockIds;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(Predef$.MODULE$.refArrayOps((Object[])blockRDD.walRecordHandles()).toSeq());
                Seq $org_scalatest_assert_macro_right2 = (Seq)blockInfos.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final WriteAheadLogRecordHandle apply(ReceivedBlockInfo x$6) {
                        return (WriteAheadLogRecordHandle)x$6.walRecordHandleOption().get();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            }

            public /* synthetic */ ReceiverInputDStreamSuite org$apache$spark$streaming$ReceiverInputDStreamSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.testWithWAL("createBlockRDD creates BlockRDD when some block info don't have WAL info", (Function1<ReceiverInputDStream<?>, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverInputDStreamSuite $outer;

            public final void apply(ReceiverInputDStream<?> receiverStream) {
                Seq blockInfos1 = (Seq)Seq$.MODULE$.fill(2, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$15 $outer;

                    public final ReceivedBlockInfo apply() {
                        return this.$outer.org$apache$spark$streaming$ReceiverInputDStreamSuite$$anonfun$$$outer().org$apache$spark$streaming$ReceiverInputDStreamSuite$$createBlockInfo(true, this.$outer.org$apache$spark$streaming$ReceiverInputDStreamSuite$$anonfun$$$outer().org$apache$spark$streaming$ReceiverInputDStreamSuite$$createBlockInfo$default$2());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Seq blockInfos2 = (Seq)Seq$.MODULE$.fill(3, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$15 $outer;

                    public final ReceivedBlockInfo apply() {
                        return this.$outer.org$apache$spark$streaming$ReceiverInputDStreamSuite$$anonfun$$$outer().org$apache$spark$streaming$ReceiverInputDStreamSuite$$createBlockInfo(false, this.$outer.org$apache$spark$streaming$ReceiverInputDStreamSuite$$anonfun$$$outer().org$apache$spark$streaming$ReceiverInputDStreamSuite$$createBlockInfo$default$2());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Seq blockInfos = (Seq)blockInfos1.$plus$plus((GenTraversableOnce)blockInfos2, Seq$.MODULE$.canBuildFrom());
                Seq blockIds = (Seq)blockInfos.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StreamBlockId apply(ReceivedBlockInfo x$7) {
                        return x$7.blockId();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                RDD rdd = receiverStream.createBlockRDD(new Time(0L), blockInfos);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rdd instanceof BlockRDD, "rdd.isInstanceOf[org.apache.spark.rdd.BlockRDD[_]]", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
                BlockRDD blockRDD = (BlockRDD)rdd;
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(Predef$.MODULE$.refArrayOps((Object[])blockRDD.blockIds()).toSeq());
                Seq $org_scalatest_assert_macro_right = blockIds;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            }

            public /* synthetic */ ReceiverInputDStreamSuite org$apache$spark$streaming$ReceiverInputDStreamSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

