/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.rdd;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.internal.config.package$;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD;
import org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD$;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogSegment;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogWriter;
import org.apache.spark.streaming.util.WriteAheadLogRecordHandle;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001B\u0001\u0003\u00015\u0011\u0001e\u0016:ji\u0016\f\u0005.Z1e\u0019><')Y2lK\u0012\u0014En\\2l%\u0012#5+^5uK*\u00111\u0001B\u0001\u0004e\u0012$'BA\u0003\u0007\u0003%\u0019HO]3b[&twM\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u00131A\u0011q\u0002E\u0007\u0002\r%\u0011\u0011C\u0002\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005M1R\"\u0001\u000b\u000b\u0005UQ\u0011!C:dC2\fG/Z:u\u0013\t9BCA\tCK\u001a|'/Z!oI\u00063G/\u001a:BY2\u0004\"aE\r\n\u0005i!\"A\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]#bG\"DQ\u0001\b\u0001\u0005\u0002u\ta\u0001P5oSRtD#\u0001\u0010\u0011\u0005}\u0001Q\"\u0001\u0002\t\u000f\u0005\u0002!\u0019!C\u0001E\u0005!1m\u001c8g+\u0005\u0019\u0003CA\b%\u0013\t)cAA\u0005Ta\u0006\u00148nQ8oM\"1q\u0005\u0001Q\u0001\n\r\nQaY8oM\u0002Bq!\u000b\u0001C\u0002\u0013\u0005!&\u0001\u0006iC\u0012|w\u000e]\"p]\u001a,\u0012a\u000b\t\u0003YAj\u0011!\f\u0006\u0003C9R!a\f\u0005\u0002\r!\fGm\\8q\u0013\t\tTFA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0007g\u0001\u0001\u000b\u0011B\u0016\u0002\u0017!\fGm\\8q\u0007>tg\r\t\u0005\bk\u0001\u0001\r\u0011\"\u00017\u00031\u0019\b/\u0019:l\u0007>tG/\u001a=u+\u00059\u0004CA\b9\u0013\tIdA\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u0004<\u0001\u0001\u0007I\u0011\u0001\u001f\u0002!M\u0004\u0018M]6D_:$X\r\u001f;`I\u0015\fHCA\u001fD!\tq\u0014)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\u0011)f.\u001b;\t\u000f\u0011S\u0014\u0011!a\u0001o\u0005\u0019\u0001\u0010J\u0019\t\r\u0019\u0003\u0001\u0015)\u00038\u00035\u0019\b/\u0019:l\u0007>tG/\u001a=uA!9\u0001\n\u0001a\u0001\n\u0003I\u0015\u0001\u00042m_\u000e\\W*\u00198bO\u0016\u0014X#\u0001&\u0011\u0005-sU\"\u0001'\u000b\u000553\u0011aB:u_J\fw-Z\u0005\u0003\u001f2\u0013AB\u00117pG.l\u0015M\\1hKJDq!\u0015\u0001A\u0002\u0013\u0005!+\u0001\tcY>\u001c7.T1oC\u001e,'o\u0018\u0013fcR\u0011Qh\u0015\u0005\b\tB\u000b\t\u00111\u0001K\u0011\u0019)\u0006\u0001)Q\u0005\u0015\u0006i!\r\\8dW6\u000bg.Y4fe\u0002Bqa\u0016\u0001A\u0002\u0013\u0005\u0001,A\ttKJL\u0017\r\\5{KJl\u0015M\\1hKJ,\u0012!\u0017\t\u00035vk\u0011a\u0017\u0006\u00039\u001a\t!b]3sS\u0006d\u0017N_3s\u0013\tq6LA\tTKJL\u0017\r\\5{KJl\u0015M\\1hKJDq\u0001\u0019\u0001A\u0002\u0013\u0005\u0011-A\u000btKJL\u0017\r\\5{KJl\u0015M\\1hKJ|F%Z9\u0015\u0005u\u0012\u0007b\u0002#`\u0003\u0003\u0005\r!\u0017\u0005\u0007I\u0002\u0001\u000b\u0015B-\u0002%M,'/[1mSj,'/T1oC\u001e,'\u000f\t\u0005\bM\u0002\u0001\r\u0011\"\u0001h\u0003\r!\u0017N]\u000b\u0002QB\u0011\u0011N\\\u0007\u0002U*\u00111\u000e\\\u0001\u0003S>T\u0011!\\\u0001\u0005U\u00064\u0018-\u0003\u0002pU\n!a)\u001b7f\u0011\u001d\t\b\u00011A\u0005\u0002I\fq\u0001Z5s?\u0012*\u0017\u000f\u0006\u0002>g\"9A\t]A\u0001\u0002\u0004A\u0007BB;\u0001A\u0003&\u0001.\u0001\u0003eSJ\u0004\u0003\"B<\u0001\t\u0003B\u0018A\u00032fM>\u0014X-R1dQR\tQ\bC\u0003{\u0001\u0011\u0005\u00030A\u0005bMR,'/R1dQ\")A\u0010\u0001C!q\u0006A\u0011M\u001a;fe\u0006cG\u000eC\u0003\u007f\u0001\u0011%q0\u0001\tj]&$8\u000b]1sW\u000e{g\u000e^3yiR\u0019Q(!\u0001\t\u0013\u0005\rQ\u0010%AA\u0002\u0005\u0015\u0011!B0d_:4\u0007\u0003\u0002 \u0002\b\rJ1!!\u0003@\u0005\u0019y\u0005\u000f^5p]\"1\u0011Q\u0002\u0001\u0005\na\f\u0001c\u001d;paN\u0003\u0018M]6D_:$X\r\u001f;\t\u000f\u0005E\u0001\u0001\"\u0003\u0002\u0014\u00059A/Z:u%\u0012#E#D\u001f\u0002\u0016\u0005}\u00111EA\u0014\u0003c\t)\u0004\u0003\u0005\u0002\u0018\u0005=\u0001\u0019AA\r\u00035qW/\u001c)beRLG/[8ogB\u0019a(a\u0007\n\u0007\u0005uqHA\u0002J]RD\u0001\"!\t\u0002\u0010\u0001\u0007\u0011\u0011D\u0001\u0012]Vl\u0007+\u0019:uSRLwN\\:J]\nk\u0005\u0002CA\u0013\u0003\u001f\u0001\r!!\u0007\u0002%9,X\u000eU1si&$\u0018n\u001c8t\u0013:<\u0016\t\u0014\u0005\u000b\u0003S\ty\u0001%AA\u0002\u0005-\u0012\u0001\u0005;fgRL5O\u00117pG.4\u0016\r\\5e!\rq\u0014QF\u0005\u0004\u0003_y$a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0003g\ty\u0001%AA\u0002\u0005-\u0012a\u0004;fgR\u0014En\\2l%\u0016lwN^3\t\u0015\u0005]\u0012q\u0002I\u0001\u0002\u0004\tY#A\u0007uKN$8\u000b^8sK&s')\u0014\u0005\b\u0003w\u0001A\u0011BA\u001f\u0003a9WM\\3sCR,w+\u0011'SK\u000e|'\u000f\u001a%b]\u0012dWm\u001d\u000b\u0007\u0003\u007f\t\u0019'!\u001f\u0011\r\u0005\u0005\u0013\u0011KA,\u001d\u0011\t\u0019%!\u0014\u000f\t\u0005\u0015\u00131J\u0007\u0003\u0003\u000fR1!!\u0013\r\u0003\u0019a$o\\8u}%\t\u0001)C\u0002\u0002P}\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002T\u0005U#aA*fc*\u0019\u0011qJ \u0011\t\u0005e\u0013qL\u0007\u0003\u00037R1!!\u0018\u0005\u0003\u0011)H/\u001b7\n\t\u0005\u0005\u00141\f\u0002\u001e\r&dWMQ1tK\u0012<&/\u001b;f\u0003\",\u0017\r\u001a'pON+w-\\3oi\"A\u0011QMA\u001d\u0001\u0004\t9'A\u0005cY>\u001c7\u000eR1uCB1\u0011\u0011IA)\u0003S\u0002b!!\u0011\u0002R\u0005-\u0004\u0003BA7\u0003gr1APA8\u0013\r\t\thP\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0014q\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005Et\b\u0003\u0005\u0002|\u0005e\u0002\u0019AA?\u0003!\u0011Gn\\2l\u0013\u0012\u001c\bCBA!\u0003#\ny\bE\u0002L\u0003\u0003K1!a!M\u0005\u001d\u0011En\\2l\u0013\u0012Dq!a\"\u0001\t\u0013\tI)A\rhK:,'/\u0019;f\r\u0006\\WMU3d_J$\u0007*\u00198eY\u0016\u001cH\u0003BA \u0003\u0017C\u0001\"!$\u0002\u0006\u0002\u0007\u0011\u0011D\u0001\u0006G>,h\u000e\u001e\u0005\n\u0003#\u0003\u0011\u0013!C\u0005\u0003'\u000b!$\u001b8jiN\u0003\u0018M]6D_:$X\r\u001f;%I\u00164\u0017-\u001e7uIE*\"!!&+\t\u0005\u0015\u0011qS\u0016\u0003\u00033\u0003B!a'\u0002&6\u0011\u0011Q\u0014\u0006\u0005\u0003?\u000b\t+A\u0005v]\u000eDWmY6fI*\u0019\u00111U \u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002(\u0006u%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u00111\u0016\u0001\u0012\u0002\u0013%\u0011QV\u0001\u0012i\u0016\u001cHO\u0015#EI\u0011,g-Y;mi\u0012\"TCAAXU\u0011\tY#a&\t\u0013\u0005M\u0006!%A\u0005\n\u00055\u0016!\u0005;fgR\u0014F\t\u0012\u0013eK\u001a\fW\u000f\u001c;%k!I\u0011q\u0017\u0001\u0012\u0002\u0013%\u0011QV\u0001\u0012i\u0016\u001cHO\u0015#EI\u0011,g-Y;mi\u00122\u0004")
public class WriteAheadLogBackedBlockRDDSuite
extends SparkFunSuite
implements BeforeAndAfterEach {
    private final SparkConf conf;
    private final Configuration hadoopConf;
    private SparkContext sparkContext;
    private BlockManager blockManager;
    private SerializerManager serializerManager;
    private File dir;

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.class.runTest((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public SparkConf conf() {
        return this.conf;
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public SparkContext sparkContext() {
        return this.sparkContext;
    }

    public void sparkContext_$eq(SparkContext x$1) {
        this.sparkContext = x$1;
    }

    public BlockManager blockManager() {
        return this.blockManager;
    }

    public void blockManager_$eq(BlockManager x$1) {
        this.blockManager = x$1;
    }

    public SerializerManager serializerManager() {
        return this.serializerManager;
    }

    public void serializerManager_$eq(SerializerManager x$1) {
        this.serializerManager = x$1;
    }

    public File dir() {
        return this.dir;
    }

    public void dir_$eq(File x$1) {
        this.dir = x$1;
    }

    public void beforeEach() {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this);
        this.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$initSparkContext(this.initSparkContext$default$1());
        this.dir_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()));
    }

    public void afterEach() {
        try {
            Utils$.MODULE$.deleteRecursively(this.dir());
            return;
        }
        finally {
            BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this);
        }
    }

    public void afterAll() {
        try {
            this.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$stopSparkContext();
            return;
        }
        finally {
            super.afterAll();
        }
    }

    public void org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$initSparkContext(Option<SparkConf> _conf) {
        if (this.sparkContext() == null) {
            this.sparkContext_$eq(new SparkContext((SparkConf)_conf.getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ WriteAheadLogBackedBlockRDDSuite $outer;

                public final SparkConf apply() {
                    return this.$outer.conf();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            })));
            this.blockManager_$eq(this.sparkContext().env().blockManager());
            this.serializerManager_$eq(this.sparkContext().env().serializerManager());
        }
    }

    private Option<SparkConf> initSparkContext$default$1() {
        return None$.MODULE$;
    }

    public void org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$stopSparkContext() {
        try {
            if (this.sparkContext() != null) {
                this.sparkContext().stop();
            }
            System.clearProperty("spark.driver.port");
            this.blockManager_$eq(null);
            this.serializerManager_$eq(null);
            return;
        }
        finally {
            this.sparkContext_$eq(null);
        }
    }

    public void org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD(int numPartitions, int numPartitionsInBM, int numPartitionsInWAL, boolean testIsBlockValid, boolean testBlockRemove, boolean testStoreInBM) {
        BoxedUnit boxedUnit;
        Object object;
        Predef$.MODULE$.require(numPartitionsInBM <= numPartitions, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Can't put more partitions in BlockManager than that in RDD";
            }
        });
        Predef$.MODULE$.require(numPartitionsInWAL <= numPartitions, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Can't put more partitions in write ahead log than that in RDD";
            }
        });
        Seq data = (Seq)Seq$.MODULE$.fill(numPartitions, 10, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return Random$.MODULE$.nextString(50);
            }
        });
        StreamBlockId[] blockIds = (StreamBlockId[])Array$.MODULE$.fill(numPartitions, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final StreamBlockId apply() {
                return new StreamBlockId(Random$.MODULE$.nextInt(), (long)Random$.MODULE$.nextInt());
            }
        }, ClassTag$.MODULE$.apply(StreamBlockId.class));
        ((IterableLike)((IterableLike)data.zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])blockIds), Seq$.MODULE$.canBuildFrom())).take(numPartitionsInBM)).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WriteAheadLogBackedBlockRDDSuite $outer;

            public final boolean apply(Tuple2<Seq<String>, StreamBlockId> x0$1) {
                Tuple2<Seq<String>, StreamBlockId> tuple2 = x0$1;
                if (tuple2 != null) {
                    Seq block = (Seq)tuple2._1();
                    StreamBlockId blockId = (StreamBlockId)tuple2._2();
                    BlockManager qual$1 = this.$outer.blockManager();
                    StreamBlockId x$16 = blockId;
                    Iterator x$17 = block.iterator();
                    StorageLevel x$18 = StorageLevel$.MODULE$.MEMORY_ONLY_SER();
                    boolean x$19 = qual$1.putIterator$default$4();
                    boolean bl = qual$1.putIterator((BlockId)x$16, x$17, x$18, x$19, ClassTag$.MODULE$.apply(String.class));
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Seq recordHandles = (Seq)this.generateFakeRecordHandles(numPartitions - numPartitionsInWAL).$plus$plus(this.generateWALRecordHandles((Seq<Seq<String>>)((Seq)data.takeRight(numPartitionsInWAL)), (Seq<BlockId>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])blockIds).takeRight(numPartitionsInWAL))), Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])blockIds).take(numPartitionsInBM)).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WriteAheadLogBackedBlockRDDSuite $outer;

            public final boolean apply(StreamBlockId x$1) {
                return this.$outer.blockManager().get((BlockId)x$1, ClassTag$.MODULE$.Nothing()).nonEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected blocks not in BlockManager";
            }
        });
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])blockIds).takeRight(numPartitions - numPartitionsInBM)).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WriteAheadLogBackedBlockRDDSuite $outer;

            public final boolean apply(StreamBlockId x$2) {
                return this.$outer.blockManager().get((BlockId)x$2, ClassTag$.MODULE$.Nothing()).isEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Unexpected blocks in BlockManager";
            }
        });
        Predef$.MODULE$.require(((IterableLike)recordHandles.takeRight(numPartitionsInWAL)).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileBasedWriteAheadLogSegment s) {
                return new File(new StringOps(Predef$.MODULE$.augmentString(s.path())).stripPrefix("file://")).exists();
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected blocks not in write ahead log";
            }
        });
        Predef$.MODULE$.require(((IterableLike)recordHandles.take(numPartitions - numPartitionsInWAL)).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileBasedWriteAheadLogSegment s) {
                return !new File(new StringOps(Predef$.MODULE$.augmentString(s.path())).stripPrefix("file://")).exists();
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Unexpected blocks in write ahead log";
            }
        });
        SparkContext x$20 = this.sparkContext();
        BlockId[] x$21 = (BlockId[])Predef$.MODULE$.refArrayOps((Object[])blockIds).toArray(ClassTag$.MODULE$.apply(BlockId.class));
        WriteAheadLogRecordHandle[] x$22 = (WriteAheadLogRecordHandle[])recordHandles.toArray(ClassTag$.MODULE$.apply(WriteAheadLogRecordHandle.class));
        boolean x$23 = false;
        boolean[] x$24 = WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$4();
        StorageLevel x$25 = WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$6();
        WriteAheadLogBackedBlockRDD rdd = new WriteAheadLogBackedBlockRDD(x$20, x$21, x$22, x$24, x$23, x$25, ClassTag$.MODULE$.apply(String.class));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(rdd.collect());
        Seq $org_scalatest_assert_macro_right = (Seq)data.flatten((Function1)Predef$.MODULE$.$conforms());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
        if (testIsBlockValid) {
            Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)numPartitionsInBM)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)numPartitions), Equality$.MODULE$.default()), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "All partitions must be in BlockManager";
                }
            });
            Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)numPartitionsInWAL)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0), Equality$.MODULE$.default()), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "No partitions must be in WAL";
                }
            });
            WriteAheadLogBackedBlockRDD rdd2 = new WriteAheadLogBackedBlockRDD(this.sparkContext(), (BlockId[])Predef$.MODULE$.refArrayOps((Object[])blockIds).toArray(ClassTag$.MODULE$.apply(BlockId.class)), (WriteAheadLogRecordHandle[])recordHandles.toArray(ClassTag$.MODULE$.apply(WriteAheadLogRecordHandle.class)), (boolean[])Array$.MODULE$.fill(blockIds.length, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }, ClassTag$.MODULE$.Boolean()), WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$5(), WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$6(), ClassTag$.MODULE$.apply(String.class));
            object = this.intercept((Function0)new Serializable(this, rdd2){
                public static final long serialVersionUID = 0L;
                private final WriteAheadLogBackedBlockRDD rdd2$1;

                public final String[] apply() {
                    return (String[])this.rdd2$1.collect();
                }
                {
                    this.rdd2$1 = rdd2$1;
                }
            }, ClassTag$.MODULE$.apply(SparkException.class), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
        } else {
            object = BoxedUnit.UNIT;
        }
        if (testBlockRemove) {
            Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)numPartitions)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)numPartitionsInWAL), Equality$.MODULE$.default()), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "All partitions must be in WAL for this test";
                }
            });
            Predef$.MODULE$.require(numPartitionsInBM > 0, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Some partitions must be in BlockManager for this test";
                }
            });
            rdd.removeBlocks();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(rdd.collect());
            Seq $org_scalatest_assert_macro_right2 = (Seq)data.flatten((Function1)Predef$.MODULE$.$conforms());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            boxedUnit = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (testStoreInBM) {
            SparkContext x$26 = this.sparkContext();
            BlockId[] x$27 = (BlockId[])Predef$.MODULE$.refArrayOps((Object[])blockIds).toArray(ClassTag$.MODULE$.apply(BlockId.class));
            WriteAheadLogRecordHandle[] x$28 = (WriteAheadLogRecordHandle[])recordHandles.toArray(ClassTag$.MODULE$.apply(WriteAheadLogRecordHandle.class));
            boolean x$29 = true;
            StorageLevel x$30 = StorageLevel$.MODULE$.MEMORY_ONLY();
            boolean[] x$31 = WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$4();
            WriteAheadLogBackedBlockRDD rdd2 = new WriteAheadLogBackedBlockRDD(x$26, x$27, x$28, x$31, x$29, x$30, ClassTag$.MODULE$.apply(String.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(rdd2.collect());
            Seq $org_scalatest_assert_macro_right3 = (Seq)data.flatten((Function1)Predef$.MODULE$.$conforms());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])blockIds).forall((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ WriteAheadLogBackedBlockRDDSuite $outer;

                public final boolean apply(StreamBlockId x$3) {
                    return this.$outer.blockManager().get((BlockId)x$3, ClassTag$.MODULE$.Nothing()).nonEmpty();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }), "scala.this.Predef.refArrayOps[org.apache.spark.storage.StreamBlockId](blockIds).forall(((x$3: org.apache.spark.storage.StreamBlockId) => WriteAheadLogBackedBlockRDDSuite.this.blockManager.get[Nothing](x$3)((ClassTag.Nothing: scala.reflect.ClassTag[Nothing])).nonEmpty))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"All blocks not found in block manager", Prettifier$.MODULE$.default(), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        }
    }

    public boolean org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD$default$4() {
        return false;
    }

    public boolean org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD$default$5() {
        return false;
    }

    public boolean org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD$default$6() {
        return false;
    }

    private Seq<FileBasedWriteAheadLogSegment> generateWALRecordHandles(Seq<Seq<String>> blockData, Seq<BlockId> blockIds) {
        Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)blockData.size())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)blockIds.size()), Equality$.MODULE$.default()));
        FileBasedWriteAheadLogWriter writer = new FileBasedWriteAheadLogWriter(new File(this.dir(), "logFile").toString(), this.hadoopConf());
        Seq segments = (Seq)((TraversableLike)blockData.zip(blockIds, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, writer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WriteAheadLogBackedBlockRDDSuite $outer;
            private final FileBasedWriteAheadLogWriter writer$1;

            public final FileBasedWriteAheadLogSegment apply(Tuple2<Seq<String>, BlockId> x0$2) {
                Tuple2<Seq<String>, BlockId> tuple2 = x0$2;
                if (tuple2 != null) {
                    Seq data = (Seq)tuple2._1();
                    BlockId id = (BlockId)tuple2._2();
                    FileBasedWriteAheadLogSegment fileBasedWriteAheadLogSegment = this.writer$1.write(this.$outer.serializerManager().dataSerialize(id, data.iterator(), ClassTag$.MODULE$.apply(String.class)).toByteBuffer());
                    return fileBasedWriteAheadLogSegment;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.writer$1 = writer$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        writer.close();
        return segments;
    }

    private Seq<FileBasedWriteAheadLogSegment> generateFakeRecordHandles(int count) {
        return Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.fill(count, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final FileBasedWriteAheadLogSegment apply() {
                return new FileBasedWriteAheadLogSegment("random", 0L, 0);
            }
        }, ClassTag$.MODULE$.apply(FileBasedWriteAheadLogSegment.class)));
    }

    public WriteAheadLogBackedBlockRDDSuite() {
        BeforeAndAfterEach.class.$init$((BeforeAndAfterEach)this);
        this.conf = new SparkConf().setMaster("local[2]").setAppName(((Object)((Object)this)).getClass().getSimpleName());
        this.hadoopConf = new Configuration();
        this.sparkContext = null;
        this.blockManager = null;
        this.serializerManager = null;
        this.dir = null;
        this.test("Read data available in both block manager and write ahead log", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WriteAheadLogBackedBlockRDDSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD(5, 5, 5, this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD$default$4(), this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD$default$5(), this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD$default$6());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("Read data available only in block manager, not in write ahead log", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WriteAheadLogBackedBlockRDDSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD(5, 5, 0, this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD$default$4(), this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD$default$5(), this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD$default$6());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.test("Read data available only in write ahead log, not in block manager", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WriteAheadLogBackedBlockRDDSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD(5, 0, 5, this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD$default$4(), this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD$default$5(), this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD$default$6());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("Read data with partially available in block manager, and rest in write ahead log", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WriteAheadLogBackedBlockRDDSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD(5, 3, 2, this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD$default$4(), this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD$default$5(), this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD$default$6());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("Test isBlockValid skips block fetching from BlockManager", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WriteAheadLogBackedBlockRDDSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD(5, 5, 0, true, this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD$default$5(), this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD$default$6());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("Test whether RDD is valid after removing blocks from block manager", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WriteAheadLogBackedBlockRDDSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int x$4 = 5;
                int x$5 = 5;
                int x$6 = 5;
                boolean x$7 = true;
                boolean x$8 = this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD$default$4();
                boolean x$9 = this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD$default$6();
                this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD(x$4, x$5, x$6, x$8, x$7, x$9);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        this.test("Test storing of blocks recovered from write ahead log back into block manager", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WriteAheadLogBackedBlockRDDSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int x$10 = 5;
                int x$11 = 0;
                int x$12 = 5;
                boolean x$13 = true;
                boolean x$14 = this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD$default$4();
                boolean x$15 = this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD$default$5();
                this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD(x$10, x$11, x$12, x$14, x$15, x$13);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        this.test("read data in block manager and WAL with encryption on", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WriteAheadLogBackedBlockRDDSuite $outer;

            public final Object apply() {
                this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$stopSparkContext();
                try {
                    SparkConf testConf = this.$outer.conf().clone().set(package$.MODULE$.IO_ENCRYPTION_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$initSparkContext((Option<SparkConf>)new Some((Object)testConf));
                    this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD(5, 3, 2, this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD$default$4(), this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD$default$5(), this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$testRDD$default$6());
                    return BoxedUnit.UNIT;
                }
                finally {
                    this.$outer.org$apache$spark$streaming$rdd$WriteAheadLogBackedBlockRDDSuite$$stopSparkContext();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
    }
}

