/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.scheduler.HostTaskLocation;
import org.apache.spark.scheduler.TaskLocation;
import org.apache.spark.streaming.scheduler.RateTestReceiver;
import org.apache.spark.streaming.scheduler.RateTestReceiver$;
import org.apache.spark.streaming.scheduler.ReceiverSchedulingPolicy;
import org.apache.spark.streaming.scheduler.ReceiverSchedulingPolicySuite$;
import org.apache.spark.streaming.scheduler.ReceiverSchedulingPolicySuite$$anonfun$11$;
import org.apache.spark.streaming.scheduler.ReceiverSchedulingPolicySuite$$anonfun$15$;
import org.apache.spark.streaming.scheduler.ReceiverState$;
import org.apache.spark.streaming.scheduler.ReceiverTrackingInfo;
import org.apache.spark.streaming.scheduler.ReceiverTrackingInfo$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001}1A!\u0001\u0002\u0001\u001b\ti\"+Z2fSZ,'oU2iK\u0012,H.\u001b8h!>d\u0017nY=Tk&$XM\u0003\u0002\u0004\t\u0005I1o\u00195fIVdWM\u001d\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\r%\u0011\u0011C\u0002\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001b\u0002\r\u0001\u0005\u0004%\t!G\u0001\u0019e\u0016\u001cW-\u001b<feN\u001b\u0007.\u001a3vY&tw\rU8mS\u000eLX#\u0001\u000e\u0011\u0005YY\u0012B\u0001\u000f\u0003\u0005a\u0011VmY3jm\u0016\u00148k\u00195fIVd\u0017N\\4Q_2L7-\u001f\u0005\u0007=\u0001\u0001\u000b\u0011\u0002\u000e\u00023I,7-Z5wKJ\u001c6\r[3ek2Lgn\u001a)pY&\u001c\u0017\u0010\t")
public class ReceiverSchedulingPolicySuite
extends SparkFunSuite {
    private final ReceiverSchedulingPolicy receiverSchedulingPolicy = new ReceiverSchedulingPolicy();

    public ReceiverSchedulingPolicy receiverSchedulingPolicy() {
        return this.receiverSchedulingPolicy;
    }

    public ReceiverSchedulingPolicySuite() {
        this.test("rescheduleReceiver: empty executors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSchedulingPolicySuite $outer;

            public final Assertion apply() {
                Seq scheduledLocations = this.$outer.receiverSchedulingPolicy().rescheduleReceiver(0, (Option)None$.MODULE$, (Map)Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.empty());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(scheduledLocations);
                Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.empty();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
        this.test("rescheduleReceiver: receiver preferredLocation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSchedulingPolicySuite $outer;

            public final Assertion apply() {
                Seq executors = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutorCacheTaskLocation[]{new ExecutorCacheTaskLocation("host2", "2")}));
                scala.collection.immutable.Map receiverTrackingInfoMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new ReceiverTrackingInfo(0, ReceiverState$.MODULE$.INACTIVE(), (Option)None$.MODULE$, (Option)None$.MODULE$, ReceiverTrackingInfo$.MODULE$.apply$default$5(), ReceiverTrackingInfo$.MODULE$.apply$default$6(), ReceiverTrackingInfo$.MODULE$.apply$default$7()))}));
                Seq scheduledLocations = this.$outer.receiverSchedulingPolicy().rescheduleReceiver(0, (Option)new Some((Object)"host1"), (Map)receiverTrackingInfoMap, executors);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(scheduledLocations.toSet());
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{new HostTaskLocation("host1"), (Product)executors.apply(0)}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        this.test("rescheduleReceiver: return all idle executors if there are any idle executors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSchedulingPolicySuite $outer;

            public final Assertion apply() {
                IndexedSeq executors = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ExecutorCacheTaskLocation apply(int i) {
                        return new ExecutorCacheTaskLocation(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                scala.collection.immutable.Map receiverTrackingInfoMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new ReceiverTrackingInfo(0, ReceiverState$.MODULE$.ACTIVE(), (Option)None$.MODULE$, (Option)new Some(executors.apply(0)), ReceiverTrackingInfo$.MODULE$.apply$default$5(), ReceiverTrackingInfo$.MODULE$.apply$default$6(), ReceiverTrackingInfo$.MODULE$.apply$default$7()))}));
                Seq scheduledLocations = this.$outer.receiverSchedulingPolicy().rescheduleReceiver(1, (Option)None$.MODULE$, (Map)receiverTrackingInfoMap, (Seq)executors);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(scheduledLocations.toSet());
                Set $org_scalatest_assert_macro_right = ((TraversableOnce)executors.tail()).toSet();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        this.test("rescheduleReceiver: return all executors that have minimum weight if no idle executors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSchedulingPolicySuite $outer;

            public final Assertion apply() {
                Seq executors = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutorCacheTaskLocation[]{new ExecutorCacheTaskLocation("host1", "1"), new ExecutorCacheTaskLocation("host2", "2"), new ExecutorCacheTaskLocation("host3", "3"), new ExecutorCacheTaskLocation("host4", "4"), new ExecutorCacheTaskLocation("host5", "5")}));
                scala.collection.immutable.Map receiverTrackingInfoMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new ReceiverTrackingInfo(0, ReceiverState$.MODULE$.ACTIVE(), (Option)None$.MODULE$, (Option)new Some((Object)new ExecutorCacheTaskLocation("host1", "1")), ReceiverTrackingInfo$.MODULE$.apply$default$5(), ReceiverTrackingInfo$.MODULE$.apply$default$6(), ReceiverTrackingInfo$.MODULE$.apply$default$7())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new ReceiverTrackingInfo(1, ReceiverState$.MODULE$.SCHEDULED(), (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutorCacheTaskLocation[]{new ExecutorCacheTaskLocation("host2", "2"), new ExecutorCacheTaskLocation("host3", "3")}))), (Option)None$.MODULE$, ReceiverTrackingInfo$.MODULE$.apply$default$5(), ReceiverTrackingInfo$.MODULE$.apply$default$6(), ReceiverTrackingInfo$.MODULE$.apply$default$7())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ReceiverTrackingInfo(2, ReceiverState$.MODULE$.SCHEDULED(), (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutorCacheTaskLocation[]{new ExecutorCacheTaskLocation("host1", "1"), new ExecutorCacheTaskLocation("host3", "3")}))), (Option)None$.MODULE$, ReceiverTrackingInfo$.MODULE$.apply$default$5(), ReceiverTrackingInfo$.MODULE$.apply$default$6(), ReceiverTrackingInfo$.MODULE$.apply$default$7())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)new ReceiverTrackingInfo(4, ReceiverState$.MODULE$.SCHEDULED(), (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutorCacheTaskLocation[]{new ExecutorCacheTaskLocation("host4", "4"), new ExecutorCacheTaskLocation("host5", "5")}))), (Option)None$.MODULE$, ReceiverTrackingInfo$.MODULE$.apply$default$5(), ReceiverTrackingInfo$.MODULE$.apply$default$6(), ReceiverTrackingInfo$.MODULE$.apply$default$7()))}));
                Seq scheduledLocations = this.$outer.receiverSchedulingPolicy().rescheduleReceiver(4, (Option)None$.MODULE$, (Map)receiverTrackingInfoMap, executors);
                Set expectedScheduledLocations = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutorCacheTaskLocation[]{new ExecutorCacheTaskLocation("host2", "2"), new ExecutorCacheTaskLocation("host4", "4"), new ExecutorCacheTaskLocation("host5", "5")}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(scheduledLocations.toSet());
                Set $org_scalatest_assert_macro_right = expectedScheduledLocations;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("scheduleReceivers: schedule receivers evenly when there are more receivers than executors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSchedulingPolicySuite $outer;

            public final Assertion apply() {
                IndexedSeq receivers = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RateTestReceiver apply(int x$1) {
                        return new RateTestReceiver(x$1, RateTestReceiver$.MODULE$.$lessinit$greater$default$2());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                IndexedSeq executors = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ExecutorCacheTaskLocation apply(int executorId) {
                        return new ExecutorCacheTaskLocation("localhost", ((Object)BoxesRunTime.boxToInteger((int)executorId)).toString());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                Map scheduledLocations = this.$outer.receiverSchedulingPolicy().scheduleReceivers((Seq)receivers, (Seq)executors);
                HashMap numReceiversOnExecutor = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                scheduledLocations.foreach((Function1)new Serializable(this, numReceiversOnExecutor){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final HashMap numReceiversOnExecutor$1;

                    public final void apply(Tuple2<Object, Seq<TaskLocation>> x0$1) {
                        Tuple2<Object, Seq<TaskLocation>> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Seq locations;
                            Seq $org_scalatest_assert_macro_left = locations = (Seq)tuple2._2();
                            int $org_scalatest_assert_macro_right = 1;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                            this.$outer.org$apache$spark$streaming$scheduler$ReceiverSchedulingPolicySuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
                            TaskLocation $org_scalatest_assert_macro_left2 = (TaskLocation)locations.apply(0);
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.scheduler.ExecutorCacheTaskLocation", $org_scalatest_assert_macro_left2 instanceof ExecutorCacheTaskLocation, Prettifier$.MODULE$.default());
                            this.$outer.org$apache$spark$streaming$scheduler$ReceiverSchedulingPolicySuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
                            this.numReceiversOnExecutor$1.update(locations.apply(0), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.numReceiversOnExecutor$1.getOrElse(locations.apply(0), (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply() {
                                    return this.apply$mcI$sp();
                                }

                                public int apply$mcI$sp() {
                                    return 0;
                                }
                            })) + 1)));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.numReceiversOnExecutor$1 = numReceiversOnExecutor$1;
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(numReceiversOnExecutor);
                scala.collection.immutable.Map $org_scalatest_assert_macro_right = ((TraversableOnce)executors.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<ExecutorCacheTaskLocation, Object> apply(ExecutorCacheTaskLocation x$2) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x$2), (Object)BoxesRunTime.boxToInteger((int)2));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            }

            public /* synthetic */ ReceiverSchedulingPolicySuite org$apache$spark$streaming$scheduler$ReceiverSchedulingPolicySuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        this.test("scheduleReceivers: schedule receivers evenly when there are more executors than receivers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSchedulingPolicySuite $outer;

            public final Assertion apply() {
                IndexedSeq receivers = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RateTestReceiver apply(int x$3) {
                        return new RateTestReceiver(x$3, RateTestReceiver$.MODULE$.$lessinit$greater$default$2());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                IndexedSeq executors = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ExecutorCacheTaskLocation apply(int executorId) {
                        return new ExecutorCacheTaskLocation("localhost", ((Object)BoxesRunTime.boxToInteger((int)executorId)).toString());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                Map scheduledLocations = this.$outer.receiverSchedulingPolicy().scheduleReceivers((Seq)receivers, (Seq)executors);
                HashMap numReceiversOnExecutor = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                scheduledLocations.foreach((Function1)new Serializable(this, numReceiversOnExecutor){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$11 $outer;
                    public final HashMap numReceiversOnExecutor$2;

                    public final void apply(Tuple2<Object, Seq<TaskLocation>> x0$2) {
                        Tuple2<Object, Seq<TaskLocation>> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Seq locations;
                            Seq $org_scalatest_assert_macro_left = locations = (Seq)tuple2._2();
                            int $org_scalatest_assert_macro_right = 2;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                            this.$outer.org$apache$spark$streaming$scheduler$ReceiverSchedulingPolicySuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
                            locations.foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$11$$anonfun$apply$5 $outer;

                                public final void apply(TaskLocation l) {
                                    TaskLocation $org_scalatest_assert_macro_left = l;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.scheduler.ExecutorCacheTaskLocation", $org_scalatest_assert_macro_left instanceof ExecutorCacheTaskLocation, Prettifier$.MODULE$.default());
                                    this.$outer.org$apache$spark$streaming$scheduler$ReceiverSchedulingPolicySuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$scheduler$ReceiverSchedulingPolicySuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
                                    this.$outer.numReceiversOnExecutor$2.update((Object)l, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.$outer.numReceiversOnExecutor$2.getOrElse((Object)l, (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply() {
                                            return this.apply$mcI$sp();
                                        }

                                        public int apply$mcI$sp() {
                                            return 0;
                                        }
                                    })) + 1)));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }

                    public /* synthetic */ $anonfun$11 org$apache$spark$streaming$scheduler$ReceiverSchedulingPolicySuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.numReceiversOnExecutor$2 = numReceiversOnExecutor$2;
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(numReceiversOnExecutor);
                scala.collection.immutable.Map $org_scalatest_assert_macro_right = ((TraversableOnce)executors.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<ExecutorCacheTaskLocation, Object> apply(ExecutorCacheTaskLocation x$4) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x$4), (Object)BoxesRunTime.boxToInteger((int)1));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            }

            public /* synthetic */ ReceiverSchedulingPolicySuite org$apache$spark$streaming$scheduler$ReceiverSchedulingPolicySuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        this.test("scheduleReceivers: schedule receivers evenly when the preferredLocations are even", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSchedulingPolicySuite $outer;

            public final Assertion apply() {
                IndexedSeq receivers = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RateTestReceiver apply(int x$5) {
                        return new RateTestReceiver(x$5, RateTestReceiver$.MODULE$.$lessinit$greater$default$2());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(3), 6).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RateTestReceiver apply(int x$6) {
                        return new RateTestReceiver(x$6, (Option<String>)new Some((Object)"localhost"));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom());
                IndexedSeq executors = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ExecutorCacheTaskLocation apply(int executorId) {
                        return new ExecutorCacheTaskLocation("localhost", ((Object)BoxesRunTime.boxToInteger((int)executorId)).toString());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(3), 6).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ExecutorCacheTaskLocation apply(int executorId) {
                        return new ExecutorCacheTaskLocation("localhost2", ((Object)BoxesRunTime.boxToInteger((int)executorId)).toString());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom());
                Map scheduledLocations = this.$outer.receiverSchedulingPolicy().scheduleReceivers((Seq)receivers, (Seq)executors);
                HashMap numReceiversOnExecutor = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                scheduledLocations.foreach((Function1)new Serializable(this, numReceiversOnExecutor){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$15 $outer;
                    public final HashMap numReceiversOnExecutor$3;

                    public final void apply(Tuple2<Object, Seq<TaskLocation>> x0$3) {
                        Tuple2<Object, Seq<TaskLocation>> tuple2 = x0$3;
                        if (tuple2 != null) {
                            Seq executors;
                            Seq $org_scalatest_assert_macro_left = executors = (Seq)tuple2._2();
                            int $org_scalatest_assert_macro_right = 1;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                            this.$outer.org$apache$spark$streaming$scheduler$ReceiverSchedulingPolicySuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
                            executors.foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$15$$anonfun$apply$7 $outer;

                                public final void apply(TaskLocation l) {
                                    TaskLocation $org_scalatest_assert_macro_left = l;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.scheduler.ExecutorCacheTaskLocation", $org_scalatest_assert_macro_left instanceof ExecutorCacheTaskLocation, Prettifier$.MODULE$.default());
                                    this.$outer.org$apache$spark$streaming$scheduler$ReceiverSchedulingPolicySuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$scheduler$ReceiverSchedulingPolicySuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
                                    this.$outer.numReceiversOnExecutor$3.update((Object)l, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.$outer.numReceiversOnExecutor$3.getOrElse((Object)l, (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply() {
                                            return this.apply$mcI$sp();
                                        }

                                        public int apply$mcI$sp() {
                                            return 0;
                                        }
                                    })) + 1)));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }

                    public /* synthetic */ $anonfun$15 org$apache$spark$streaming$scheduler$ReceiverSchedulingPolicySuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.numReceiversOnExecutor$3 = numReceiversOnExecutor$3;
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(numReceiversOnExecutor);
                scala.collection.immutable.Map $org_scalatest_assert_macro_right = ((TraversableOnce)executors.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<ExecutorCacheTaskLocation, Object> apply(ExecutorCacheTaskLocation x$7) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x$7), (Object)BoxesRunTime.boxToInteger((int)1));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
                Iterable executorsForReceiversWithPreferredLocation = (Iterable)((TraversableLike)scheduledLocations.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, Seq<TaskLocation>> x0$4) {
                        Tuple2<Object, Seq<TaskLocation>> tuple2 = x0$4;
                        if (tuple2 != null) {
                            int receiverId = tuple2._1$mcI$sp();
                            boolean bl = receiverId >= 3;
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                })).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<TaskLocation> apply(Tuple2<Object, Seq<TaskLocation>> x$8) {
                        return (Seq)x$8._2();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(executorsForReceiversWithPreferredLocation.toSet());
                Set $org_scalatest_assert_macro_right2 = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ExecutorCacheTaskLocation apply(int executorId) {
                        return new ExecutorCacheTaskLocation("localhost", ((Object)BoxesRunTime.boxToInteger((int)executorId)).toString());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toSet();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
            }

            public /* synthetic */ ReceiverSchedulingPolicySuite org$apache$spark$streaming$scheduler$ReceiverSchedulingPolicySuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        this.test("scheduleReceivers: return empty if no receiver", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSchedulingPolicySuite $outer;

            public final Assertion apply() {
                Map scheduledLocations;
                Map $org_scalatest_assert_macro_left = scheduledLocations = this.$outer.receiverSchedulingPolicy().scheduleReceivers((Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutorCacheTaskLocation[]{new ExecutorCacheTaskLocation("localhost", "1")})));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        this.test("scheduleReceivers: return empty scheduled executors if no executors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSchedulingPolicySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndexedSeq receivers = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RateTestReceiver apply(int x$9) {
                        return new RateTestReceiver(x$9, RateTestReceiver$.MODULE$.$lessinit$greater$default$2());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                Map scheduledLocations = this.$outer.receiverSchedulingPolicy().scheduleReceivers((Seq)receivers, (Seq)Seq$.MODULE$.empty());
                scheduledLocations.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final Assertion apply(Tuple2<Object, Seq<TaskLocation>> x0$5) {
                        Tuple2<Object, Seq<TaskLocation>> tuple2 = x0$5;
                        if (tuple2 != null) {
                            Seq executors;
                            Seq $org_scalatest_assert_macro_left = executors = (Seq)tuple2._2();
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                            Assertion assertion = this.$outer.org$apache$spark$streaming$scheduler$ReceiverSchedulingPolicySuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
                            return assertion;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ReceiverSchedulingPolicySuite org$apache$spark$streaming$scheduler$ReceiverSchedulingPolicySuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
    }
}

