/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.streaming.util.CommonWriteAheadLogTests;
import org.apache.spark.streaming.util.FileBasedWriteAheadLog$;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogRandomReader;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogReader;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogSegment;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogSuite$;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogSuite$$anonfun$18$;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogWriter;
import org.apache.spark.streaming.util.WriteAheadLogSuite$;
import org.apache.spark.util.CompletionIterator;
import org.apache.spark.util.ThreadUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.time.Span$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.forkjoin.ForkJoinPool;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.VolatileObjectRef;

@ScalaSignature(bytes="\u0006\u0001Y1A!\u0001\u0002\u0001\u001b\tYb)\u001b7f\u0005\u0006\u001cX\rZ,sSR,\u0017\t[3bI2{wmU;ji\u0016T!a\u0001\u0003\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u0019\u0007>lWn\u001c8Xe&$X-\u00115fC\u0012dun\u001a+fgR\u001c\b\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\ty\u0001\u0001")
public class FileBasedWriteAheadLogSuite
extends CommonWriteAheadLogTests {
    public FileBasedWriteAheadLogSuite() {
        super(false, false, "FileBasedWriteAheadLog");
        this.test("FileBasedWriteAheadLog - seqToParIterator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileBasedWriteAheadLogSuite $outer;

            /*
             * WARNING - void declaration
             */
            public final Object apply() {
                Assertion assertion;
                int numThreads = 8;
                ForkJoinPool fpool = ThreadUtils$.MODULE$.newForkJoinPool("wal-test-thread-pool", numThreads);
                ExecutionContextExecutorService executionContext = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)fpool);
                try {
                    CountDownLatch latch = new CountDownLatch(1);
                    Range.Inclusive testSeq = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 1000);
                    public class Org_apache_spark_streaming_util_FileBasedWriteAheadLogSuite$$anonfun$18$GetMaxCounter$1 {
                        private final AtomicInteger value;
                        private volatile int max;
                        public final /* synthetic */ $anonfun$18 $outer;

                        private AtomicInteger value() {
                            return this.value;
                        }

                        private int max() {
                            return this.max;
                        }

                        private void max_$eq(int x$1) {
                            this.max = x$1;
                        }

                        public synchronized void increment() {
                            int atInstant = this.value().incrementAndGet();
                            if (atInstant > this.max()) {
                                this.max_$eq(atInstant);
                            }
                        }

                        public void decrement() {
                            Org_apache_spark_streaming_util_FileBasedWriteAheadLogSuite$$anonfun$18$GetMaxCounter$1 var1_1 = this;
                            synchronized (var1_1) {
                                BoxesRunTime.boxToInteger((int)this.value().decrementAndGet());
                                return;
                            }
                        }

                        public synchronized int get() {
                            return this.value().get();
                        }

                        public synchronized int getMax() {
                            return this.max();
                        }

                        public /* synthetic */ $anonfun$18 org$apache$spark$streaming$util$FileBasedWriteAheadLogSuite$$anonfun$GetMaxCounter$$$outer() {
                            return this.$outer;
                        }

                        public Org_apache_spark_streaming_util_FileBasedWriteAheadLogSuite$$anonfun$18$GetMaxCounter$1($anonfun$18 $outer) {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.value = new AtomicInteger();
                            this.max = 0;
                        }
                    }
                    Org_apache_spark_streaming_util_FileBasedWriteAheadLogSuite$$anonfun$18$GetMaxCounter$1 counter = new Org_apache_spark_streaming_util_FileBasedWriteAheadLogSuite$$anonfun$18$GetMaxCounter$1(this);
                    VolatileObjectRef collected = VolatileObjectRef.create((Object)Nil$.MODULE$);
                    Thread t = new Thread(this, executionContext, latch, testSeq, counter, collected){
                        private final /* synthetic */ $anonfun$18 $outer;
                        private final ExecutionContextExecutorService executionContext$1;
                        public final CountDownLatch latch$1;
                        private final Range.Inclusive testSeq$1;
                        public final Org_apache_spark_streaming_util_FileBasedWriteAheadLogSuite$$anonfun$18$GetMaxCounter$1 counter$1;
                        private final VolatileObjectRef collected$1;

                        public void run() {
                            Iterator iterator = FileBasedWriteAheadLog$.MODULE$.seqToParIterator((ExecutionContext)this.executionContext$1, (Seq)this.testSeq$1, (Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$18$$anon$2 $outer;

                                public final Iterator<Object> apply(int value) {
                                    return this.$outer.org$apache$spark$streaming$util$FileBasedWriteAheadLogSuite$$anonfun$$anon$$$outer().org$apache$spark$streaming$util$FileBasedWriteAheadLogSuite$$anonfun$$handle$1(value, this.$outer.latch$1, this.$outer.counter$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            this.collected$1.elem = iterator.toSeq();
                        }

                        public /* synthetic */ $anonfun$18 org$apache$spark$streaming$util$FileBasedWriteAheadLogSuite$$anonfun$$anon$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.executionContext$1 = executionContext$1;
                            this.latch$1 = latch$1;
                            this.testSeq$1 = testSeq$1;
                            this.counter$1 = counter$1;
                            this.collected$1 = collected$1;
                        }
                    };
                    t.start();
                    Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds())), (Function0)new Serializable(this, counter){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$18 $outer;
                        private final Org_apache_spark_streaming_util_FileBasedWriteAheadLogSuite$$anonfun$18$GetMaxCounter$1 counter$1;

                        public final Assertion apply() {
                            int $org_scalatest_assert_macro_left = this.counter$1.getMax();
                            int $org_scalatest_assert_macro_right = 1;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                            return this.$outer.org$apache$spark$streaming$util$FileBasedWriteAheadLogSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.counter$1 = counter$1;
                        }
                    }, Eventually$.MODULE$.patienceConfig(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
                    latch.countDown();
                    t.join(10000L);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer((Seq)collected.elem);
                    Range.Inclusive $org_scalatest_assert_macro_right = testSeq;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
                    int $org_scalatest_assert_macro_left2 = counter.getMax();
                    int $org_scalatest_assert_macro_right2 = numThreads;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 <= $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                    assertion = this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
                }
                catch (Throwable throwable) {
                    void var2_2;
                    var2_2.shutdownNow();
                    throw throwable;
                }
                fpool.shutdownNow();
                return assertion;
            }

            public /* synthetic */ FileBasedWriteAheadLogSuite org$apache$spark$streaming$util$FileBasedWriteAheadLogSuite$$anonfun$$$outer() {
                return this.$outer;
            }

            public final Iterator org$apache$spark$streaming$util$FileBasedWriteAheadLogSuite$$anonfun$$handle$1(int value, CountDownLatch latch$1, $anonfun$18$GetMaxCounter$1 counter$1) {
                return new CompletionIterator<Object, Iterator<Object>>(this, latch$1, counter$1, value){
                    private final Org_apache_spark_streaming_util_FileBasedWriteAheadLogSuite$$anonfun$18$GetMaxCounter$1 counter$1;

                    public void completion() {
                        this.counter$1.decrement();
                    }
                    {
                        this.counter$1 = counter$1;
                        super(package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{value$1})));
                        counter$1.increment();
                        latch$1.await(10L, TimeUnit.SECONDS);
                    }
                };
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
        this.test("FileBasedWriteAheadLogWriter - writing data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileBasedWriteAheadLogSuite $outer;

            public final Assertion apply() {
                Seq<String> dataToWrite = WriteAheadLogSuite$.MODULE$.generateRandomData();
                Seq<FileBasedWriteAheadLogSegment> segments = WriteAheadLogSuite$.MODULE$.writeDataUsingWriter(this.$outer.testFile(), dataToWrite);
                Seq<String> writtenData = WriteAheadLogSuite$.MODULE$.readDataManually(segments);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(writtenData);
                Seq<String> $org_scalatest_assert_macro_right = dataToWrite;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
        this.test("FileBasedWriteAheadLogWriter - syncing of data by writing and reading immediately", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileBasedWriteAheadLogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq<String> dataToWrite = WriteAheadLogSuite$.MODULE$.generateRandomData();
                FileBasedWriteAheadLogWriter writer = new FileBasedWriteAheadLogWriter(this.$outer.testFile(), this.$outer.hadoopConf());
                dataToWrite.foreach((Function1)new Serializable(this, writer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;
                    private final FileBasedWriteAheadLogWriter writer$1;

                    public final Assertion apply(String data) {
                        FileBasedWriteAheadLogSegment segment = this.writer$1.write(WriteAheadLogSuite$.MODULE$.stringToByteBuffer(data));
                        String dataRead = (String)WriteAheadLogSuite$.MODULE$.readDataManually((Seq<FileBasedWriteAheadLogSegment>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileBasedWriteAheadLogSegment[]{segment})))).head();
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$util$FileBasedWriteAheadLogSuite$$anonfun$$$outer().convertToEqualizer(data);
                        String $org_scalatest_assert_macro_right = dataRead;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return this.$outer.org$apache$spark$streaming$util$FileBasedWriteAheadLogSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.writer$1 = writer$1;
                    }
                });
                writer.close();
            }

            public /* synthetic */ FileBasedWriteAheadLogSuite org$apache$spark$streaming$util$FileBasedWriteAheadLogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
        this.test("FileBasedWriteAheadLogReader - sequentially reading data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileBasedWriteAheadLogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq<String> writtenData = WriteAheadLogSuite$.MODULE$.generateRandomData();
                WriteAheadLogSuite$.MODULE$.writeDataManually(writtenData, this.$outer.testFile(), false);
                FileBasedWriteAheadLogReader reader = new FileBasedWriteAheadLogReader(this.$outer.testFile(), this.$outer.hadoopConf());
                Seq readData = (Seq)reader.toSeq().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(ByteBuffer byteBuffer) {
                        return WriteAheadLogSuite$.MODULE$.byteBufferToString(byteBuffer);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(readData);
                Seq<String> $org_scalatest_assert_macro_right = writtenData;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)reader.hasNext()));
                boolean $org_scalatest_assert_macro_right2 = false;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
                this.$outer.intercept((Function0)new Serializable(this, reader){
                    public static final long serialVersionUID = 0L;
                    private final FileBasedWriteAheadLogReader reader$1;

                    public final ByteBuffer apply() {
                        return this.reader$1.next();
                    }
                    {
                        this.reader$1 = reader$1;
                    }
                }, ClassTag$.MODULE$.apply(Exception.class), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
                reader.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
        this.test("FileBasedWriteAheadLogReader - sequentially reading data written with writer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileBasedWriteAheadLogSuite $outer;

            public final Assertion apply() {
                Seq<String> dataToWrite = WriteAheadLogSuite$.MODULE$.generateRandomData();
                WriteAheadLogSuite$.MODULE$.writeDataUsingWriter(this.$outer.testFile(), dataToWrite);
                Seq<String> readData = WriteAheadLogSuite$.MODULE$.readDataUsingReader(this.$outer.testFile());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(readData);
                Seq<String> $org_scalatest_assert_macro_right = dataToWrite;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 317));
        this.test("FileBasedWriteAheadLogReader - reading data written with writer after corrupted write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileBasedWriteAheadLogSuite $outer;

            public final Assertion apply() {
                Seq<String> dataToWrite = WriteAheadLogSuite$.MODULE$.generateRandomData();
                WriteAheadLogSuite$.MODULE$.writeDataUsingWriter(this.$outer.testFile(), dataToWrite);
                long fileLength = new File(this.$outer.testFile()).length();
                FileWriter fw = new FileWriter(this.$outer.testFile(), true);
                fw.append("This line appended to file!");
                fw.close();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(WriteAheadLogSuite$.MODULE$.readDataUsingReader(this.$outer.testFile()));
                Seq<String> $org_scalatest_assert_macro_right = dataToWrite;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
                FileChannel raf = new FileOutputStream(this.$outer.testFile(), true).getChannel();
                raf.truncate(fileLength - 1L);
                raf.close();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(WriteAheadLogSuite$.MODULE$.readDataUsingReader(this.$outer.testFile()));
                Seq $org_scalatest_assert_macro_right2 = (Seq)dataToWrite.dropRight(1);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
        this.test("FileBasedWriteAheadLogReader - handles errors when file doesn't exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileBasedWriteAheadLogSuite $outer;

            public final Assertion apply() {
                Seq<String> dataToWrite = WriteAheadLogSuite$.MODULE$.generateRandomData();
                WriteAheadLogSuite$.MODULE$.writeDataUsingWriter(this.$outer.testFile(), dataToWrite);
                File tFile = new File(this.$outer.testFile());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(tFile.exists(), "tFile.exists()", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(WriteAheadLogSuite$.MODULE$.readDataUsingReader(this.$outer.testFile()));
                Seq<String> $org_scalatest_assert_macro_right = dataToWrite;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
                tFile.delete();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(tFile.exists(), "tFile.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
                FileBasedWriteAheadLogReader reader = new FileBasedWriteAheadLogReader(this.$outer.testFile(), this.$outer.hadoopConf());
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(reader.hasNext(), "reader.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
                reader.close();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(WriteAheadLogSuite$.MODULE$.readDataUsingReader(this.$outer.testFile()));
                Nil$ $org_scalatest_assert_macro_right2 = Nil$.MODULE$;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
        this.test("FileBasedWriteAheadLogRandomReader - reading data using random reader", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileBasedWriteAheadLogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq<String> writtenData = WriteAheadLogSuite$.MODULE$.generateRandomData();
                Seq<FileBasedWriteAheadLogSegment> segments = WriteAheadLogSuite$.MODULE$.writeDataManually(writtenData, this.$outer.testFile(), false);
                Iterator writtenDataAndSegments = TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)((SeqLike)writtenData.zip(segments, Seq$.MODULE$.canBuildFrom())).toSeq().permutations().take(10), (Function1)Predef$.MODULE$.$conforms()).flatten();
                FileBasedWriteAheadLogRandomReader reader = new FileBasedWriteAheadLogRandomReader(this.$outer.testFile(), this.$outer.hadoopConf());
                writtenDataAndSegments.foreach((Function1)new Serializable(this, reader){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    private final FileBasedWriteAheadLogRandomReader reader$2;

                    public final Assertion apply(Tuple2<String, FileBasedWriteAheadLogSegment> x0$1) {
                        Tuple2<String, FileBasedWriteAheadLogSegment> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String data = (String)tuple2._1();
                            FileBasedWriteAheadLogSegment segment = (FileBasedWriteAheadLogSegment)tuple2._2();
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$util$FileBasedWriteAheadLogSuite$$anonfun$$$outer().convertToEqualizer(data);
                            String $org_scalatest_assert_macro_right = WriteAheadLogSuite$.MODULE$.byteBufferToString(this.reader$2.read(segment));
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                            Assertion assertion = this.$outer.org$apache$spark$streaming$util$FileBasedWriteAheadLogSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
                            return assertion;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.reader$2 = reader$2;
                    }
                });
                reader.close();
            }

            public /* synthetic */ FileBasedWriteAheadLogSuite org$apache$spark$streaming$util$FileBasedWriteAheadLogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367));
        this.test("FileBasedWriteAheadLogRandomReader- reading data using random reader written with writer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileBasedWriteAheadLogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq<String> data = WriteAheadLogSuite$.MODULE$.generateRandomData();
                Seq<FileBasedWriteAheadLogSegment> segments = WriteAheadLogSuite$.MODULE$.writeDataUsingWriter(this.$outer.testFile(), data);
                Iterator dataAndSegments = TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)((SeqLike)data.zip(segments, Seq$.MODULE$.canBuildFrom())).toSeq().permutations().take(10), (Function1)Predef$.MODULE$.$conforms()).flatten();
                FileBasedWriteAheadLogRandomReader reader = new FileBasedWriteAheadLogRandomReader(this.$outer.testFile(), this.$outer.hadoopConf());
                dataAndSegments.foreach((Function1)new Serializable(this, reader){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final FileBasedWriteAheadLogRandomReader reader$3;

                    public final Assertion apply(Tuple2<String, FileBasedWriteAheadLogSegment> x0$2) {
                        Tuple2<String, FileBasedWriteAheadLogSegment> tuple2 = x0$2;
                        if (tuple2 != null) {
                            String data = (String)tuple2._1();
                            FileBasedWriteAheadLogSegment segment = (FileBasedWriteAheadLogSegment)tuple2._2();
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$util$FileBasedWriteAheadLogSuite$$anonfun$$$outer().convertToEqualizer(data);
                            String $org_scalatest_assert_macro_right = WriteAheadLogSuite$.MODULE$.byteBufferToString(this.reader$3.read(segment));
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                            Assertion assertion = this.$outer.org$apache$spark$streaming$util$FileBasedWriteAheadLogSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
                            return assertion;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.reader$3 = reader$3;
                    }
                });
                reader.close();
            }

            public /* synthetic */ FileBasedWriteAheadLogSuite org$apache$spark$streaming$util$FileBasedWriteAheadLogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
    }
}

