/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.streaming;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.Optional;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.Function3;
import org.apache.spark.api.java.function.Function4;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Durations;
import org.apache.spark.streaming.JavaTestUtils;
import org.apache.spark.streaming.LocalJavaStreamingContext;
import org.apache.spark.streaming.StateSpec;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaMapWithStateDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.junit.Assert;
import org.junit.Test;
import org.spark_project.guava.collect.Sets;
import scala.Tuple2;

public class Java8APISuite
extends LocalJavaStreamingContext
implements Serializable {
    List<List<Tuple2<String, String>>> stringStringKVStream = Arrays.asList(Arrays.asList(new Tuple2((Object)"california", (Object)"dodgers"), new Tuple2((Object)"california", (Object)"giants"), new Tuple2((Object)"new york", (Object)"yankees"), new Tuple2((Object)"new york", (Object)"mets")), Arrays.asList(new Tuple2((Object)"california", (Object)"sharks"), new Tuple2((Object)"california", (Object)"ducks"), new Tuple2((Object)"new york", (Object)"rangers"), new Tuple2((Object)"new york", (Object)"islanders")));
    List<List<Tuple2<String, Integer>>> stringIntKVStream = Arrays.asList(Arrays.asList(new Tuple2((Object)"california", (Object)1), new Tuple2((Object)"california", (Object)3), new Tuple2((Object)"new york", (Object)4), new Tuple2((Object)"new york", (Object)1)), Arrays.asList(new Tuple2((Object)"california", (Object)5), new Tuple2((Object)"california", (Object)5), new Tuple2((Object)"new york", (Object)3), new Tuple2((Object)"new york", (Object)1)));

    @Test
    public void testMap() {
        List inputData = Arrays.asList(Arrays.asList("hello", "world"), Arrays.asList("goodnight", "moon"));
        List expected = Arrays.asList(Arrays.asList(5, 5), Arrays.asList(9, 4));
        JavaDStream stream = JavaTestUtils.attachTestInputStream(this.ssc, inputData, 1);
        JavaDStream letterCount = stream.map(String::length);
        JavaTestUtils.attachTestOutputStream(letterCount);
        List result = JavaTestUtils.runStreams(this.ssc, 2, 2);
        Java8APISuite.assertOrderInvariantEquals(expected, result);
    }

    @Test
    public void testFilter() {
        List inputData = Arrays.asList(Arrays.asList("giants", "dodgers"), Arrays.asList("yankees", "red sox"));
        List expected = Arrays.asList(Arrays.asList("giants"), Arrays.asList("yankees"));
        JavaDStream stream = JavaTestUtils.attachTestInputStream(this.ssc, inputData, 1);
        JavaDStream filtered = stream.filter((Function & Serializable)s -> s.contains("a"));
        JavaTestUtils.attachTestOutputStream(filtered);
        List result = JavaTestUtils.runStreams(this.ssc, 2, 2);
        Java8APISuite.assertOrderInvariantEquals(expected, result);
    }

    @Test
    public void testMapPartitions() {
        List inputData = Arrays.asList(Arrays.asList("giants", "dodgers"), Arrays.asList("yankees", "red sox"));
        List<List> expected = Arrays.asList(Arrays.asList("GIANTSDODGERS"), Arrays.asList("YANKEESRED SOX"));
        JavaDStream stream = JavaTestUtils.attachTestInputStream(this.ssc, inputData, 1);
        JavaDStream mapped = stream.mapPartitions((FlatMapFunction & Serializable)in -> {
            String out = "";
            while (in.hasNext()) {
                out = out + ((String)in.next()).toUpperCase(Locale.ROOT);
            }
            return Arrays.asList(out).iterator();
        });
        JavaTestUtils.attachTestOutputStream(mapped);
        List result = JavaTestUtils.runStreams(this.ssc, 2, 2);
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testReduce() {
        List inputData = Arrays.asList(Arrays.asList(1, 2, 3), Arrays.asList(4, 5, 6), Arrays.asList(7, 8, 9));
        List<List> expected = Arrays.asList(Arrays.asList(6), Arrays.asList(15), Arrays.asList(24));
        JavaDStream stream = JavaTestUtils.attachTestInputStream(this.ssc, inputData, 1);
        JavaDStream reduced = stream.reduce((Function2 & Serializable)(x, y) -> x + y);
        JavaTestUtils.attachTestOutputStream(reduced);
        List result = JavaTestUtils.runStreams(this.ssc, 3, 3);
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testReduceByWindow() {
        List inputData = Arrays.asList(Arrays.asList(1, 2, 3), Arrays.asList(4, 5, 6), Arrays.asList(7, 8, 9));
        List<List> expected = Arrays.asList(Arrays.asList(6), Arrays.asList(21), Arrays.asList(39), Arrays.asList(24));
        JavaDStream stream = JavaTestUtils.attachTestInputStream(this.ssc, inputData, 1);
        JavaDStream reducedWindowed = stream.reduceByWindow((Function2 & Serializable)(x, y) -> x + y, (Function2 & Serializable)(x, y) -> x - y, new Duration(2000L), new Duration(1000L));
        JavaTestUtils.attachTestOutputStream(reducedWindowed);
        List result = JavaTestUtils.runStreams(this.ssc, 4, 4);
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testTransform() {
        List inputData = Arrays.asList(Arrays.asList(1, 2, 3), Arrays.asList(4, 5, 6), Arrays.asList(7, 8, 9));
        List expected = Arrays.asList(Arrays.asList(3, 4, 5), Arrays.asList(6, 7, 8), Arrays.asList(9, 10, 11));
        JavaDStream stream = JavaTestUtils.attachTestInputStream(this.ssc, inputData, 1);
        JavaDStream transformed = stream.transform((Function & Serializable)in -> in.map((Function & Serializable)i -> i + 2));
        JavaTestUtils.attachTestOutputStream(transformed);
        List result = JavaTestUtils.runStreams(this.ssc, 3, 3);
        Java8APISuite.assertOrderInvariantEquals(expected, result);
    }

    @Test
    public void testVariousTransform() {
        List inputData = Arrays.asList(Arrays.asList(1));
        JavaDStream stream = JavaTestUtils.attachTestInputStream(this.ssc, inputData, 1);
        List pairInputData = Arrays.asList(Arrays.asList(new Tuple2((Object)"x", (Object)1)));
        JavaPairDStream pairStream = JavaPairDStream.fromJavaDStream(JavaTestUtils.attachTestInputStream(this.ssc, pairInputData, 1));
        JavaDStream transformed1 = stream.transform((Function & Serializable)in -> null);
        JavaDStream transformed2 = stream.transform((Function2 & Serializable)(x, time) -> null);
        JavaPairDStream transformed3 = stream.transformToPair((Function & Serializable)x -> null);
        JavaPairDStream transformed4 = stream.transformToPair((Function2 & Serializable)(x, time) -> null);
        JavaDStream pairTransformed1 = pairStream.transform((Function & Serializable)x -> null);
        JavaDStream pairTransformed2 = pairStream.transform((Function2 & Serializable)(x, time) -> null);
        JavaPairDStream pairTransformed3 = pairStream.transformToPair((Function & Serializable)x -> null);
        JavaPairDStream pairTransformed4 = pairStream.transformToPair((Function2 & Serializable)(x, time) -> null);
    }

    @Test
    public void testTransformWith() {
        List stringStringKVStream1 = Arrays.asList(Arrays.asList(new Tuple2((Object)"california", (Object)"dodgers"), new Tuple2((Object)"new york", (Object)"yankees")), Arrays.asList(new Tuple2((Object)"california", (Object)"sharks"), new Tuple2((Object)"new york", (Object)"rangers")));
        List stringStringKVStream2 = Arrays.asList(Arrays.asList(new Tuple2((Object)"california", (Object)"giants"), new Tuple2((Object)"new york", (Object)"mets")), Arrays.asList(new Tuple2((Object)"california", (Object)"ducks"), new Tuple2((Object)"new york", (Object)"islanders")));
        List<Set> expected = Arrays.asList(Sets.newHashSet((Object[])new Tuple2[]{new Tuple2((Object)"california", (Object)new Tuple2((Object)"dodgers", (Object)"giants")), new Tuple2((Object)"new york", (Object)new Tuple2((Object)"yankees", (Object)"mets"))}), Sets.newHashSet((Object[])new Tuple2[]{new Tuple2((Object)"california", (Object)new Tuple2((Object)"sharks", (Object)"ducks")), new Tuple2((Object)"new york", (Object)new Tuple2((Object)"rangers", (Object)"islanders"))}));
        JavaDStream stream1 = JavaTestUtils.attachTestInputStream(this.ssc, stringStringKVStream1, 1);
        JavaPairDStream pairStream1 = JavaPairDStream.fromJavaDStream(stream1);
        JavaDStream stream2 = JavaTestUtils.attachTestInputStream(this.ssc, stringStringKVStream2, 1);
        JavaPairDStream pairStream2 = JavaPairDStream.fromJavaDStream(stream2);
        JavaPairDStream joined = pairStream1.transformWithToPair(pairStream2, (Function3 & Serializable)(x, y, z) -> x.join(y));
        JavaTestUtils.attachTestOutputStream(joined);
        List result = JavaTestUtils.runStreams(this.ssc, 2, 2);
        ArrayList<HashSet> unorderedResult = new ArrayList<HashSet>();
        for (List res : result) {
            unorderedResult.add(Sets.newHashSet(res));
        }
        Assert.assertEquals(expected, unorderedResult);
    }

    @Test
    public void testVariousTransformWith() {
        List inputData1 = Arrays.asList(Arrays.asList(1));
        List inputData2 = Arrays.asList(Arrays.asList("x"));
        JavaDStream stream1 = JavaTestUtils.attachTestInputStream(this.ssc, inputData1, 1);
        JavaDStream stream2 = JavaTestUtils.attachTestInputStream(this.ssc, inputData2, 1);
        List pairInputData1 = Arrays.asList(Arrays.asList(new Tuple2((Object)"x", (Object)1)));
        List pairInputData2 = Arrays.asList(Arrays.asList(new Tuple2((Object)1.0, (Object)Character.valueOf('x'))));
        JavaPairDStream pairStream1 = JavaPairDStream.fromJavaDStream(JavaTestUtils.attachTestInputStream(this.ssc, pairInputData1, 1));
        JavaPairDStream pairStream2 = JavaPairDStream.fromJavaDStream(JavaTestUtils.attachTestInputStream(this.ssc, pairInputData2, 1));
        JavaDStream transformed1 = stream1.transformWith(stream2, (Function3 & Serializable)(x, y, z) -> null);
        JavaDStream transformed2 = stream1.transformWith(pairStream1, (Function3 & Serializable)(x, y, z) -> null);
        JavaPairDStream transformed3 = stream1.transformWithToPair(stream2, (Function3 & Serializable)(x, y, z) -> null);
        JavaPairDStream transformed4 = stream1.transformWithToPair(pairStream1, (Function3 & Serializable)(x, y, z) -> null);
        JavaDStream pairTransformed1 = pairStream1.transformWith(stream2, (Function3 & Serializable)(x, y, z) -> null);
        JavaDStream pairTransformed2_ = pairStream1.transformWith(pairStream1, (Function3 & Serializable)(x, y, z) -> null);
        JavaPairDStream pairTransformed3 = pairStream1.transformWithToPair(stream2, (Function3 & Serializable)(x, y, z) -> null);
        JavaPairDStream pairTransformed4 = pairStream1.transformWithToPair(pairStream2, (Function3 & Serializable)(x, y, z) -> null);
    }

    @Test
    public void testStreamingContextTransform() {
        List stream1input = Arrays.asList(Arrays.asList(1), Arrays.asList(2));
        List stream2input = Arrays.asList(Arrays.asList(3), Arrays.asList(4));
        List pairStream1input = Arrays.asList(Arrays.asList(new Tuple2((Object)1, (Object)"x")), Arrays.asList(new Tuple2((Object)2, (Object)"y")));
        List<List> expected = Arrays.asList(Arrays.asList(new Tuple2((Object)1, (Object)new Tuple2((Object)1, (Object)"x"))), Arrays.asList(new Tuple2((Object)2, (Object)new Tuple2((Object)2, (Object)"y"))));
        JavaDStream stream1 = JavaTestUtils.attachTestInputStream(this.ssc, stream1input, 1);
        JavaDStream stream2 = JavaTestUtils.attachTestInputStream(this.ssc, stream2input, 1);
        JavaPairDStream pairStream1 = JavaPairDStream.fromJavaDStream(JavaTestUtils.attachTestInputStream(this.ssc, pairStream1input, 1));
        List<JavaDStream> listOfDStreams1 = Arrays.asList(stream1, stream2);
        JavaDStream transformed1 = this.ssc.transform(listOfDStreams1, (Function2 & Serializable)(listOfRDDs, time) -> {
            Assert.assertEquals((long)2L, (long)listOfRDDs.size());
            return null;
        });
        List<JavaDStream> listOfDStreams2 = Arrays.asList(stream1, stream2, pairStream1.toJavaDStream());
        JavaPairDStream transformed2 = this.ssc.transformToPair(listOfDStreams2, (Function2 & Serializable)(listOfRDDs, time) -> {
            Assert.assertEquals((long)3L, (long)listOfRDDs.size());
            JavaRDD rdd1 = (JavaRDD)listOfRDDs.get(0);
            JavaRDD rdd2 = (JavaRDD)listOfRDDs.get(1);
            JavaRDD rdd3 = (JavaRDD)listOfRDDs.get(2);
            JavaPairRDD prdd3 = JavaPairRDD.fromJavaRDD((JavaRDD)rdd3);
            PairFunction & Serializable mapToTuple = (PairFunction & Serializable)i -> new Tuple2(i, i);
            return rdd1.union(rdd2).mapToPair((PairFunction)mapToTuple).join(prdd3);
        });
        JavaTestUtils.attachTestOutputStream(transformed2);
        List result = JavaTestUtils.runStreams(this.ssc, 2, 2);
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testFlatMap() {
        List inputData = Arrays.asList(Arrays.asList("go", "giants"), Arrays.asList("boo", "dodgers"), Arrays.asList("athletics"));
        List expected = Arrays.asList(Arrays.asList("g", "o", "g", "i", "a", "n", "t", "s"), Arrays.asList("b", "o", "o", "d", "o", "d", "g", "e", "r", "s"), Arrays.asList("a", "t", "h", "l", "e", "t", "i", "c", "s"));
        JavaDStream stream = JavaTestUtils.attachTestInputStream(this.ssc, inputData, 1);
        JavaDStream flatMapped = stream.flatMap((FlatMapFunction & Serializable)s -> Arrays.asList(s.split("(?!^)")).iterator());
        JavaTestUtils.attachTestOutputStream(flatMapped);
        List result = JavaTestUtils.runStreams(this.ssc, 3, 3);
        Java8APISuite.assertOrderInvariantEquals(expected, result);
    }

    @Test
    public void testPairFlatMap() {
        List inputData = Arrays.asList(Arrays.asList("giants"), Arrays.asList("dodgers"), Arrays.asList("athletics"));
        List<List> expected = Arrays.asList(Arrays.asList(new Tuple2((Object)6, (Object)"g"), new Tuple2((Object)6, (Object)"i"), new Tuple2((Object)6, (Object)"a"), new Tuple2((Object)6, (Object)"n"), new Tuple2((Object)6, (Object)"t"), new Tuple2((Object)6, (Object)"s")), Arrays.asList(new Tuple2((Object)7, (Object)"d"), new Tuple2((Object)7, (Object)"o"), new Tuple2((Object)7, (Object)"d"), new Tuple2((Object)7, (Object)"g"), new Tuple2((Object)7, (Object)"e"), new Tuple2((Object)7, (Object)"r"), new Tuple2((Object)7, (Object)"s")), Arrays.asList(new Tuple2((Object)9, (Object)"a"), new Tuple2((Object)9, (Object)"t"), new Tuple2((Object)9, (Object)"h"), new Tuple2((Object)9, (Object)"l"), new Tuple2((Object)9, (Object)"e"), new Tuple2((Object)9, (Object)"t"), new Tuple2((Object)9, (Object)"i"), new Tuple2((Object)9, (Object)"c"), new Tuple2((Object)9, (Object)"s")));
        JavaDStream stream = JavaTestUtils.attachTestInputStream(this.ssc, inputData, 1);
        JavaPairDStream flatMapped = stream.flatMapToPair((PairFlatMapFunction & Serializable)s -> {
            ArrayList<Tuple2> out = new ArrayList<Tuple2>();
            for (String letter : s.split("(?!^)")) {
                out.add(new Tuple2((Object)s.length(), (Object)letter));
            }
            return out.iterator();
        });
        JavaTestUtils.attachTestOutputStream(flatMapped);
        List result = JavaTestUtils.runStreams(this.ssc, 3, 3);
        Assert.assertEquals(expected, result);
    }

    public static <T extends Comparable<T>> void assertOrderInvariantEquals(List<List<T>> expected, List<List<T>> actual) {
        expected.forEach(Collections::sort);
        ArrayList sortedActual = new ArrayList();
        actual.forEach(list -> {
            ArrayList sortedList = new ArrayList(list);
            Collections.sort(sortedList);
            sortedActual.add(sortedList);
        });
        Assert.assertEquals(expected, sortedActual);
    }

    @Test
    public void testPairFilter() {
        List inputData = Arrays.asList(Arrays.asList("giants", "dodgers"), Arrays.asList("yankees", "red sox"));
        List<List> expected = Arrays.asList(Arrays.asList(new Tuple2((Object)"giants", (Object)6)), Arrays.asList(new Tuple2((Object)"yankees", (Object)7)));
        JavaDStream stream = JavaTestUtils.attachTestInputStream(this.ssc, inputData, 1);
        JavaPairDStream pairStream = stream.mapToPair((PairFunction & Serializable)x -> new Tuple2(x, (Object)x.length()));
        JavaPairDStream filtered = pairStream.filter((Function & Serializable)x -> ((String)x._1()).contains("a"));
        JavaTestUtils.attachTestOutputStream(filtered);
        List result = JavaTestUtils.runStreams(this.ssc, 2, 2);
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testPairMap() {
        List inputData = this.stringIntKVStream;
        List<List> expected = Arrays.asList(Arrays.asList(new Tuple2((Object)1, (Object)"california"), new Tuple2((Object)3, (Object)"california"), new Tuple2((Object)4, (Object)"new york"), new Tuple2((Object)1, (Object)"new york")), Arrays.asList(new Tuple2((Object)5, (Object)"california"), new Tuple2((Object)5, (Object)"california"), new Tuple2((Object)3, (Object)"new york"), new Tuple2((Object)1, (Object)"new york")));
        JavaDStream stream = JavaTestUtils.attachTestInputStream(this.ssc, inputData, 1);
        JavaPairDStream pairStream = JavaPairDStream.fromJavaDStream(stream);
        JavaPairDStream reversed = pairStream.mapToPair(Tuple2::swap);
        JavaTestUtils.attachTestOutputStream(reversed);
        List result = JavaTestUtils.runStreams(this.ssc, 2, 2);
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testPairMapPartitions() {
        List inputData = this.stringIntKVStream;
        List<List> expected = Arrays.asList(Arrays.asList(new Tuple2((Object)1, (Object)"california"), new Tuple2((Object)3, (Object)"california"), new Tuple2((Object)4, (Object)"new york"), new Tuple2((Object)1, (Object)"new york")), Arrays.asList(new Tuple2((Object)5, (Object)"california"), new Tuple2((Object)5, (Object)"california"), new Tuple2((Object)3, (Object)"new york"), new Tuple2((Object)1, (Object)"new york")));
        JavaDStream stream = JavaTestUtils.attachTestInputStream(this.ssc, inputData, 1);
        JavaPairDStream pairStream = JavaPairDStream.fromJavaDStream(stream);
        JavaPairDStream reversed = pairStream.mapPartitionsToPair((PairFlatMapFunction & Serializable)in -> {
            LinkedList<Tuple2> out = new LinkedList<Tuple2>();
            while (in.hasNext()) {
                Tuple2 next = (Tuple2)in.next();
                out.add(next.swap());
            }
            return out.iterator();
        });
        JavaTestUtils.attachTestOutputStream(reversed);
        List result = JavaTestUtils.runStreams(this.ssc, 2, 2);
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testPairMap2() {
        List inputData = this.stringIntKVStream;
        List<List> expected = Arrays.asList(Arrays.asList(1, 3, 4, 1), Arrays.asList(5, 5, 3, 1));
        JavaDStream stream = JavaTestUtils.attachTestInputStream(this.ssc, inputData, 1);
        JavaPairDStream pairStream = JavaPairDStream.fromJavaDStream(stream);
        JavaDStream reversed = pairStream.map(Tuple2::_2);
        JavaTestUtils.attachTestOutputStream(reversed);
        List result = JavaTestUtils.runStreams(this.ssc, 2, 2);
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testPairToPairFlatMapWithChangingTypes() {
        List inputData = Arrays.asList(Arrays.asList(new Tuple2((Object)"hi", (Object)1), new Tuple2((Object)"ho", (Object)2)), Arrays.asList(new Tuple2((Object)"hi", (Object)1), new Tuple2((Object)"ho", (Object)2)));
        List<List> expected = Arrays.asList(Arrays.asList(new Tuple2((Object)1, (Object)"h"), new Tuple2((Object)1, (Object)"i"), new Tuple2((Object)2, (Object)"h"), new Tuple2((Object)2, (Object)"o")), Arrays.asList(new Tuple2((Object)1, (Object)"h"), new Tuple2((Object)1, (Object)"i"), new Tuple2((Object)2, (Object)"h"), new Tuple2((Object)2, (Object)"o")));
        JavaDStream stream = JavaTestUtils.attachTestInputStream(this.ssc, inputData, 1);
        JavaPairDStream pairStream = JavaPairDStream.fromJavaDStream(stream);
        JavaPairDStream flatMapped = pairStream.flatMapToPair((PairFlatMapFunction & Serializable)in -> {
            LinkedList<Tuple2> out = new LinkedList<Tuple2>();
            char[] cArray = ((String)in._1()).toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character s = Character.valueOf(cArray[i]);
                out.add(new Tuple2(in._2(), (Object)s.toString()));
            }
            return out.iterator();
        });
        JavaTestUtils.attachTestOutputStream(flatMapped);
        List result = JavaTestUtils.runStreams(this.ssc, 2, 2);
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testPairReduceByKey() {
        List inputData = this.stringIntKVStream;
        List<List> expected = Arrays.asList(Arrays.asList(new Tuple2((Object)"california", (Object)4), new Tuple2((Object)"new york", (Object)5)), Arrays.asList(new Tuple2((Object)"california", (Object)10), new Tuple2((Object)"new york", (Object)4)));
        JavaDStream stream = JavaTestUtils.attachTestInputStream(this.ssc, inputData, 1);
        JavaPairDStream pairStream = JavaPairDStream.fromJavaDStream(stream);
        JavaPairDStream reduced = pairStream.reduceByKey((Function2 & Serializable)(x, y) -> x + y);
        JavaTestUtils.attachTestOutputStream(reduced);
        List result = JavaTestUtils.runStreams(this.ssc, 2, 2);
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testCombineByKey() {
        List inputData = this.stringIntKVStream;
        List<List> expected = Arrays.asList(Arrays.asList(new Tuple2((Object)"california", (Object)4), new Tuple2((Object)"new york", (Object)5)), Arrays.asList(new Tuple2((Object)"california", (Object)10), new Tuple2((Object)"new york", (Object)4)));
        JavaDStream stream = JavaTestUtils.attachTestInputStream(this.ssc, inputData, 1);
        JavaPairDStream pairStream = JavaPairDStream.fromJavaDStream(stream);
        JavaPairDStream combined = pairStream.combineByKey((Function & Serializable)i -> i, (Function2 & Serializable)(x, y) -> x + y, (Function2 & Serializable)(x, y) -> x + y, (Partitioner)new HashPartitioner(2));
        JavaTestUtils.attachTestOutputStream(combined);
        List result = JavaTestUtils.runStreams(this.ssc, 2, 2);
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testReduceByKeyAndWindow() {
        List inputData = this.stringIntKVStream;
        List<List> expected = Arrays.asList(Arrays.asList(new Tuple2((Object)"california", (Object)4), new Tuple2((Object)"new york", (Object)5)), Arrays.asList(new Tuple2((Object)"california", (Object)14), new Tuple2((Object)"new york", (Object)9)), Arrays.asList(new Tuple2((Object)"california", (Object)10), new Tuple2((Object)"new york", (Object)4)));
        JavaDStream stream = JavaTestUtils.attachTestInputStream(this.ssc, inputData, 1);
        JavaPairDStream pairStream = JavaPairDStream.fromJavaDStream(stream);
        JavaPairDStream reduceWindowed = pairStream.reduceByKeyAndWindow((Function2 & Serializable)(x, y) -> x + y, new Duration(2000L), new Duration(1000L));
        JavaTestUtils.attachTestOutputStream(reduceWindowed);
        List result = JavaTestUtils.runStreams(this.ssc, 3, 3);
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testUpdateStateByKey() {
        List inputData = this.stringIntKVStream;
        List<List> expected = Arrays.asList(Arrays.asList(new Tuple2((Object)"california", (Object)4), new Tuple2((Object)"new york", (Object)5)), Arrays.asList(new Tuple2((Object)"california", (Object)14), new Tuple2((Object)"new york", (Object)9)), Arrays.asList(new Tuple2((Object)"california", (Object)14), new Tuple2((Object)"new york", (Object)9)));
        JavaDStream stream = JavaTestUtils.attachTestInputStream(this.ssc, inputData, 1);
        JavaPairDStream pairStream = JavaPairDStream.fromJavaDStream(stream);
        JavaPairDStream updated = pairStream.updateStateByKey((Function2 & Serializable)(values, state) -> {
            int out = 0;
            if (state.isPresent()) {
                out += ((Integer)state.get()).intValue();
            }
            for (Integer v : values) {
                out += v.intValue();
            }
            return Optional.of((Object)out);
        });
        JavaTestUtils.attachTestOutputStream(updated);
        List result = JavaTestUtils.runStreams(this.ssc, 3, 3);
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testReduceByKeyAndWindowWithInverse() {
        List inputData = this.stringIntKVStream;
        List<List> expected = Arrays.asList(Arrays.asList(new Tuple2((Object)"california", (Object)4), new Tuple2((Object)"new york", (Object)5)), Arrays.asList(new Tuple2((Object)"california", (Object)14), new Tuple2((Object)"new york", (Object)9)), Arrays.asList(new Tuple2((Object)"california", (Object)10), new Tuple2((Object)"new york", (Object)4)));
        JavaDStream stream = JavaTestUtils.attachTestInputStream(this.ssc, inputData, 1);
        JavaPairDStream pairStream = JavaPairDStream.fromJavaDStream(stream);
        JavaPairDStream reduceWindowed = pairStream.reduceByKeyAndWindow((Function2 & Serializable)(x, y) -> x + y, (Function2 & Serializable)(x, y) -> x - y, new Duration(2000L), new Duration(1000L));
        JavaTestUtils.attachTestOutputStream(reduceWindowed);
        List result = JavaTestUtils.runStreams(this.ssc, 3, 3);
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testPairTransform() {
        List inputData = Arrays.asList(Arrays.asList(new Tuple2((Object)3, (Object)5), new Tuple2((Object)1, (Object)5), new Tuple2((Object)4, (Object)5), new Tuple2((Object)2, (Object)5)), Arrays.asList(new Tuple2((Object)2, (Object)5), new Tuple2((Object)3, (Object)5), new Tuple2((Object)4, (Object)5), new Tuple2((Object)1, (Object)5)));
        List<List> expected = Arrays.asList(Arrays.asList(new Tuple2((Object)1, (Object)5), new Tuple2((Object)2, (Object)5), new Tuple2((Object)3, (Object)5), new Tuple2((Object)4, (Object)5)), Arrays.asList(new Tuple2((Object)1, (Object)5), new Tuple2((Object)2, (Object)5), new Tuple2((Object)3, (Object)5), new Tuple2((Object)4, (Object)5)));
        JavaDStream stream = JavaTestUtils.attachTestInputStream(this.ssc, inputData, 1);
        JavaPairDStream pairStream = JavaPairDStream.fromJavaDStream(stream);
        JavaPairDStream sorted = pairStream.transformToPair((Function & Serializable)in -> in.sortByKey());
        JavaTestUtils.attachTestOutputStream(sorted);
        List result = JavaTestUtils.runStreams(this.ssc, 2, 2);
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testPairToNormalRDDTransform() {
        List inputData = Arrays.asList(Arrays.asList(new Tuple2((Object)3, (Object)5), new Tuple2((Object)1, (Object)5), new Tuple2((Object)4, (Object)5), new Tuple2((Object)2, (Object)5)), Arrays.asList(new Tuple2((Object)2, (Object)5), new Tuple2((Object)3, (Object)5), new Tuple2((Object)4, (Object)5), new Tuple2((Object)1, (Object)5)));
        List<List> expected = Arrays.asList(Arrays.asList(3, 1, 4, 2), Arrays.asList(2, 3, 4, 1));
        JavaDStream stream = JavaTestUtils.attachTestInputStream(this.ssc, inputData, 1);
        JavaPairDStream pairStream = JavaPairDStream.fromJavaDStream(stream);
        JavaDStream firstParts = pairStream.transform((Function & Serializable)in -> in.map((Function & Serializable)x -> (Integer)x._1()));
        JavaTestUtils.attachTestOutputStream(firstParts);
        List result = JavaTestUtils.runStreams(this.ssc, 2, 2);
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testMapValues() {
        List inputData = this.stringStringKVStream;
        List<List> expected = Arrays.asList(Arrays.asList(new Tuple2((Object)"california", (Object)"DODGERS"), new Tuple2((Object)"california", (Object)"GIANTS"), new Tuple2((Object)"new york", (Object)"YANKEES"), new Tuple2((Object)"new york", (Object)"METS")), Arrays.asList(new Tuple2((Object)"california", (Object)"SHARKS"), new Tuple2((Object)"california", (Object)"DUCKS"), new Tuple2((Object)"new york", (Object)"RANGERS"), new Tuple2((Object)"new york", (Object)"ISLANDERS")));
        JavaDStream stream = JavaTestUtils.attachTestInputStream(this.ssc, inputData, 1);
        JavaPairDStream pairStream = JavaPairDStream.fromJavaDStream(stream);
        JavaPairDStream mapped = pairStream.mapValues((Function & Serializable)s -> s.toUpperCase(Locale.ROOT));
        JavaTestUtils.attachTestOutputStream(mapped);
        List result = JavaTestUtils.runStreams(this.ssc, 2, 2);
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testFlatMapValues() {
        List inputData = this.stringStringKVStream;
        List<List> expected = Arrays.asList(Arrays.asList(new Tuple2((Object)"california", (Object)"dodgers1"), new Tuple2((Object)"california", (Object)"dodgers2"), new Tuple2((Object)"california", (Object)"giants1"), new Tuple2((Object)"california", (Object)"giants2"), new Tuple2((Object)"new york", (Object)"yankees1"), new Tuple2((Object)"new york", (Object)"yankees2"), new Tuple2((Object)"new york", (Object)"mets1"), new Tuple2((Object)"new york", (Object)"mets2")), Arrays.asList(new Tuple2((Object)"california", (Object)"sharks1"), new Tuple2((Object)"california", (Object)"sharks2"), new Tuple2((Object)"california", (Object)"ducks1"), new Tuple2((Object)"california", (Object)"ducks2"), new Tuple2((Object)"new york", (Object)"rangers1"), new Tuple2((Object)"new york", (Object)"rangers2"), new Tuple2((Object)"new york", (Object)"islanders1"), new Tuple2((Object)"new york", (Object)"islanders2")));
        JavaDStream stream = JavaTestUtils.attachTestInputStream(this.ssc, inputData, 1);
        JavaPairDStream pairStream = JavaPairDStream.fromJavaDStream(stream);
        JavaPairDStream flatMapped = pairStream.flatMapValues((Function & Serializable)in -> Arrays.asList(in + "1", in + "2"));
        JavaTestUtils.attachTestOutputStream(flatMapped);
        List result = JavaTestUtils.runStreams(this.ssc, 2, 2);
        Assert.assertEquals(expected, result);
    }

    public void testMapWithStateAPI() {
        JavaPairRDD initialRDD = null;
        Object wordsDstream = null;
        Function4 & Serializable mapFn = (Function4 & Serializable)(time, key, value, state) -> {
            state.exists();
            state.get();
            state.isTimingOut();
            state.remove();
            state.update((Object)true);
            return Optional.of((Object)2.0);
        };
        JavaMapWithStateDStream stateDstream = wordsDstream.mapWithState(StateSpec.function((Function4)mapFn).initialState(initialRDD).numPartitions(10).partitioner((Partitioner)new HashPartitioner(10)).timeout(Durations.seconds((long)10L)));
        JavaPairDStream emittedRecords = stateDstream.stateSnapshots();
        Function3 & Serializable mapFn2 = (Function3 & Serializable)(key, value, state) -> {
            state.exists();
            state.get();
            state.isTimingOut();
            state.remove();
            state.update((Object)true);
            return 2.0;
        };
        JavaMapWithStateDStream stateDstream2 = wordsDstream.mapWithState(StateSpec.function((Function3)mapFn2).initialState(initialRDD).numPartitions(10).partitioner((Partitioner)new HashPartitioner(10)).timeout(Durations.seconds((long)10L)));
        JavaPairDStream mappedDStream = stateDstream2.stateSnapshots();
    }
}

