/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.kafka010;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.kafka010.KafkaTokenClusterConf;
import org.apache.spark.kafka010.KafkaTokenSparkConf$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001)4AAH\u0010\u0001Q!)1\u0007\u0001C\u0001i!9q\u0007\u0001b\u0001\n\u0013A\u0004BB!\u0001A\u0003%\u0011\bC\u0004C\u0001\t\u0007I\u0011\u0002\u001d\t\r\r\u0003\u0001\u0015!\u0003:\u0011\u001d!\u0005A1A\u0005\naBa!\u0012\u0001!\u0002\u0013I\u0004b\u0002$\u0001\u0005\u0004%I\u0001\u000f\u0005\u0007\u000f\u0002\u0001\u000b\u0011B\u001d\t\u000f!\u0003!\u0019!C\u0005q!1\u0011\n\u0001Q\u0001\neBqA\u0013\u0001C\u0002\u0013%\u0001\b\u0003\u0004L\u0001\u0001\u0006I!\u000f\u0005\b\u0019\u0002\u0011\r\u0011\"\u00039\u0011\u0019i\u0005\u0001)A\u0005s!9a\n\u0001b\u0001\n\u0013A\u0004BB(\u0001A\u0003%\u0011\bC\u0004Q\u0001\t\u0007I\u0011\u0002\u001d\t\rE\u0003\u0001\u0015!\u0003:\u0011\u001d\u0011\u0006A1A\u0005\naBaa\u0015\u0001!\u0002\u0013I\u0004b\u0002+\u0001\u0005\u0004%I\u0001\u000f\u0005\u0007+\u0002\u0001\u000b\u0011B\u001d\t\u000fY\u0003!\u0019!C\u0005q!1q\u000b\u0001Q\u0001\neBq\u0001\u0017\u0001A\u0002\u0013%\u0011\fC\u0004^\u0001\u0001\u0007I\u0011\u00020\t\r\u001d\u0004\u0001\u0015)\u0003[\u0011\u0015A\u0007\u0001\"\u0011j\u0005aY\u0015MZ6b)>\\WM\\*qCJ\\7i\u001c8g'VLG/\u001a\u0006\u0003A\u0005\n\u0001b[1gW\u0006\u0004\u0014\u0007\r\u0006\u0003E\r\nQa\u001d9be.T!\u0001J\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0013aA8sO\u000e\u00011c\u0001\u0001*[A\u0011!fK\u0007\u0002C%\u0011A&\t\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u00059\nT\"A\u0018\u000b\u0005A*\u0013!C:dC2\fG/Z:u\u0013\t\u0011tF\u0001\nCK\u001a|'/Z!oI\u00063G/\u001a:FC\u000eD\u0017A\u0002\u001fj]&$h\bF\u00016!\t1\u0004!D\u0001 \u0003-IG-\u001a8uS\u001aLWM]\u0019\u0016\u0003e\u0002\"AO \u000e\u0003mR!\u0001P\u001f\u0002\t1\fgn\u001a\u0006\u0002}\u0005!!.\u0019<b\u0013\t\u00015H\u0001\u0004TiJLgnZ\u0001\rS\u0012,g\u000e^5gS\u0016\u0014\u0018\u0007I\u0001\fS\u0012,g\u000e^5gS\u0016\u0014('\u0001\u0007jI\u0016tG/\u001b4jKJ\u0014\u0004%\u0001\u000bbkRD'i\\8u'R\u0014\u0018\r]*feZ,'o]\u0001\u0016CV$\bNQ8piN#(/\u00199TKJ4XM]:!\u0003I!\u0018M]4fiN+'O^3sgJ+w-\u001a=\u0002'Q\f'oZ3u'\u0016\u0014h/\u001a:t%\u0016<W\r\u001f\u0011\u0002!M,7-\u001e:jif\u0004&o\u001c;pG>d\u0017!E:fGV\u0014\u0018\u000e^=Qe>$xnY8mA\u0005\u00192.\u001a:cKJ|7oU3sm&\u001cWMT1nK\u0006!2.\u001a:cKJ|7oU3sm&\u001cWMT1nK\u0002\n!\u0003\u001e:vgR\u001cFo\u001c:f\u0019>\u001c\u0017\r^5p]\u0006\u0019BO];tiN#xN]3M_\u000e\fG/[8oA\u0005\u0011BO];tiN#xN]3QCN\u001cxo\u001c:e\u0003M!(/^:u'R|'/\u001a)bgN<xN\u001d3!\u0003AYW-_*u_J,Gj\\2bi&|g.A\tlKf\u001cFo\u001c:f\u0019>\u001c\u0017\r^5p]\u0002\n\u0001c[3z'R|'/\u001a)bgN<xN\u001d3\u0002#-,\u0017p\u0015;pe\u0016\u0004\u0016m]:x_J$\u0007%A\u0006lKf\u0004\u0016m]:x_J$\u0017\u0001D6fsB\u000b7o]<pe\u0012\u0004\u0013A\u0004;pW\u0016tW*Z2iC:L7/\\\u0001\u0010i>\\WM\\'fG\"\fg.[:nA\u0005I1\u000f]1sW\u000e{gNZ\u000b\u00025B\u0011!fW\u0005\u00039\u0006\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\u001bM\u0004\u0018M]6D_:4w\fJ3r)\tyV\r\u0005\u0002aG6\t\u0011MC\u0001c\u0003\u0015\u00198-\u00197b\u0013\t!\u0017M\u0001\u0003V]&$\bb\u00024\u001c\u0003\u0003\u0005\rAW\u0001\u0004q\u0012\n\u0014AC:qCJ\\7i\u001c8gA\u0005Q!-\u001a4pe\u0016,\u0015m\u00195\u0015\u0003}\u0003")
public class KafkaTokenSparkConfSuite
extends SparkFunSuite {
    private final String identifier1;
    private final String identifier2;
    private final String authBootStrapServers;
    private final String targetServersRegex;
    private final String securityProtocol;
    private final String kerberosServiceName;
    private final String trustStoreLocation;
    private final String trustStorePassword;
    private final String keyStoreLocation;
    private final String keyStorePassword;
    private final String keyPassword;
    private final String tokenMechanism;
    private SparkConf sparkConf;

    private String identifier1() {
        return this.identifier1;
    }

    private String identifier2() {
        return this.identifier2;
    }

    private String authBootStrapServers() {
        return this.authBootStrapServers;
    }

    private String targetServersRegex() {
        return this.targetServersRegex;
    }

    private String securityProtocol() {
        return this.securityProtocol;
    }

    private String kerberosServiceName() {
        return this.kerberosServiceName;
    }

    private String trustStoreLocation() {
        return this.trustStoreLocation;
    }

    private String trustStorePassword() {
        return this.trustStorePassword;
    }

    private String keyStoreLocation() {
        return this.keyStoreLocation;
    }

    private String keyStorePassword() {
        return this.keyStorePassword;
    }

    private String keyPassword() {
        return this.keyPassword;
    }

    private String tokenMechanism() {
        return this.tokenMechanism;
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    private void sparkConf_$eq(SparkConf x$1) {
        this.sparkConf = x$1;
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        this.sparkConf_$eq(new SparkConf());
    }

    public KafkaTokenSparkConfSuite() {
        this.identifier1 = "cluster1";
        this.identifier2 = "cluster2";
        this.authBootStrapServers = "127.0.0.1:0";
        this.targetServersRegex = "127.0.0.*:0";
        this.securityProtocol = SecurityProtocol.SSL.name;
        this.kerberosServiceName = "kafka1";
        this.trustStoreLocation = "/path/to/trustStore";
        this.trustStorePassword = "trustStoreSecret";
        this.keyStoreLocation = "/path/to/keyStore";
        this.keyStorePassword = "keyStoreSecret";
        this.keyPassword = "keySecret";
        this.tokenMechanism = "SCRAM-SHA-256";
        this.sparkConf = null;
        this.test("getClusterConfig should trow exception when not exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            NoSuchElementException thrown = (NoSuchElementException)this.intercept((Function0 & Serializable & scala.Serializable)() -> KafkaTokenSparkConf$.MODULE$.getClusterConfig(this.sparkConf(), "invalid"), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
            String $org_scalatest_assert_macro_left = thrown.getMessage();
            String $org_scalatest_assert_macro_right = "spark.kafka.clusters.invalid.auth.bootstrap.servers";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        }, new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        this.test("getClusterConfig should return entry with defaults", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.sparkConf().set(new StringBuilder(44).append("spark.kafka.clusters.").append(this.identifier1()).append(".auth.bootstrap.servers").toString(), this.authBootStrapServers());
            KafkaTokenClusterConf clusterConfig = KafkaTokenSparkConf$.MODULE$.getClusterConfig(this.sparkConf(), this.identifier1());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(clusterConfig.identifier());
            String $org_scalatest_assert_macro_right = this.identifier1();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(clusterConfig.authBootstrapServers());
            String $org_scalatest_assert_macro_right2 = this.authBootStrapServers();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(clusterConfig.targetServersRegex());
            String $org_scalatest_assert_macro_right3 = KafkaTokenSparkConf$.MODULE$.DEFAULT_TARGET_SERVERS_REGEX();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(clusterConfig.securityProtocol());
            String $org_scalatest_assert_macro_right4 = SecurityProtocol.SASL_SSL.name;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(clusterConfig.kerberosServiceName());
            String $org_scalatest_assert_macro_right5 = KafkaTokenSparkConf$.MODULE$.DEFAULT_SASL_KERBEROS_SERVICE_NAME();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(clusterConfig.trustStoreLocation());
            None$ $org_scalatest_assert_macro_right6 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(clusterConfig.trustStorePassword());
            None$ $org_scalatest_assert_macro_right7 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(clusterConfig.keyStoreLocation());
            None$ $org_scalatest_assert_macro_right8 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(clusterConfig.keyStorePassword());
            None$ $org_scalatest_assert_macro_right9 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(clusterConfig.keyPassword());
            None$ $org_scalatest_assert_macro_right10 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(clusterConfig.tokenMechanism());
            String $org_scalatest_assert_macro_right11 = KafkaTokenSparkConf$.MODULE$.DEFAULT_SASL_TOKEN_MECHANISM();
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        }, new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("getClusterConfig should return entry overwrite defaults", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.sparkConf().set(new StringBuilder(44).append("spark.kafka.clusters.").append(this.identifier1()).append(".auth.bootstrap.servers").toString(), this.authBootStrapServers());
            this.sparkConf().set(new StringBuilder(52).append("spark.kafka.clusters.").append(this.identifier1()).append(".target.bootstrap.servers.regex").toString(), this.targetServersRegex());
            this.sparkConf().set(new StringBuilder(39).append("spark.kafka.clusters.").append(this.identifier1()).append(".security.protocol").toString(), this.securityProtocol());
            this.sparkConf().set(new StringBuilder(48).append("spark.kafka.clusters.").append(this.identifier1()).append(".sasl.kerberos.service.name").toString(), this.kerberosServiceName());
            this.sparkConf().set(new StringBuilder(45).append("spark.kafka.clusters.").append(this.identifier1()).append(".ssl.truststore.location").toString(), this.trustStoreLocation());
            this.sparkConf().set(new StringBuilder(45).append("spark.kafka.clusters.").append(this.identifier1()).append(".ssl.truststore.password").toString(), this.trustStorePassword());
            this.sparkConf().set(new StringBuilder(43).append("spark.kafka.clusters.").append(this.identifier1()).append(".ssl.keystore.location").toString(), this.keyStoreLocation());
            this.sparkConf().set(new StringBuilder(43).append("spark.kafka.clusters.").append(this.identifier1()).append(".ssl.keystore.password").toString(), this.keyStorePassword());
            this.sparkConf().set(new StringBuilder(38).append("spark.kafka.clusters.").append(this.identifier1()).append(".ssl.key.password").toString(), this.keyPassword());
            this.sparkConf().set(new StringBuilder(42).append("spark.kafka.clusters.").append(this.identifier1()).append(".sasl.token.mechanism").toString(), this.tokenMechanism());
            KafkaTokenClusterConf clusterConfig = KafkaTokenSparkConf$.MODULE$.getClusterConfig(this.sparkConf(), this.identifier1());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(clusterConfig.identifier());
            String $org_scalatest_assert_macro_right = this.identifier1();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(clusterConfig.authBootstrapServers());
            String $org_scalatest_assert_macro_right2 = this.authBootStrapServers();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(clusterConfig.targetServersRegex());
            String $org_scalatest_assert_macro_right3 = this.targetServersRegex();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(clusterConfig.securityProtocol());
            String $org_scalatest_assert_macro_right4 = this.securityProtocol();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(clusterConfig.kerberosServiceName());
            String $org_scalatest_assert_macro_right5 = this.kerberosServiceName();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(clusterConfig.trustStoreLocation());
            Some $org_scalatest_assert_macro_right6 = new Some((Object)this.trustStoreLocation());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(clusterConfig.trustStorePassword());
            Some $org_scalatest_assert_macro_right7 = new Some((Object)this.trustStorePassword());
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(clusterConfig.keyStoreLocation());
            Some $org_scalatest_assert_macro_right8 = new Some((Object)this.keyStoreLocation());
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(clusterConfig.keyStorePassword());
            Some $org_scalatest_assert_macro_right9 = new Some((Object)this.keyStorePassword());
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(clusterConfig.keyPassword());
            Some $org_scalatest_assert_macro_right10 = new Some((Object)this.keyPassword());
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(clusterConfig.tokenMechanism());
            String $org_scalatest_assert_macro_right11 = this.tokenMechanism();
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        }, new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("getClusterConfig should return specified kafka params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.sparkConf().set(new StringBuilder(44).append("spark.kafka.clusters.").append(this.identifier1()).append(".auth.bootstrap.servers").toString(), this.authBootStrapServers());
            this.sparkConf().set(new StringBuilder(37).append("spark.kafka.clusters.").append(this.identifier1()).append(".kafka.customKey").toString(), "customValue");
            KafkaTokenClusterConf clusterConfig = KafkaTokenSparkConf$.MODULE$.getClusterConfig(this.sparkConf(), this.identifier1());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(clusterConfig.identifier());
            String $org_scalatest_assert_macro_right = this.identifier1();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(clusterConfig.authBootstrapServers());
            String $org_scalatest_assert_macro_right2 = this.authBootStrapServers();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(clusterConfig.specifiedKafkaParams());
            Map $org_scalatest_assert_macro_right3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customKey"), (Object)"customValue")}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        }, new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("getAllClusterConfigs should return empty list when nothing configured", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Set $org_scalatest_assert_macro_left = KafkaTokenSparkConf$.MODULE$.getAllClusterConfigs(this.sparkConf());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        }, new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        this.test("getAllClusterConfigs should return empty list with malformed configuration", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.sparkConf().set("spark.kafka.clusters.", this.authBootStrapServers());
            Set $org_scalatest_assert_macro_left = KafkaTokenSparkConf$.MODULE$.getAllClusterConfigs(this.sparkConf());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        }, new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("getAllClusterConfigs should return multiple entries", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sparkConf().set(new StringBuilder(44).append("spark.kafka.clusters.").append(this.identifier1()).append(".auth.bootstrap.servers").toString(), this.authBootStrapServers());
            this.sparkConf().set(new StringBuilder(44).append("spark.kafka.clusters.").append(this.identifier2()).append(".auth.bootstrap.servers").toString(), this.authBootStrapServers());
            Set clusterConfigs = KafkaTokenSparkConf$.MODULE$.getAllClusterConfigs(this.sparkConf());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)clusterConfigs.size()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            clusterConfigs.foreach((Function1 & Serializable & scala.Serializable)clusterConfig -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(clusterConfig.authBootstrapServers());
                String $org_scalatest_assert_macro_right = this.authBootStrapServers();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(clusterConfig.targetServersRegex());
                String $org_scalatest_assert_macro_right2 = KafkaTokenSparkConf$.MODULE$.DEFAULT_TARGET_SERVERS_REGEX();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(clusterConfig.securityProtocol());
                String $org_scalatest_assert_macro_right3 = SecurityProtocol.SASL_SSL.name;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(clusterConfig.kerberosServiceName());
                String $org_scalatest_assert_macro_right4 = KafkaTokenSparkConf$.MODULE$.DEFAULT_SASL_KERBEROS_SERVICE_NAME();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(clusterConfig.trustStoreLocation());
                None$ $org_scalatest_assert_macro_right5 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(clusterConfig.trustStorePassword());
                None$ $org_scalatest_assert_macro_right6 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(clusterConfig.keyStoreLocation());
                None$ $org_scalatest_assert_macro_right7 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(clusterConfig.keyStorePassword());
                None$ $org_scalatest_assert_macro_right8 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(clusterConfig.keyPassword());
                None$ $org_scalatest_assert_macro_right9 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(clusterConfig.tokenMechanism());
                String $org_scalatest_assert_macro_right10 = KafkaTokenSparkConf$.MODULE$.DEFAULT_SASL_TOKEN_MECHANISM();
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            });
        }, new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
    }
}

