/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import com.google.common.io.Files;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.spark.TestUtils$;
import org.apache.spark.deploy.yarn.BaseYarnClusterSuite;
import org.apache.spark.deploy.yarn.ExecutorEnvTestApp$;
import org.apache.spark.deploy.yarn.SparkContextTimeoutApp$;
import org.apache.spark.deploy.yarn.YarnClasspathTest$;
import org.apache.spark.deploy.yarn.YarnClusterDriver$;
import org.apache.spark.deploy.yarn.YarnClusterDriverUseSparkHadoopUtilConf$;
import org.apache.spark.deploy.yarn.YarnClusterDriverWithFailure$;
import org.apache.spark.deploy.yarn.YarnClusterSuite$;
import org.apache.spark.deploy.yarn.YarnLauncherTestApp$;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.launcher.SparkLauncher;
import org.apache.spark.tags.ExtendedYarnTest;
import org.apache.spark.util.Utils$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.time.Span$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendedYarnTest
@ScalaSignature(bytes="\u0006\u0001A4A!\u0001\u0002\u0001\u001b\t\u0001\u0012,\u0019:o\u00072,8\u000f^3s'VLG/\u001a\u0006\u0003\u0007\u0011\tA!_1s]*\u0011QAB\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u0015\u0005\u0006\u001cX-W1s]\u000ecWo\u001d;feN+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002CA\b\u0001\u0011\u00159\u0002\u0001\"\u0011\u0019\u00035qWm^-be:\u001cuN\u001c4jOR\t\u0011\u0004\u0005\u0002\u001bA5\t1D\u0003\u0002\u001d;\u0005!1m\u001c8g\u0015\t\u0019aD\u0003\u0002 \u0011\u00051\u0001.\u00193p_BL!!I\u000e\u0003#e\u000b'O\\\"p]\u001aLw-\u001e:bi&|g\u000eC\u0004$\u0001\t\u0007I\u0011\u0002\u0013\u0002\u0017Q+5\u000bV0Q3\u001aKE*R\u000b\u0002KA\u0011a\u0005\f\b\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006K\u0001\u0007!J,G-\u001a4\n\u00055r#AB*ue&twM\u0003\u0002,Q!1\u0001\u0007\u0001Q\u0001\n\u0015\nA\u0002V#T)~\u0003\u0016LR%M\u000b\u0002BqA\r\u0001C\u0002\u0013%A%A\u0007U\u000bN#v\fU-N\u001f\u0012+F*\u0012\u0005\u0007i\u0001\u0001\u000b\u0011B\u0013\u0002\u001dQ+5\u000bV0Q36{E)\u0016'FA!)a\u0007\u0001C\u0005o\u0005\u0001B/Z:u\u0005\u0006\u001c\u0018nY-be:\f\u0005\u000f\u001d\u000b\u0004qm\u0002\u0005CA\u0014:\u0013\tQ\u0004F\u0001\u0003V]&$\b\"\u0002\u001f6\u0001\u0004i\u0014AC2mS\u0016tG/T8eKB\u0011qEP\u0005\u0003\u007f!\u0012qAQ8pY\u0016\fg\u000eC\u0004\u001dkA\u0005\t\u0019A!\u0011\t\u0019\u0012U%J\u0005\u0003\u0007:\u00121!T1q\u0011\u0015)\u0005\u0001\"\u0003G\u00039!Xm\u001d;XSRD\u0017\t\u001a3KCJ$\"\u0001O$\t\u000bq\"\u0005\u0019A\u001f\t\u000b%\u0003A\u0011\u0002&\u0002\u0017Q,7\u000f\u001e)z'B\f'o\u001b\u000b\u0005q-ce\nC\u0003=\u0011\u0002\u0007Q\bC\u0004N\u0011B\u0005\t\u0019A!\u0002\u0013\u0015DHO]1D_:4\u0007bB(I!\u0003\u0005\r!Q\u0001\tKb$(/Y#om\")\u0011\u000b\u0001C\u0005%\u0006)B/Z:u+N,7\t\\1tgB\u000bG\u000f\u001b$jeN$HC\u0001\u001dT\u0011\u0015a\u0004\u000b1\u0001>\u0011\u0015)\u0006\u0001\"\u0003W\u0003=!Xm\u001d;Fq\u0016\u001cW\u000f^8s\u000b:4HC\u0001\u001dX\u0011\u0015aD\u000b1\u0001>\u0011\u001dI\u0006!%A\u0005\ni\u000b!\u0004^3ti\n\u000b7/[2ZCJt\u0017\t\u001d9%I\u00164\u0017-\u001e7uII*\u0012a\u0017\u0016\u0003\u0003r[\u0013!\u0018\t\u0003=\u000el\u0011a\u0018\u0006\u0003A\u0006\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005\tD\u0013AC1o]>$\u0018\r^5p]&\u0011Am\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007b\u00024\u0001#\u0003%IAW\u0001\u0016i\u0016\u001cH\u000fU=Ta\u0006\u00148\u000e\n3fM\u0006,H\u000e\u001e\u00133\u0011\u001dA\u0007!%A\u0005\ni\u000bQ\u0003^3tiBK8\u000b]1sW\u0012\"WMZ1vYR$3\u0007\u000b\u0002\u0001UB\u00111N\\\u0007\u0002Y*\u0011QNB\u0001\u0005i\u0006<7/\u0003\u0002pY\n\u0001R\t\u001f;f]\u0012,G-W1s]R+7\u000f\u001e")
public class YarnClusterSuite
extends BaseYarnClusterSuite {
    private final String TEST_PYFILE = new StringOps(Predef$.MODULE$.augmentString("\n    |import mod1, mod2\n    |import sys\n    |from operator import add\n    |\n    |from pyspark import SparkConf , SparkContext\n    |if __name__ == \"__main__\":\n    |    if len(sys.argv) != 2:\n    |        print >> sys.stderr, \"Usage: test.py [result file]\"\n    |        exit(-1)\n    |    sc = SparkContext(conf=SparkConf())\n    |    status = open(sys.argv[1],'w')\n    |    result = \"failure\"\n    |    rdd = sc.parallelize(range(10)).map(lambda x: x * mod1.func() * mod2.func())\n    |    cnt = rdd.count()\n    |    if cnt == 10:\n    |        result = \"success\"\n    |    status.write(result)\n    |    status.close()\n    |    sc.stop()\n    ")).stripMargin();
    private final String TEST_PYMODULE = new StringOps(Predef$.MODULE$.augmentString("\n    |def func():\n    |    return 42\n    ")).stripMargin();

    @Override
    public YarnConfiguration newYarnConfig() {
        return new YarnConfiguration();
    }

    private String TEST_PYFILE() {
        return this.TEST_PYFILE;
    }

    private String TEST_PYMODULE() {
        return this.TEST_PYMODULE;
    }

    public void org$apache$spark$deploy$yarn$YarnClusterSuite$$testBasicYarnApp(boolean clientMode, Map<String, String> conf) {
        File result = File.createTempFile("result", null, this.tempDir());
        boolean x$24 = clientMode;
        String x$25 = this.mainClassName(YarnClusterDriver$.MODULE$.getClass());
        Seq x$26 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{result.getAbsolutePath()}));
        Map<String, String> x$27 = conf;
        Seq<Tuple2<String, String>> x$28 = this.runSpark$default$4();
        Seq<String> x$29 = this.runSpark$default$5();
        Seq<String> x$30 = this.runSpark$default$6();
        Map<String, String> x$31 = this.runSpark$default$8();
        Option<File> x$32 = this.runSpark$default$9();
        SparkAppHandle.State finalState = this.runSpark(x$24, x$25, (Seq<String>)x$26, x$28, x$29, x$30, x$27, x$31, x$32);
        this.checkResult(finalState, result, this.checkResult$default$3(), this.checkResult$default$4());
    }

    public Map<String, String> org$apache$spark$deploy$yarn$YarnClusterSuite$$testBasicYarnApp$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public void org$apache$spark$deploy$yarn$YarnClusterSuite$$testWithAddJar(boolean clientMode) {
        URL originalJar = TestUtils$.MODULE$.createJarWithFiles((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test.resource"), (Object)"ORIGINAL")})), this.tempDir());
        File driverResult = File.createTempFile("driver", null, this.tempDir());
        File executorResult = File.createTempFile("executor", null, this.tempDir());
        boolean x$33 = clientMode;
        String x$34 = this.mainClassName(YarnClasspathTest$.MODULE$.getClass());
        Seq x$35 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{driverResult.getAbsolutePath(), executorResult.getAbsolutePath()}));
        Seq x$36 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{originalJar.getPath()}));
        Seq x$37 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"local:").append((Object)originalJar.getPath()).toString()}));
        Seq<Tuple2<String, String>> x$38 = this.runSpark$default$4();
        Map<String, String> x$39 = this.runSpark$default$7();
        Map<String, String> x$40 = this.runSpark$default$8();
        Option<File> x$41 = this.runSpark$default$9();
        SparkAppHandle.State finalState = this.runSpark(x$33, x$34, (Seq<String>)x$35, x$38, (Seq<String>)x$36, (Seq<String>)x$37, x$39, x$40, x$41);
        this.checkResult(finalState, driverResult, "ORIGINAL", this.checkResult$default$4());
        this.checkResult(finalState, executorResult, "ORIGINAL", this.checkResult$default$4());
    }

    public void org$apache$spark$deploy$yarn$YarnClusterSuite$$testPySpark(boolean clientMode, Map<String, String> extraConf, Map<String, String> extraEnv) {
        SparkAppHandle.State finalState;
        File primaryPyFile = new File(this.tempDir(), "test.py");
        Files.write((CharSequence)this.TEST_PYFILE(), (File)primaryPyFile, (Charset)StandardCharsets.UTF_8);
        String sparkHome = (String)scala.sys.package$.MODULE$.props().apply((Object)"spark.test.home");
        Seq pythonPath = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/python/lib/py4j-0.10.7-src.zip"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sparkHome})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/python"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sparkHome}))}));
        Map extraEnvVars = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYSPARK_ARCHIVES_PATH"), (Object)((TraversableOnce)pythonPath.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return new StringBuilder().append((Object)"local:").append((Object)x$1).toString();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(File.pathSeparator)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)pythonPath.mkString(File.pathSeparator))}))).$plus$plus(extraEnv);
        File subdir = new File(this.tempDir(), "pyModules");
        subdir.mkdir();
        File moduleDir = subdir;
        File pyModule = new File(moduleDir, "mod1.py");
        Files.write((CharSequence)this.TEST_PYMODULE(), (File)pyModule, (Charset)StandardCharsets.UTF_8);
        URL mod2Archive = TestUtils$.MODULE$.createJarWithFiles((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mod2.py"), (Object)this.TEST_PYMODULE())})), moduleDir);
        String pyFiles = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{pyModule.getAbsolutePath(), mod2Archive.getPath()}))).mkString(",");
        File result = File.createTempFile("result", null, this.tempDir());
        Some outFile = new Some((Object)File.createTempFile("stdout", null, this.tempDir()));
        boolean x$42 = clientMode;
        String x$43 = primaryPyFile.getAbsolutePath();
        Seq x$44 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"--py-files"), (Object)pyFiles)}));
        Seq x$45 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{result.getAbsolutePath()}));
        Map x$46 = extraEnvVars;
        Map<String, String> x$47 = extraConf;
        Some x$48 = outFile;
        Seq<String> x$49 = this.runSpark$default$5();
        Seq<String> x$50 = this.runSpark$default$6();
        SparkAppHandle.State x$51 = finalState = this.runSpark(x$42, x$43, (Seq<String>)x$45, (Seq<Tuple2<String, String>>)x$44, x$49, x$50, x$47, (Map<String, String>)x$46, (Option<File>)x$48);
        File x$52 = result;
        Some x$53 = outFile;
        String x$54 = this.checkResult$default$3();
        this.checkResult(x$51, x$52, x$54, (Option<File>)x$53);
    }

    public Map<String, String> org$apache$spark$deploy$yarn$YarnClusterSuite$$testPySpark$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Map<String, String> org$apache$spark$deploy$yarn$YarnClusterSuite$$testPySpark$default$3() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public void org$apache$spark$deploy$yarn$YarnClusterSuite$$testUseClassPathFirst(boolean clientMode) {
        URL originalJar = TestUtils$.MODULE$.createJarWithFiles((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test.resource"), (Object)"ORIGINAL")})), this.tempDir());
        URL userJar = TestUtils$.MODULE$.createJarWithFiles((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test.resource"), (Object)"OVERRIDDEN")})), this.tempDir());
        File driverResult = File.createTempFile("driver", null, this.tempDir());
        File executorResult = File.createTempFile("executor", null, this.tempDir());
        boolean x$55 = clientMode;
        String x$56 = this.mainClassName(YarnClasspathTest$.MODULE$.getClass());
        Seq x$57 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{driverResult.getAbsolutePath(), executorResult.getAbsolutePath()}));
        Seq x$58 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{originalJar.getPath()}));
        Seq x$59 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"local:").append((Object)userJar.getPath()).toString()}));
        Map x$60 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.driver.userClassPathFirst"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.userClassPathFirst"), (Object)"true")}));
        Seq<Tuple2<String, String>> x$61 = this.runSpark$default$4();
        Map<String, String> x$62 = this.runSpark$default$8();
        Option<File> x$63 = this.runSpark$default$9();
        SparkAppHandle.State finalState = this.runSpark(x$55, x$56, (Seq<String>)x$57, x$61, (Seq<String>)x$58, (Seq<String>)x$59, (Map<String, String>)x$60, x$62, x$63);
        this.checkResult(finalState, driverResult, "OVERRIDDEN", this.checkResult$default$4());
        this.checkResult(finalState, executorResult, "OVERRIDDEN", this.checkResult$default$4());
    }

    public void org$apache$spark$deploy$yarn$YarnClusterSuite$$testExecutorEnv(boolean clientMode) {
        File result = File.createTempFile("result", null, this.tempDir());
        boolean x$64 = clientMode;
        String x$65 = this.mainClassName(ExecutorEnvTestApp$.MODULE$.getClass());
        Seq x$66 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{result.getAbsolutePath()}));
        Map x$67 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.appMasterEnv.TEST_ENV"), (Object)"am_val"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executorEnv.TEST_ENV"), (Object)"executor_val")}));
        Seq<Tuple2<String, String>> x$68 = this.runSpark$default$4();
        Seq<String> x$69 = this.runSpark$default$5();
        Seq<String> x$70 = this.runSpark$default$6();
        Map<String, String> x$71 = this.runSpark$default$8();
        Option<File> x$72 = this.runSpark$default$9();
        SparkAppHandle.State finalState = this.runSpark(x$64, x$65, (Seq<String>)x$66, x$68, x$69, x$70, (Map<String, String>)x$67, x$71, x$72);
        this.checkResult(finalState, result, "true", this.checkResult$default$4());
    }

    public YarnClusterSuite() {
        this.test("run Spark in yarn-client mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testBasicYarnApp(true, this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testBasicYarnApp$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        this.test("run Spark in yarn-cluster mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testBasicYarnApp(false, this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testBasicYarnApp$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        this.test("run Spark in yarn-client mode with different configurations, ensuring redaction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testBasicYarnApp(true, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.driver.memory"), (Object)"512m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.cores"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.memory"), (Object)"512m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.instances"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executorEnv.HADOOP_CREDSTORE_PASSWORD"), (Object)YarnClusterDriver$.MODULE$.SECRET_PASSWORD()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.appMasterEnv.HADOOP_CREDSTORE_PASSWORD"), (Object)YarnClusterDriver$.MODULE$.SECRET_PASSWORD())}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("run Spark in yarn-cluster mode with different configurations, ensuring redaction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testBasicYarnApp(false, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.driver.memory"), (Object)"512m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.driver.cores"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.cores"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.memory"), (Object)"512m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.instances"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executorEnv.HADOOP_CREDSTORE_PASSWORD"), (Object)YarnClusterDriver$.MODULE$.SECRET_PASSWORD()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.appMasterEnv.HADOOP_CREDSTORE_PASSWORD"), (Object)YarnClusterDriver$.MODULE$.SECRET_PASSWORD())}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("yarn-cluster should respect conf overrides in SparkHadoopUtil (SPARK-16414, SPARK-23630)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File customConf = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String coreSite = new StringOps(Predef$.MODULE$.augmentString("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n      |<configuration>\n      |  <property>\n      |    <name>spark.test.key</name>\n      |    <value>testvalue</value>\n      |  </property>\n      |</configuration>\n      |")).stripMargin();
                Files.write((CharSequence)coreSite, (File)new File(customConf, "core-site.xml"), (Charset)StandardCharsets.UTF_8);
                File result = File.createTempFile("result", null, this.$outer.tempDir());
                boolean x$6 = false;
                String x$7 = this.$outer.mainClassName(YarnClusterDriverUseSparkHadoopUtilConf$.MODULE$.getClass());
                Seq x$8 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key=value", "spark.test.key=testvalue", result.getAbsolutePath()}));
                Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.hadoop.key"), (Object)"value")}));
                Map x$10 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_TEST_HADOOP_CONF_DIR"), (Object)customConf.getAbsolutePath())}));
                Seq<Tuple2<String, String>> x$11 = this.$outer.runSpark$default$4();
                Seq<String> x$12 = this.$outer.runSpark$default$5();
                Seq<String> x$13 = this.$outer.runSpark$default$6();
                Option<File> x$14 = this.$outer.runSpark$default$9();
                SparkAppHandle.State finalState = this.$outer.runSpark(x$6, x$7, (Seq<String>)x$8, x$11, x$12, x$13, (Map<String, String>)x$9, (Map<String, String>)x$10, x$14);
                this.$outer.checkResult(finalState, result, this.$outer.checkResult$default$3(), this.$outer.checkResult$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        this.test("run Spark in yarn-client mode with additional jar", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testWithAddJar(true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        this.test("run Spark in yarn-cluster mode with additional jar", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testWithAddJar(false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        this.test("run Spark in yarn-cluster mode unsuccessfully", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final Assertion apply() {
                SparkAppHandle.State finalState = this.$outer.runSpark(false, this.$outer.mainClassName(YarnClusterDriver$.MODULE$.getClass()), this.$outer.runSpark$default$3(), this.$outer.runSpark$default$4(), this.$outer.runSpark$default$5(), this.$outer.runSpark$default$6(), this.$outer.runSpark$default$7(), this.$outer.runSpark$default$8(), this.$outer.runSpark$default$9());
                return this.$outer.convertToAnyShouldWrapper(finalState, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150), Prettifier$.MODULE$.default()).should(this.$outer.be().apply((Object)SparkAppHandle.State.FAILED));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        this.test("run Spark in yarn-cluster mode failure after sc initialized", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final Assertion apply() {
                SparkAppHandle.State finalState = this.$outer.runSpark(false, this.$outer.mainClassName(YarnClusterDriverWithFailure$.MODULE$.getClass()), this.$outer.runSpark$default$3(), this.$outer.runSpark$default$4(), this.$outer.runSpark$default$5(), this.$outer.runSpark$default$6(), this.$outer.runSpark$default$7(), this.$outer.runSpark$default$8(), this.$outer.runSpark$default$9());
                return this.$outer.convertToAnyShouldWrapper(finalState, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155), Prettifier$.MODULE$.default()).should(this.$outer.be().apply((Object)SparkAppHandle.State.FAILED));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        this.test("run Python application in yarn-client mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testPySpark(true, this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testPySpark$default$2(), this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testPySpark$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("run Python application in yarn-cluster mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testPySpark(false, this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testPySpark$default$2(), this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testPySpark$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        this.test("run Python application in yarn-cluster mode using spark.yarn.appMasterEnv to override local envvar", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testPySpark(false, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.appMasterEnv.PYSPARK_DRIVER_PYTHON"), scala.sys.package$.MODULE$.env().getOrElse((Object)"PYSPARK_DRIVER_PYTHON", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "python";
                    }
                })), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.appMasterEnv.PYSPARK_PYTHON"), scala.sys.package$.MODULE$.env().getOrElse((Object)"PYSPARK_PYTHON", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "python";
                    }
                }))}))), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYSPARK_DRIVER_PYTHON"), (Object)"not python"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYSPARK_PYTHON"), (Object)"not python")}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.test("user class path first in client mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testUseClassPathFirst(true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        this.test("user class path first in cluster mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testUseClassPathFirst(false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test("monitor app using launcher library", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            /*
             * WARNING - void declaration
             */
            public final Object apply() {
                Object object;
                HashMap<String, String> env = new HashMap<String, String>();
                env.put("YARN_CONF_DIR", this.$outer.hadoopConfDir().getAbsolutePath());
                String propsFile = this.$outer.createConfFile(this.$outer.createConfFile$default$1(), this.$outer.createConfFile$default$2());
                SparkAppHandle handle = new SparkLauncher(env).setSparkHome((String)scala.sys.package$.MODULE$.props().apply((Object)"spark.test.home")).setConf("spark.ui.enabled", "false").setPropertiesFile(propsFile).setMaster("yarn").setDeployMode("client").setAppResource("spark-internal").setMainClass(this.$outer.mainClassName(YarnLauncherTestApp$.MODULE$.getClass())).startApplication(new SparkAppHandle.Listener[0]);
                try {
                    Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).seconds())), Eventually$.MODULE$.interval(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).millis())), (Function0)new Serializable(this, handle){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$17 $outer;
                        private final SparkAppHandle handle$1;

                        public final Assertion apply() {
                            return this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$anonfun$$$outer().convertToAnyShouldWrapper(this.handle$1.getState(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205), Prettifier$.MODULE$.default()).should(this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$anonfun$$$outer().be().apply((Object)SparkAppHandle.State.RUNNING));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.handle$1 = handle$1;
                        }
                    }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
                    this.$outer.convertToStringShouldWrapper(handle.getAppId(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208), Prettifier$.MODULE$.default()).should(this.$outer.not()).be(null, Predef$.MODULE$.$conforms());
                    this.$outer.convertToStringShouldWrapper(handle.getAppId(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209), Prettifier$.MODULE$.default()).should(this.$outer.startWith().apply("application_"));
                    handle.stop();
                    object = Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).seconds())), Eventually$.MODULE$.interval(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).millis())), (Function0)new Serializable(this, handle){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$17 $outer;
                        private final SparkAppHandle handle$1;

                        public final Assertion apply() {
                            return this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$anonfun$$$outer().convertToAnyShouldWrapper(this.handle$1.getState(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213), Prettifier$.MODULE$.default()).should(this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$anonfun$$$outer().be().apply((Object)SparkAppHandle.State.KILLED));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.handle$1 = handle$1;
                        }
                    }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
                }
                catch (Throwable throwable) {
                    void var3_3;
                    var3_3.kill();
                    throw throwable;
                }
                handle.kill();
                return object;
            }

            public /* synthetic */ YarnClusterSuite org$apache$spark$deploy$yarn$YarnClusterSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        this.test("timeout to get SparkContext in cluster mode triggers failure", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final Assertion apply() {
                int timeout = 2000;
                boolean x$15 = false;
                String x$16 = this.$outer.mainClassName(SparkContextTimeoutApp$.MODULE$.getClass());
                Seq x$17 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)(timeout * 4))).toString()}));
                Map x$18 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.AM_MAX_WAIT_TIME().key()), (Object)((Object)BoxesRunTime.boxToInteger((int)timeout)).toString())}));
                Seq<Tuple2<String, String>> x$19 = this.$outer.runSpark$default$4();
                Seq<String> x$20 = this.$outer.runSpark$default$5();
                Seq<String> x$21 = this.$outer.runSpark$default$6();
                Map<String, String> x$22 = this.$outer.runSpark$default$8();
                Option<File> x$23 = this.$outer.runSpark$default$9();
                SparkAppHandle.State finalState = this.$outer.runSpark(x$15, x$16, (Seq<String>)x$17, x$19, x$20, x$21, (Map<String, String>)x$18, x$22, x$23);
                return this.$outer.convertToAnyShouldWrapper(finalState, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225), Prettifier$.MODULE$.default()).should(this.$outer.be().apply((Object)SparkAppHandle.State.FAILED));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        this.test("executor env overwrite AM env in client mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testExecutorEnv(true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        this.test("executor env overwrite AM env in cluster mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$yarn$YarnClusterSuite$$testExecutorEnv(false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
    }
}

