/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.yarn.FailureTracker;
import org.apache.spark.deploy.yarn.YarnAllocatorNodeHealthTracker;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality;
import org.scalactic.Explicitly;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.Tolerance;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Entry;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.enablers.Collecting;
import org.scalatest.matchers.Matcher;
import org.scalatest.matchers.dsl.BeWord;
import org.scalatest.matchers.dsl.ContainWord;
import org.scalatest.matchers.dsl.DefinedWord;
import org.scalatest.matchers.dsl.EmptyWord;
import org.scalatest.matchers.dsl.EndWithWord;
import org.scalatest.matchers.dsl.ExistWord;
import org.scalatest.matchers.dsl.FullyMatchWord;
import org.scalatest.matchers.dsl.HaveWord;
import org.scalatest.matchers.dsl.IncludeWord;
import org.scalatest.matchers.dsl.LengthWord;
import org.scalatest.matchers.dsl.MatchPatternWord;
import org.scalatest.matchers.dsl.MatcherFactory1;
import org.scalatest.matchers.dsl.MatcherWords;
import org.scalatest.matchers.dsl.NoExceptionWord;
import org.scalatest.matchers.dsl.NotWord;
import org.scalatest.matchers.dsl.ReadableWord;
import org.scalatest.matchers.dsl.ResultOfATypeInvocation;
import org.scalatest.matchers.dsl.ResultOfAllElementsOfApplication;
import org.scalatest.matchers.dsl.ResultOfAllOfApplication;
import org.scalatest.matchers.dsl.ResultOfAnTypeInvocation;
import org.scalatest.matchers.dsl.ResultOfAtLeastOneElementOfApplication;
import org.scalatest.matchers.dsl.ResultOfAtLeastOneOfApplication;
import org.scalatest.matchers.dsl.ResultOfAtMostOneElementOfApplication;
import org.scalatest.matchers.dsl.ResultOfAtMostOneOfApplication;
import org.scalatest.matchers.dsl.ResultOfDefinedAt;
import org.scalatest.matchers.dsl.ResultOfGreaterThanComparison;
import org.scalatest.matchers.dsl.ResultOfGreaterThanOrEqualToComparison;
import org.scalatest.matchers.dsl.ResultOfInOrderApplication;
import org.scalatest.matchers.dsl.ResultOfInOrderElementsOfApplication;
import org.scalatest.matchers.dsl.ResultOfInOrderOnlyApplication;
import org.scalatest.matchers.dsl.ResultOfLessThanComparison;
import org.scalatest.matchers.dsl.ResultOfLessThanOrEqualToComparison;
import org.scalatest.matchers.dsl.ResultOfMessageWordApplication;
import org.scalatest.matchers.dsl.ResultOfNoElementsOfApplication;
import org.scalatest.matchers.dsl.ResultOfNoneOfApplication;
import org.scalatest.matchers.dsl.ResultOfOfTypeInvocation;
import org.scalatest.matchers.dsl.ResultOfOneElementOfApplication;
import org.scalatest.matchers.dsl.ResultOfOneOfApplication;
import org.scalatest.matchers.dsl.ResultOfOnlyApplication;
import org.scalatest.matchers.dsl.ResultOfTheSameElementsAsApplication;
import org.scalatest.matchers.dsl.ResultOfTheSameElementsInOrderAsApplication;
import org.scalatest.matchers.dsl.ResultOfTheTypeInvocation;
import org.scalatest.matchers.dsl.ResultOfThrownByApplication;
import org.scalatest.matchers.dsl.SizeWord;
import org.scalatest.matchers.dsl.SortedWord;
import org.scalatest.matchers.dsl.StartWithWord;
import org.scalatest.matchers.dsl.WritableWord;
import org.scalatest.matchers.must.Matchers;
import org.scalatest.matchers.must.Matchers$AtLeastCollected$;
import org.scalatest.matchers.must.Matchers$AtMostCollected$;
import org.scalatest.matchers.must.Matchers$BetweenCollected$;
import org.scalatest.matchers.must.Matchers$ExactlyCollected$;
import org.scalatest.verbs.CompileWord;
import org.scalatest.verbs.MustVerb;
import org.scalatest.verbs.TypeCheckWord;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.GenTraversable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001\u0002\n\u0014\u0001yAQ!\r\u0001\u0005\u0002IBq!\u000e\u0001C\u0002\u0013\u0005a\u0007\u0003\u0004>\u0001\u0001\u0006Ia\u000e\u0005\b}\u0001\u0011\r\u0011\"\u0001@\u0011\u0019\u0019\u0005\u0001)A\u0005\u0001\"IA\t\u0001a\u0001\u0002\u0004%\t!\u0012\u0005\n\u0013\u0002\u0001\r\u00111A\u0005\u0002)C\u0011\u0002\u0015\u0001A\u0002\u0003\u0005\u000b\u0015\u0002$\t\u0013E\u0003\u0001\u0019!a\u0001\n\u0003\u0011\u0006\"\u0003;\u0001\u0001\u0004\u0005\r\u0011\"\u0001v\u0011%9\b\u00011A\u0001B\u0003&1\u000bC\u0005y\u0001\u0001\u0007\t\u0019!C\u0001s\"Y\u0011\u0011\u0001\u0001A\u0002\u0003\u0007I\u0011AA\u0002\u0011)\t9\u0001\u0001a\u0001\u0002\u0003\u0006KA\u001f\u0005\b\u0003\u0013\u0001A\u0011IA\u0006\u0011\u001d\ti\u0001\u0001C\u0005\u0003\u001fA\u0011\"!\u0007\u0001#\u0003%I!a\u0007\u0003?e\u000b'O\\!mY>\u001c\u0017\r^8s\u0011\u0016\fG\u000e\u001e5Ue\u0006\u001c7.\u001a:Tk&$XM\u0003\u0002\u0015+\u0005!\u00110\u0019:o\u0015\t1r#\u0001\u0004eKBdw.\u001f\u0006\u00031e\tQa\u001d9be.T!AG\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0012aA8sO\u000e\u00011\u0003\u0002\u0001 G5\u0002\"\u0001I\u0011\u000e\u0003]I!AI\f\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t!3&D\u0001&\u0015\t1s%\u0001\u0003nkN$(B\u0001\u0015*\u0003!i\u0017\r^2iKJ\u001c(B\u0001\u0016\u001c\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002-K\tAQ*\u0019;dQ\u0016\u00148\u000f\u0005\u0002/_5\t\u0011&\u0003\u00021S\t\u0011\")\u001a4pe\u0016\fe\u000eZ!gi\u0016\u0014X)Y2i\u0003\u0019a\u0014N\\5u}Q\t1\u0007\u0005\u00025\u00015\t1#A\bF1\u000ecU\u000bR#`)&kUiT+U+\u00059\u0004C\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ$\u0001\u0002'p]\u001e\f\u0001#\u0012-D\u0019V#Ui\u0018+J\u001b\u0016{U\u000b\u0016\u0011\u0002=5\u000b\u0005l\u0018$B\u00132+EiX#Y\u000b\u000e{\u0006+\u0012*`\u001d>#Ui\u0018,B\u0019V+U#\u0001!\u0011\u0005a\n\u0015B\u0001\":\u0005\rIe\u000e^\u0001 \u001b\u0006CvLR!J\u0019\u0016#u,\u0012-F\u0007~\u0003VIU0O\u001f\u0012+uLV!M+\u0016\u0003\u0013!C:qCJ\\7i\u001c8g+\u00051\u0005C\u0001\u0011H\u0013\tAuCA\u0005Ta\u0006\u00148nQ8oM\u0006i1\u000f]1sW\u000e{gNZ0%KF$\"a\u0013(\u0011\u0005ab\u0015BA':\u0005\u0011)f.\u001b;\t\u000f=;\u0011\u0011!a\u0001\r\u0006\u0019\u0001\u0010J\u0019\u0002\u0015M\u0004\u0018M]6D_:4\u0007%\u0001\u0007b[\u000ec\u0017.\u001a8u\u001b>\u001c7.F\u0001T!\r!FLX\u0007\u0002+*\u0011akV\u0001\u0004CBL'B\u0001-Z\u0003\u0019\u0019G.[3oi*\u0011AC\u0017\u0006\u00037f\ta\u0001[1e_>\u0004\u0018BA/V\u0005)\tUJU'DY&,g\u000e\u001e\t\u0003?Ft!\u0001Y8\u000f\u0005\u0005tgB\u00012n\u001d\t\u0019GN\u0004\u0002eW:\u0011QM\u001b\b\u0003M&l\u0011a\u001a\u0006\u0003Qv\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000f\n\u0005iY\u0012BA.\u001a\u0013\t!\",\u0003\u0002Y3&\u0011akV\u0005\u0003aV\u000b!\"Q'S\u001b\u000ec\u0017.\u001a8u\u0013\t\u00118O\u0001\tD_:$\u0018-\u001b8feJ+\u0017/^3ti*\u0011\u0001/V\u0001\u0011C6\u001cE.[3oi6{7m[0%KF$\"a\u0013<\t\u000f=S\u0011\u0011!a\u0001'\u0006i\u0011-\\\"mS\u0016tG/T8dW\u0002\nQa\u00197pG.,\u0012A\u001f\t\u0003wzl\u0011\u0001 \u0006\u0003{^\tA!\u001e;jY&\u0011q\u0010 \u0002\f\u001b\u0006tW/\u00197DY>\u001c7.A\u0005dY>\u001c7n\u0018\u0013fcR\u00191*!\u0002\t\u000f=k\u0011\u0011!a\u0001u\u000611\r\\8dW\u0002\n!BY3g_J,W)Y2i)\u0005Y\u0015\u0001I2sK\u0006$X-W1s]\u0006cGn\\2bi>\u0014\b*Z1mi\"$&/Y2lKJ$B!!\u0005\u0002\u0018A\u0019A'a\u0005\n\u0007\u0005U1C\u0001\u0010ZCJt\u0017\t\u001c7pG\u0006$xN\u001d(pI\u0016DU-\u00197uQR\u0013\u0018mY6fe\"9A\t\u0005I\u0001\u0002\u00041\u0015AK2sK\u0006$X-W1s]\u0006cGn\\2bi>\u0014\b*Z1mi\"$&/Y2lKJ$C-\u001a4bk2$H%M\u000b\u0003\u0003;Q3ARA\u0010W\t\t\t\u0003\u0005\u0003\u0002$\u00055RBAA\u0013\u0015\u0011\t9#!\u000b\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0016s\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0012Q\u0005\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class YarnAllocatorHealthTrackerSuite
extends SparkFunSuite
implements Matchers {
    private final long EXCLUDE_TIMEOUT;
    private final int MAX_FAILED_EXEC_PER_NODE_VALUE;
    private SparkConf sparkConf;
    private AMRMClient<AMRMClient.ContainerRequest> amClientMock;
    private ManualClock clock;
    private final Matchers.KeyWord key;
    private final Matchers.ValueWord value;
    private final Matchers.AWord a;
    private final Matchers.AnWord an;
    private final Matchers.TheSameInstanceAsPhrase theSameInstanceAs;
    private final Matchers.RegexWord regex;
    private final Matchers.Collected org$scalatest$matchers$must$Matchers$$AllCollected;
    private final Matchers.Collected org$scalatest$matchers$must$Matchers$$EveryCollected;
    private volatile Matchers$BetweenCollected$ BetweenCollected$module;
    private volatile Matchers$AtLeastCollected$ AtLeastCollected$module;
    private volatile Matchers$AtMostCollected$ AtMostCollected$module;
    private final Matchers.Collected org$scalatest$matchers$must$Matchers$$NoCollected;
    private volatile Matchers$ExactlyCollected$ ExactlyCollected$module;
    private final Matchers.MustMethodHelperClass org$scalatest$matchers$must$Matchers$$MustMethodHelper;
    private final Explicitly.DecidedWord decided;
    private final Explicitly.DeterminedWord determined;
    private final Explicitly.TheAfterWord after;
    private final FullyMatchWord fullyMatch;
    private final StartWithWord startWith;
    private final EndWithWord endWith;
    private final IncludeWord include;
    private final HaveWord have;
    private final BeWord be;
    private final ContainWord contain;
    private final NotWord not;
    private final LengthWord length;
    private final SizeWord size;
    private final SortedWord sorted;
    private final DefinedWord defined;
    private final ExistWord exist;
    private final ReadableWord readable;
    private final WritableWord writable;
    private final EmptyWord empty;
    private final CompileWord compile;
    private final TypeCheckWord typeCheck;
    private final MatchPatternWord matchPattern;

    public Matchers.HavePropertyMatcherGenerator convertSymbolToHavePropertyMatcherGenerator(Symbol symbol, Prettifier prettifier, Position pos) {
        return Matchers.convertSymbolToHavePropertyMatcherGenerator$((Matchers)this, (Symbol)symbol, (Prettifier)prettifier, (Position)pos);
    }

    public <T> Matcher<T> equal(TripleEqualsSupport.Spread<T> spread) {
        return Matchers.equal$((Matchers)this, spread);
    }

    public Matcher<Object> equal(Null$ o) {
        return Matchers.equal$((Matchers)this, (Null$)o);
    }

    public <T> ResultOfLessThanComparison<T> $less(T right, Ordering<T> evidence$1) {
        return Matchers.$less$((Matchers)this, right, evidence$1);
    }

    public <T> ResultOfGreaterThanComparison<T> $greater(T right, Ordering<T> evidence$2) {
        return Matchers.$greater$((Matchers)this, right, evidence$2);
    }

    public <T> ResultOfLessThanOrEqualToComparison<T> $less$eq(T right, Ordering<T> evidence$3) {
        return Matchers.$less$eq$((Matchers)this, right, evidence$3);
    }

    public <T> ResultOfGreaterThanOrEqualToComparison<T> $greater$eq(T right, Ordering<T> evidence$4) {
        return Matchers.$greater$eq$((Matchers)this, right, evidence$4);
    }

    public <T> ResultOfDefinedAt<T> definedAt(T right) {
        return Matchers.definedAt$((Matchers)this, right);
    }

    public ResultOfOneOfApplication oneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.oneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfOneElementOfApplication oneElementOf(GenTraversable<Object> elements) {
        return Matchers.oneElementOf$((Matchers)this, elements);
    }

    public ResultOfAtLeastOneOfApplication atLeastOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atLeastOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAtLeastOneElementOfApplication atLeastOneElementOf(GenTraversable<Object> elements) {
        return Matchers.atLeastOneElementOf$((Matchers)this, elements);
    }

    public ResultOfNoneOfApplication noneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.noneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfNoElementsOfApplication noElementsOf(GenTraversable<Object> elements) {
        return Matchers.noElementsOf$((Matchers)this, elements);
    }

    public ResultOfTheSameElementsAsApplication theSameElementsAs(GenTraversable<?> xs) {
        return Matchers.theSameElementsAs$((Matchers)this, xs);
    }

    public ResultOfTheSameElementsInOrderAsApplication theSameElementsInOrderAs(GenTraversable<?> xs) {
        return Matchers.theSameElementsInOrderAs$((Matchers)this, xs);
    }

    public ResultOfOnlyApplication only(Seq<Object> xs, Position pos) {
        return Matchers.only$((Matchers)this, xs, (Position)pos);
    }

    public <T> ResultOfInOrderOnlyApplication inOrderOnly(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrderOnly$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAllOfApplication allOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.allOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAllElementsOfApplication allElementsOf(GenTraversable<R> elements) {
        return Matchers.allElementsOf$((Matchers)this, elements);
    }

    public ResultOfInOrderApplication inOrder(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrder$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfInOrderElementsOfApplication inOrderElementsOf(GenTraversable<R> elements) {
        return Matchers.inOrderElementsOf$((Matchers)this, elements);
    }

    public ResultOfAtMostOneOfApplication atMostOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atMostOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAtMostOneElementOfApplication atMostOneElementOf(GenTraversable<R> elements) {
        return Matchers.atMostOneElementOf$((Matchers)this, elements);
    }

    public ResultOfThrownByApplication thrownBy(Function0<Object> fun) {
        return Matchers.thrownBy$((Matchers)this, fun);
    }

    public ResultOfMessageWordApplication message(String expectedMessage) {
        return Matchers.message$((Matchers)this, (String)expectedMessage);
    }

    public <T> Assertion doCollected(Matchers.Collected collected, GenTraversable<T> xs, Object original, Prettifier prettifier, Position pos, Function1<T, Assertion> fun) {
        return Matchers.doCollected$((Matchers)this, (Matchers.Collected)collected, xs, (Object)original, (Prettifier)prettifier, (Position)pos, fun);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> all(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends GenMap<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> all(MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> all(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> all(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atLeast(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends GenMap<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> atLeast(int num, MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atLeast(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atLeast(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> every(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> every(MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> every(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> every(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> exactly(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends GenMap<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> exactly(int num, MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> exactly(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> exactly(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> no(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> no(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> no(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> between(int from, int upTo, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> between(int from, int upTo, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> between(int from, int upTo, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atMost(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends GenMap<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> atMost(int num, MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atMost(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atMost(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <T> ResultOfATypeInvocation<T> a(ClassTag<T> evidence$5) {
        return Matchers.a$((Matchers)this, evidence$5);
    }

    public <T> ResultOfAnTypeInvocation<T> an(ClassTag<T> evidence$6) {
        return Matchers.an$((Matchers)this, evidence$6);
    }

    public <T> ResultOfTheTypeInvocation<T> the(ClassTag<T> evidence$7, Position pos) {
        return Matchers.the$((Matchers)this, evidence$7, (Position)pos);
    }

    public <T> Matchers.AnyMustWrapper<T> convertToAnyMustWrapper(T o, Position pos, Prettifier prettifier) {
        return Matchers.convertToAnyMustWrapper$((Matchers)this, o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.StringMustWrapper convertToStringMustWrapper(String o, Position pos, Prettifier prettifier) {
        return Matchers.convertToStringMustWrapper$((Matchers)this, (String)o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.RegexWrapper convertToRegexWrapper(Regex o) {
        return Matchers.convertToRegexWrapper$((Matchers)this, (Regex)o);
    }

    public <T> ResultOfOfTypeInvocation<T> of(ClassTag<T> ev) {
        return Matchers.of$((Matchers)this, ev);
    }

    public NoExceptionWord noException(Position pos) {
        return MatcherWords.noException$((MatcherWords)this, (Position)pos);
    }

    public MatcherFactory1<Object, Equality> equal(Object right) {
        return MatcherWords.equal$((MatcherWords)this, (Object)right);
    }

    public MustVerb.StringMustWrapperForVerb convertToStringMustWrapperForVerb(String o, Position position) {
        return MustVerb.convertToStringMustWrapperForVerb$((MustVerb)this, (String)o, (Position)position);
    }

    public <T> Tolerance.PlusOrMinusWrapper<T> convertNumericToPlusOrMinusWrapper(T pivot, Numeric<T> evidence$2) {
        return Tolerance.convertNumericToPlusOrMinusWrapper$((Tolerance)this, pivot, evidence$2);
    }

    public Matchers.KeyWord key() {
        return this.key;
    }

    public Matchers.ValueWord value() {
        return this.value;
    }

    public Matchers.AWord a() {
        return this.a;
    }

    public Matchers.AnWord an() {
        return this.an;
    }

    public Matchers.TheSameInstanceAsPhrase theSameInstanceAs() {
        return this.theSameInstanceAs;
    }

    public Matchers.RegexWord regex() {
        return this.regex;
    }

    public Matchers.Collected org$scalatest$matchers$must$Matchers$$AllCollected() {
        return this.org$scalatest$matchers$must$Matchers$$AllCollected;
    }

    public Matchers.Collected org$scalatest$matchers$must$Matchers$$EveryCollected() {
        return this.org$scalatest$matchers$must$Matchers$$EveryCollected;
    }

    public Matchers$BetweenCollected$ org$scalatest$matchers$must$Matchers$$BetweenCollected() {
        if (this.BetweenCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$BetweenCollected$lzycompute$1();
        }
        return this.BetweenCollected$module;
    }

    public Matchers$AtLeastCollected$ org$scalatest$matchers$must$Matchers$$AtLeastCollected() {
        if (this.AtLeastCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$AtLeastCollected$lzycompute$1();
        }
        return this.AtLeastCollected$module;
    }

    public Matchers$AtMostCollected$ org$scalatest$matchers$must$Matchers$$AtMostCollected() {
        if (this.AtMostCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$AtMostCollected$lzycompute$1();
        }
        return this.AtMostCollected$module;
    }

    public Matchers.Collected org$scalatest$matchers$must$Matchers$$NoCollected() {
        return this.org$scalatest$matchers$must$Matchers$$NoCollected;
    }

    public Matchers$ExactlyCollected$ org$scalatest$matchers$must$Matchers$$ExactlyCollected() {
        if (this.ExactlyCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$ExactlyCollected$lzycompute$1();
        }
        return this.ExactlyCollected$module;
    }

    public Matchers.MustMethodHelperClass org$scalatest$matchers$must$Matchers$$MustMethodHelper() {
        return this.org$scalatest$matchers$must$Matchers$$MustMethodHelper;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$key_$eq(Matchers.KeyWord x$1) {
        this.key = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$value_$eq(Matchers.ValueWord x$1) {
        this.value = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$a_$eq(Matchers.AWord x$1) {
        this.a = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$an_$eq(Matchers.AnWord x$1) {
        this.an = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$theSameInstanceAs_$eq(Matchers.TheSameInstanceAsPhrase x$1) {
        this.theSameInstanceAs = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$regex_$eq(Matchers.RegexWord x$1) {
        this.regex = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$AllCollected_$eq(Matchers.Collected x$1) {
        this.org$scalatest$matchers$must$Matchers$$AllCollected = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$EveryCollected_$eq(Matchers.Collected x$1) {
        this.org$scalatest$matchers$must$Matchers$$EveryCollected = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$NoCollected_$eq(Matchers.Collected x$1) {
        this.org$scalatest$matchers$must$Matchers$$NoCollected = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$MustMethodHelper_$eq(Matchers.MustMethodHelperClass x$1) {
        this.org$scalatest$matchers$must$Matchers$$MustMethodHelper = x$1;
    }

    public Explicitly.DecidedWord decided() {
        return this.decided;
    }

    public Explicitly.DeterminedWord determined() {
        return this.determined;
    }

    public Explicitly.TheAfterWord after() {
        return this.after;
    }

    public void org$scalactic$Explicitly$_setter_$decided_$eq(Explicitly.DecidedWord x$1) {
        this.decided = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$determined_$eq(Explicitly.DeterminedWord x$1) {
        this.determined = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$after_$eq(Explicitly.TheAfterWord x$1) {
        this.after = x$1;
    }

    public FullyMatchWord fullyMatch() {
        return this.fullyMatch;
    }

    public StartWithWord startWith() {
        return this.startWith;
    }

    public EndWithWord endWith() {
        return this.endWith;
    }

    public IncludeWord include() {
        return this.include;
    }

    public HaveWord have() {
        return this.have;
    }

    public BeWord be() {
        return this.be;
    }

    public ContainWord contain() {
        return this.contain;
    }

    public NotWord not() {
        return this.not;
    }

    public LengthWord length() {
        return this.length;
    }

    public SizeWord size() {
        return this.size;
    }

    public SortedWord sorted() {
        return this.sorted;
    }

    public DefinedWord defined() {
        return this.defined;
    }

    public ExistWord exist() {
        return this.exist;
    }

    public ReadableWord readable() {
        return this.readable;
    }

    public WritableWord writable() {
        return this.writable;
    }

    public EmptyWord empty() {
        return this.empty;
    }

    public CompileWord compile() {
        return this.compile;
    }

    public TypeCheckWord typeCheck() {
        return this.typeCheck;
    }

    public MatchPatternWord matchPattern() {
        return this.matchPattern;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$fullyMatch_$eq(FullyMatchWord x$1) {
        this.fullyMatch = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$startWith_$eq(StartWithWord x$1) {
        this.startWith = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$endWith_$eq(EndWithWord x$1) {
        this.endWith = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$include_$eq(IncludeWord x$1) {
        this.include = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$have_$eq(HaveWord x$1) {
        this.have = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$be_$eq(BeWord x$1) {
        this.be = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$contain_$eq(ContainWord x$1) {
        this.contain = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$not_$eq(NotWord x$1) {
        this.not = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$length_$eq(LengthWord x$1) {
        this.length = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$size_$eq(SizeWord x$1) {
        this.size = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$sorted_$eq(SortedWord x$1) {
        this.sorted = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$defined_$eq(DefinedWord x$1) {
        this.defined = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$exist_$eq(ExistWord x$1) {
        this.exist = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$readable_$eq(ReadableWord x$1) {
        this.readable = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$writable_$eq(WritableWord x$1) {
        this.writable = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$empty_$eq(EmptyWord x$1) {
        this.empty = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$compile_$eq(CompileWord x$1) {
        this.compile = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$typeCheck_$eq(TypeCheckWord x$1) {
        this.typeCheck = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$matchPattern_$eq(MatchPatternWord x$1) {
        this.matchPattern = x$1;
    }

    public long EXCLUDE_TIMEOUT() {
        return this.EXCLUDE_TIMEOUT;
    }

    public int MAX_FAILED_EXEC_PER_NODE_VALUE() {
        return this.MAX_FAILED_EXEC_PER_NODE_VALUE;
    }

    public SparkConf sparkConf() {
        return this.sparkConf;
    }

    public void sparkConf_$eq(SparkConf x$1) {
        this.sparkConf = x$1;
    }

    public AMRMClient<AMRMClient.ContainerRequest> amClientMock() {
        return this.amClientMock;
    }

    public void amClientMock_$eq(AMRMClient<AMRMClient.ContainerRequest> x$1) {
        this.amClientMock = x$1;
    }

    public ManualClock clock() {
        return this.clock;
    }

    public void clock_$eq(ManualClock x$1) {
        this.clock = x$1;
    }

    public void beforeEach() {
        this.sparkConf_$eq(new SparkConf());
        this.sparkConf().set(org.apache.spark.internal.config.package$.MODULE$.EXCLUDE_ON_FAILURE_TIMEOUT_CONF(), (Object)BoxesRunTime.boxToLong((long)this.EXCLUDE_TIMEOUT()));
        this.sparkConf().set(package$.MODULE$.YARN_EXECUTOR_LAUNCH_EXCLUDE_ON_FAILURE_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.sparkConf().set(org.apache.spark.internal.config.package$.MODULE$.MAX_FAILED_EXEC_PER_NODE(), (Object)BoxesRunTime.boxToInteger((int)this.MAX_FAILED_EXEC_PER_NODE_VALUE()));
        this.clock_$eq(new ManualClock());
        this.amClientMock_$eq((AMRMClient<AMRMClient.ContainerRequest>)((AMRMClient)Mockito.mock(AMRMClient.class)));
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    /*
     * WARNING - void declaration
     */
    private YarnAllocatorNodeHealthTracker createYarnAllocatorHealthTracker(SparkConf sparkConf) {
        void var3_3;
        FailureTracker failureTracker = new FailureTracker(sparkConf, (Clock)this.clock());
        YarnAllocatorNodeHealthTracker yarnHealthTracker = new YarnAllocatorNodeHealthTracker(sparkConf, this.amClientMock(), failureTracker);
        yarnHealthTracker.setNumClusterNodes(4);
        return var3_3;
    }

    private SparkConf createYarnAllocatorHealthTracker$default$1() {
        return this.sparkConf();
    }

    private final void org$scalatest$matchers$must$Matchers$$BetweenCollected$lzycompute$1() {
        YarnAllocatorHealthTrackerSuite yarnAllocatorHealthTrackerSuite = this;
        synchronized (yarnAllocatorHealthTrackerSuite) {
            if (this.BetweenCollected$module == null) {
                this.BetweenCollected$module = new Matchers$BetweenCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$matchers$must$Matchers$$AtLeastCollected$lzycompute$1() {
        YarnAllocatorHealthTrackerSuite yarnAllocatorHealthTrackerSuite = this;
        synchronized (yarnAllocatorHealthTrackerSuite) {
            if (this.AtLeastCollected$module == null) {
                this.AtLeastCollected$module = new Matchers$AtLeastCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$matchers$must$Matchers$$AtMostCollected$lzycompute$1() {
        YarnAllocatorHealthTrackerSuite yarnAllocatorHealthTrackerSuite = this;
        synchronized (yarnAllocatorHealthTrackerSuite) {
            if (this.AtMostCollected$module == null) {
                this.AtMostCollected$module = new Matchers$AtMostCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$matchers$must$Matchers$$ExactlyCollected$lzycompute$1() {
        YarnAllocatorHealthTrackerSuite yarnAllocatorHealthTrackerSuite = this;
        synchronized (yarnAllocatorHealthTrackerSuite) {
            if (this.ExactlyCollected$module == null) {
                this.ExactlyCollected$module = new Matchers$ExactlyCollected$((Matchers)this);
            }
        }
    }

    public YarnAllocatorHealthTrackerSuite() {
        Tolerance.$init$((Tolerance)this);
        MustVerb.$init$((MustVerb)this);
        MatcherWords.$init$((MatcherWords)this);
        Explicitly.$init$((Explicitly)this);
        Matchers.$init$((Matchers)this);
        this.EXCLUDE_TIMEOUT = 100L;
        this.MAX_FAILED_EXEC_PER_NODE_VALUE = 2;
        this.test("expiring its own excluded nodes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            YarnAllocatorNodeHealthTracker yarnHealthTracker = this.createYarnAllocatorHealthTracker(this.createYarnAllocatorHealthTracker$default$1());
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.MAX_FAILED_EXEC_PER_NODE_VALUE()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> {
                yarnHealthTracker.handleResourceAllocationFailure((Option)new Some((Object)"host"));
                ((AMRMClient)Mockito.verify(this.amClientMock(), (VerificationMode)Mockito.never())).updateBlacklist(Arrays.asList((Object[])new String[]{"host"}), Collections.emptyList());
            });
            yarnHealthTracker.handleResourceAllocationFailure((Option)new Some((Object)"host"));
            ((AMRMClient)Mockito.verify(this.amClientMock())).updateBlacklist(Arrays.asList((Object[])new String[]{"host"}), Collections.emptyList());
            this.clock().advance(this.EXCLUDE_TIMEOUT());
            yarnHealthTracker.setSchedulerExcludedNodes((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
            ((AMRMClient)Mockito.verify(this.amClientMock())).updateBlacklist(Collections.emptyList(), Arrays.asList((Object[])new String[]{"host"}));
        }, new Position("YarnAllocatorHealthTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("not handling the expiry of scheduler excluded nodes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            YarnAllocatorNodeHealthTracker yarnHealthTracker = this.createYarnAllocatorHealthTracker(this.createYarnAllocatorHealthTracker$default$1());
            yarnHealthTracker.setSchedulerExcludedNodes((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host1", "host2"})));
            ((AMRMClient)Mockito.verify(this.amClientMock())).updateBlacklist(Arrays.asList((Object[])new String[]{"host1", "host2"}), Collections.emptyList());
            this.clock().advance(200L);
            yarnHealthTracker.setSchedulerExcludedNodes((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host1", "host2"})));
            ((AMRMClient)Mockito.verify(this.amClientMock(), (VerificationMode)Mockito.times((int)0))).updateBlacklist(Collections.emptyList(), Collections.emptyList());
        }, new Position("YarnAllocatorHealthTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.test("combining scheduler and allocation excluded node list", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sparkConf().set(package$.MODULE$.YARN_EXCLUDE_NODES(), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"initial1", "initial2"})));
            YarnAllocatorNodeHealthTracker yarnHealthTracker = this.createYarnAllocatorHealthTracker(this.sparkConf());
            yarnHealthTracker.setSchedulerExcludedNodes((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
            ((AMRMClient)Mockito.verify(this.amClientMock())).updateBlacklist(Arrays.asList((Object[])new String[]{"initial1", "initial2"}), Collections.emptyList());
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.MAX_FAILED_EXEC_PER_NODE_VALUE()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> {
                yarnHealthTracker.handleResourceAllocationFailure((Option)new Some((Object)"host1"));
                ((AMRMClient)Mockito.verify(this.amClientMock(), (VerificationMode)Mockito.never())).updateBlacklist(Arrays.asList((Object[])new String[]{"host1"}), Collections.emptyList());
            });
            yarnHealthTracker.handleResourceAllocationFailure((Option)new Some((Object)"host1"));
            ((AMRMClient)Mockito.verify(this.amClientMock())).updateBlacklist(Arrays.asList((Object[])new String[]{"host1"}), Collections.emptyList());
            yarnHealthTracker.setSchedulerExcludedNodes((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host2", "host3"})));
            ((AMRMClient)Mockito.verify(this.amClientMock())).updateBlacklist(Arrays.asList((Object[])new String[]{"host2", "host3"}), Collections.emptyList());
            this.clock().advance(10L);
            yarnHealthTracker.setSchedulerExcludedNodes((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host3", "host4"})));
            ((AMRMClient)Mockito.verify(this.amClientMock())).updateBlacklist(Arrays.asList((Object[])new String[]{"host4"}), Arrays.asList((Object[])new String[]{"host2"}));
        }, new Position("YarnAllocatorHealthTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("exclude all available nodes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            YarnAllocatorNodeHealthTracker yarnHealthTracker = this.createYarnAllocatorHealthTracker(this.createYarnAllocatorHealthTracker$default$1());
            yarnHealthTracker.setSchedulerExcludedNodes((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host1", "host2", "host3"})));
            ((AMRMClient)Mockito.verify(this.amClientMock())).updateBlacklist(Arrays.asList((Object[])new String[]{"host1", "host2", "host3"}), Collections.emptyList());
            this.clock().advance(60L);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.MAX_FAILED_EXEC_PER_NODE_VALUE()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> {
                yarnHealthTracker.handleResourceAllocationFailure((Option)new Some((Object)"host4"));
                ((AMRMClient)Mockito.verify(this.amClientMock(), (VerificationMode)Mockito.never())).updateBlacklist(Arrays.asList((Object[])new String[]{"host4"}), Collections.emptyList());
            });
            yarnHealthTracker.handleResourceAllocationFailure((Option)new Some((Object)"host4"));
            ((AMRMClient)Mockito.verify(this.amClientMock())).updateBlacklist(Arrays.asList((Object[])new String[]{"host4"}), Collections.emptyList());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(yarnHealthTracker.isAllNodeExcluded(), "yarnHealthTracker.isAllNodeExcluded", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnAllocatorHealthTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        }, new Position("YarnAllocatorHealthTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
    }
}

