/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import java.io.Serializable;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.spark.LocalSparkContext;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.TestUtils$;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.TestFilter2;
import org.apache.spark.scheduler.cluster.YarnSchedulerBackend;
import org.apache.spark.serializer.JavaSerializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.ui.TestFilter;
import org.apache.spark.ui.WebUI;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatestplus.mockito.MockitoSugar;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001\u0002\n\u0014\u0001yAQA\f\u0001\u0005\u0002=B\u0011B\r\u0001A\u0002\u0003\u0007I\u0011B\u001a\t\u0013]\u0002\u0001\u0019!a\u0001\n\u0013A\u0004\"C!\u0001\u0001\u0004\u0005\t\u0015)\u00035\u0011\u0015\u0011\u0005\u0001\"\u0011D\r\u0011!\u0005\u0001B#\t\u0011)3!\u0011!Q\u0001\n-CQA\f\u0004\u0005\u00029CqA\u0015\u0004C\u0002\u0013\u00051\u000b\u0003\u0004o\r\u0001\u0006I\u0001\u0016\u0005\u0006_\u001a!\t\u0001\u001d\u0005\u0006g\u001a!\t\u0005\u001e\u0004\u0005k\u0002!a\u000f\u0003\u0005\u0017\u001b\t\u0005\t\u0015!\u0003G\u0011!QUB!A!\u0002\u0013Y\u0005\"\u0002\u0018\u000e\t\u00039\b\"B>\u000e\t\u0003a(!G-be:\u001c6\r[3ek2,'OQ1dW\u0016tGmU;ji\u0016T!\u0001F\u000b\u0002\u000f\rdWo\u001d;fe*\u0011acF\u0001\ng\u000eDW\rZ;mKJT!\u0001G\r\u0002\u000bM\u0004\u0018M]6\u000b\u0005iY\u0012AB1qC\u000eDWMC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\u0011\u0001qdI\u0016\u0011\u0005\u0001\nS\"A\f\n\u0005\t:\"!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002%S5\tQE\u0003\u0002'O\u00059Qn\\2lSR|'B\u0001\u0015\u001c\u00035\u00198-\u00197bi\u0016\u001cH\u000f\u001d7vg&\u0011!&\n\u0002\r\u001b>\u001c7.\u001b;p'V<\u0017M\u001d\t\u0003A1J!!L\f\u0003#1{7-\u00197Ta\u0006\u00148nQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0002aA\u0011\u0011\u0007A\u0007\u0002'\u0005!\u00120\u0019:o'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012,\u0012\u0001\u000e\t\u0003cUJ!AN\n\u0003)e\u000b'O\\*dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e\u0003aI\u0018M\u001d8TG\",G-\u001e7fe\n\u000b7m[3oI~#S-\u001d\u000b\u0003s}\u0002\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012A!\u00168ji\"9\u0001iAA\u0001\u0002\u0004!\u0014a\u0001=%c\u0005)\u00120\u0019:o'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012\u0004\u0013!C1gi\u0016\u0014X)Y2i)\u0005I$!\u0006+fgR$\u0016m]6TG\",G-\u001e7fe&k\u0007\u000f\\\n\u0003\r\u0019\u0003\"a\u0012%\u000e\u0003UI!!S\u000b\u0003#Q\u000b7o[*dQ\u0016$W\u000f\\3s\u00136\u0004H.\u0001\u0002tGB\u0011\u0001\u0005T\u0005\u0003\u001b^\u0011Ab\u00159be.\u001cuN\u001c;fqR$\"aT)\u0011\u0005A3Q\"\u0001\u0001\t\u000b)C\u0001\u0019A&\u0002#\u0015D8\r\\;eK\u0012tu\u000eZ3t\u0019&\u001cH/F\u0001U!\r)f\fY\u0007\u0002-*\u0011q\u000bW\u0001\u0007CR|W.[2\u000b\u0005eS\u0016AC2p]\u000e,(O]3oi*\u00111\fX\u0001\u0005kRLGNC\u0001^\u0003\u0011Q\u0017M^1\n\u0005}3&aD!u_6L7MU3gKJ,gnY3\u0011\u0007\u0005D7N\u0004\u0002cMB\u00111mO\u0007\u0002I*\u0011Q-H\u0001\u0007yI|w\u000e\u001e \n\u0005\u001d\\\u0014A\u0002)sK\u0012,g-\u0003\u0002jU\n\u00191+\u001a;\u000b\u0005\u001d\\\u0004CA1m\u0013\ti'N\u0001\u0004TiJLgnZ\u0001\u0013Kb\u001cG.\u001e3fI:{G-Z:MSN$\b%\u0001\ntKRtu\u000eZ3Fq\u000edW\u000fZ3MSN$HCA\u001dr\u0011\u0015\u00118\u00021\u0001a\u0003=qw\u000eZ3Fq\u000edW\u000fZ3MSN$\u0018!D3yG2,H-\u001a3O_\u0012,7\u000fF\u0001a\u0005a!Vm\u001d;ZCJt7k\u00195fIVdWM\u001d\"bG.,g\u000eZ\n\u0003\u001bQ\"2\u0001_={!\t\u0001V\u0002C\u0003\u0017!\u0001\u0007a\tC\u0003K!\u0001\u00071*A\ftKRDun\u001d;U_2{7-\u00197UCN\\7i\\;oiR\u0011\u0011( \u0005\u0006}F\u0001\ra`\u0001\u0015Q>\u001cH\u000fV8M_\u000e\fG\u000eV1tW\u000e{WO\u001c;\u0011\u000f\u0005\f\t!!\u0002\u0002\f%\u0019\u00111\u00016\u0003\u00075\u000b\u0007\u000fE\u0002;\u0003\u000fI1!!\u0003<\u0005\rIe\u000e\u001e\t\u0007C\u0006\u00051.!\u0002")
public class YarnSchedulerBackendSuite
extends SparkFunSuite
implements MockitoSugar,
LocalSparkContext {
    private YarnSchedulerBackend yarnSchedulerBackend;
    private transient SparkContext sc;

    public /* synthetic */ void org$apache$spark$LocalSparkContext$$super$beforeAll() {
        super.beforeAll();
    }

    public /* synthetic */ void org$apache$spark$LocalSparkContext$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public void beforeAll() {
        LocalSparkContext.beforeAll$((LocalSparkContext)this);
    }

    public void resetSparkContext() {
        LocalSparkContext.resetSparkContext$((LocalSparkContext)this);
    }

    public <T> T mock(ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, classTag);
    }

    public <T> T mock(Answer<?> defaultAnswer, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, defaultAnswer, classTag);
    }

    public <T> T mock(MockSettings mockSettings, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (MockSettings)mockSettings, classTag);
    }

    public <T> T mock(String name, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (String)name, classTag);
    }

    public SparkContext sc() {
        return this.sc;
    }

    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    private YarnSchedulerBackend yarnSchedulerBackend() {
        return this.yarnSchedulerBackend;
    }

    private void yarnSchedulerBackend_$eq(YarnSchedulerBackend x$1) {
        this.yarnSchedulerBackend = x$1;
    }

    public void afterEach() {
        try {
            if (this.yarnSchedulerBackend() != null) {
                this.yarnSchedulerBackend().stop();
            }
        }
        finally {
            LocalSparkContext.afterEach$((LocalSparkContext)this);
        }
    }

    public static final /* synthetic */ void $anonfun$new$2(YarnSchedulerBackendSuite $this, ResourceProfile defaultResourceProf$1, TestYarnSchedulerBackend yarnSchedulerBackendExtended$1, TestTaskSchedulerImpl sched$1, SerializerInstance ser$1, Set excludelist) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)numRequested -> ((IterableLike)package$.MODULE$.IndexedSeq().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)defaultResourceProf$1.id())), (Object)Predef$.MODULE$.Map().empty())})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)defaultResourceProf$1.id())), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)2))})))}))}))).foreach((Function1 & Serializable & scala.Serializable)hostToLocalCount -> {
            yarnSchedulerBackendExtended$1.setHostToLocalTaskCount((Map<Object, Map<String, Object>>)hostToLocalCount);
            sched$1.setNodeExcludeList((Set<String>)excludelist);
            Map request = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultResourceProf$1), (Object)BoxesRunTime.boxToInteger((int)numRequested))}));
            CoarseGrainedClusterMessages.RequestExecutors req = yarnSchedulerBackendExtended$1.prepareRequestExecutors(request);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(req.resourceProfileToTotalExecs().apply((Object)defaultResourceProf$1));
            int $org_scalatest_assert_macro_right = numRequested;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(req.excludedNodes());
            Set $org_scalatest_assert_macro_right2 = excludelist;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            Set hosts = ((MapLike)req.hostToLocalTaskCount().apply((Object)BoxesRunTime.boxToInteger((int)ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID()))).keySet();
            Set $org_scalatest_assert_macro_left3 = (Set)hosts.intersect((GenSet)excludelist);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            return ser$1.serialize((Object)req, ClassTag$.MODULE$.apply(CoarseGrainedClusterMessages.RequestExecutors.class));
        }));
    }

    public YarnSchedulerBackendSuite() {
        MockitoSugar.$init$((MockitoSugar)this);
        LocalSparkContext.$init$((LocalSparkContext)this);
        this.test("RequestExecutors reflects node excludelist and is serializable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sc_$eq(new SparkContext("local", "YarnSchedulerBackendSuite"));
            TestTaskSchedulerImpl sched = new TestTaskSchedulerImpl(this.sc());
            TestYarnSchedulerBackend yarnSchedulerBackendExtended = new TestYarnSchedulerBackend(sched, this.sc());
            this.yarnSchedulerBackend_$eq(yarnSchedulerBackendExtended);
            SerializerInstance ser = new JavaSerializer(this.sc().conf()).newInstance();
            ResourceProfile defaultResourceProf = ResourceProfile$.MODULE$.getOrCreateDefaultProfile(this.sc().getConf());
            ((IterableLike)package$.MODULE$.IndexedSeq().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Set[]{(Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))}))).foreach((Function1 & Serializable & scala.Serializable)excludelist -> {
                YarnSchedulerBackendSuite.$anonfun$new$2(this, defaultResourceProf, yarnSchedulerBackendExtended, sched, ser, excludelist);
                return BoxedUnit.UNIT;
            });
        }, new Position("YarnSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("Respect user filters when adding AM IP filter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf(false).set("spark.ui.filters", TestFilter.class.getName()).set(new StringBuilder(25).append("spark.").append(TestFilter.class.getName()).append(".param.responseCode").toString(), ((Object)BoxesRunTime.boxToInteger((int)502)).toString());
            this.sc_$eq(new SparkContext("local", "YarnSchedulerBackendSuite", conf));
            TaskSchedulerImpl sched = (TaskSchedulerImpl)this.mock(ClassTag$.MODULE$.apply(TaskSchedulerImpl.class));
            Mockito.when((Object)sched.sc()).thenReturn((Object)this.sc());
            URL url = new URL((String)this.sc().uiWebUrl().get());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.httpResponseCode(url, TestUtils$.MODULE$.httpResponseCode$default$2(), TestUtils$.MODULE$.httpResponseCode$default$3())));
            int $org_scalatest_assert_macro_right = 502;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            this.yarnSchedulerBackend_$eq(new YarnSchedulerBackend(this, sched){});
            this.yarnSchedulerBackend().addWebUIFilter(TestFilter2.class.getName(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"responseCode"), (Object)((Object)BoxesRunTime.boxToInteger((int)406)).toString())})), "");
            ((WebUI)this.sc().ui().get()).getDelegatingHandlers().foreach((Function1 & Serializable & scala.Serializable)h -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)h.filterCount()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.httpResponseCode(url, TestUtils$.MODULE$.httpResponseCode$default$2(), TestUtils$.MODULE$.httpResponseCode$default$3())));
            int $org_scalatest_assert_macro_right2 = 406;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            HttpServlet servlet = new HttpServlet(null){

                public void doGet(HttpServletRequest req, HttpServletResponse res) {
                    res.sendError(409);
                }
            };
            ((WebUI)this.sc().ui().get()).attachHandler("/new-handler", servlet, "/");
            URL newUrl = new URL(new StringBuilder(13).append((String)this.sc().uiWebUrl().get()).append("/new-handler/").toString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.httpResponseCode(newUrl, TestUtils$.MODULE$.httpResponseCode$default$2(), TestUtils$.MODULE$.httpResponseCode$default$3())));
            int $org_scalatest_assert_macro_right3 = 406;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            URL bypassUrl = new URL(new StringBuilder(20).append((String)this.sc().uiWebUrl().get()).append("/new-handler/?bypass").toString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.httpResponseCode(bypassUrl, TestUtils$.MODULE$.httpResponseCode$default$2(), TestUtils$.MODULE$.httpResponseCode$default$3())));
            int $org_scalatest_assert_macro_right4 = 409;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        }, new Position("YarnSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
    }

    public class TestTaskSchedulerImpl
    extends TaskSchedulerImpl {
        private final AtomicReference<Set<String>> excludedNodesList;

        public AtomicReference<Set<String>> excludedNodesList() {
            return this.excludedNodesList;
        }

        public void setNodeExcludeList(Set<String> nodeExcludeList) {
            this.excludedNodesList().set(nodeExcludeList);
        }

        public Set<String> excludedNodes() {
            return this.excludedNodesList().get();
        }

        public /* synthetic */ YarnSchedulerBackendSuite org$apache$spark$scheduler$cluster$YarnSchedulerBackendSuite$TestTaskSchedulerImpl$$$outer() {
            return YarnSchedulerBackendSuite.this;
        }

        public TestTaskSchedulerImpl(SparkContext sc) {
            if (YarnSchedulerBackendSuite.this == null) {
                throw null;
            }
            super(sc);
            this.excludedNodesList = new AtomicReference();
        }
    }

    public class TestYarnSchedulerBackend
    extends YarnSchedulerBackend {
        public void setHostToLocalTaskCount(Map<Object, Map<String, Object>> hostToLocalTaskCount) {
            this.rpHostToLocalTaskCount_$eq(hostToLocalTaskCount);
        }

        public /* synthetic */ YarnSchedulerBackendSuite org$apache$spark$scheduler$cluster$YarnSchedulerBackendSuite$TestYarnSchedulerBackend$$$outer() {
            return YarnSchedulerBackendSuite.this;
        }

        public TestYarnSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc) {
            if (YarnSchedulerBackendSuite.this == null) {
                throw null;
            }
            super(scheduler, sc);
        }
    }
}

